/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.logic;

import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import tconstruct.TConstruct;
import tconstruct.library.blocks.InventoryLogic;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.util.IPattern;

public class CastingTableLogic
extends InventoryLogic
implements IFluidTank,
IFluidHandler,
ISidedInventory {
    public FluidStack liquid;
    int castingDelay = 0;
    int renderOffset = 0;
    int capacity = 0;
    boolean needsUpdate;
    boolean init = true;
    int tick;

    public CastingTableLogic() {
        super(2);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public String func_70303_b() {
        return null;
    }

    @Override
    protected String getDefaultName() {
        return null;
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return null;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int updateCapacity() {
        int cost;
        int ret = 144;
        ItemStack inv = this.inventory[0];
        ret = inv != null && inv.func_77973_b() instanceof IPattern ? ((cost = ((IPattern)inv.func_77973_b()).getPatternCost(inv)) > 0 ? (int)((double)ret * ((double)((IPattern)inv.func_77973_b()).getPatternCost(inv) * 0.5)) : TConstruct.tableCasting.getCastingAmount(this.liquid, inv)) : TConstruct.tableCasting.getCastingAmount(this.liquid, inv);
        TConstruct.logger.info("Ret: " + ret);
        return ret;
    }

    public int updateCapacity(int capacity) {
        int cost;
        int ret = 144;
        ItemStack inv = this.inventory[0];
        ret = inv != null && inv.func_77973_b() instanceof IPattern ? ((cost = ((IPattern)inv.func_77973_b()).getPatternCost(inv)) > 0 ? (int)((double)ret * ((double)((IPattern)inv.func_77973_b()).getPatternCost(inv) * 0.5)) : capacity) : capacity;
        return ret;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.liquid == null) {
            CastingRecipe recipe = TConstruct.tableCasting.getCastingRecipe(resource, this.inventory[0]);
            if (recipe == null) {
                return 0;
            }
            this.capacity = this.updateCapacity(recipe.castingMetal.amount);
            if (this.inventory[1] == null) {
                FluidStack copyLiquid = resource.copy();
                if (copyLiquid.amount > this.capacity) {
                    copyLiquid.amount = this.capacity;
                }
                if (doFill) {
                    if (copyLiquid.amount == this.capacity) {
                        this.castingDelay = recipe.coolTime;
                    }
                    this.renderOffset = copyLiquid.amount;
                    this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                    this.liquid = copyLiquid;
                    this.needsUpdate = true;
                }
                return copyLiquid.amount;
            }
            return 0;
        }
        if (resource.isFluidEqual(this.liquid)) {
            if (resource.amount + this.liquid.amount >= this.capacity) {
                int roomInTank = this.capacity - this.liquid.amount;
                if (doFill && roomInTank > 0) {
                    this.renderOffset = roomInTank;
                    this.castingDelay = TConstruct.tableCasting.getCastingDelay(this.liquid, this.inventory[0]);
                    this.liquid.amount = this.capacity;
                    this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                    this.needsUpdate = true;
                }
                return roomInTank;
            }
            if (doFill) {
                this.liquid.amount += resource.amount;
                this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.needsUpdate = true;
            }
            return resource.amount;
        }
        return 0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.needsUpdate = true;
    }

    @Override
    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack stack = super.func_70298_a(slot, quantity);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return stack;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid == null || this.liquid.fluidID <= 0 || this.castingDelay > 0) {
            return null;
        }
        if (this.liquid.amount <= 0) {
            return null;
        }
        int used = maxDrain;
        if (this.liquid.amount < used) {
            used = this.liquid.amount;
        }
        if (doDrain) {
            this.liquid.amount -= used;
        }
        FluidStack drained = this.liquid.copy();
        drained.amount = used;
        if (this.liquid.amount <= 0) {
            this.liquid = null;
        }
        if (doDrain) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(drained, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, (IFluidTank)this));
        }
        return drained;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getInfo()};
    }

    public FluidStack getFluid() {
        return this.liquid == null ? null : this.liquid.copy();
    }

    public int getFluidAmount() {
        return this.liquid != null ? this.liquid.amount : 0;
    }

    public FluidTankInfo getInfo() {
        FluidTankInfo info = new FluidTankInfo((IFluidTank)this);
        return info;
    }

    public int getLiquidAmount() {
        return this.liquid.amount - this.renderOffset;
    }

    public void func_70316_g() {
        if (this.castingDelay > 0) {
            --this.castingDelay;
            if (this.castingDelay == 0) {
                this.castLiquid();
            }
        }
        if (this.renderOffset > 0) {
            this.renderOffset -= 6;
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        ++this.tick;
        if (this.tick % 20 == 0) {
            this.tick = 0;
            if (this.needsUpdate) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    public void castLiquid() {
        CastingRecipe recipe = TConstruct.tableCasting.getCastingRecipe(this.liquid, this.inventory[0]);
        if (recipe != null) {
            this.inventory[1] = recipe.getResult();
            if (recipe.consumeCast) {
                this.inventory[0] = null;
            }
            this.liquid = null;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.liquid = tags.func_74767_n("hasLiquid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags.func_74775_l("Fluid")) : null;
        this.capacity = tags.func_74767_n("Initialized") ? tags.func_74762_e("Capacity") : this.updateCapacity();
        this.castingDelay = tags.func_74762_e("castingDelay");
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeCustomNBT(tags);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74757_a("hasLiquid", this.liquid != null);
        if (this.liquid != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.liquid.writeToNBT(nbt);
            tags.func_74766_a("Fluid", nbt);
        }
        tags.func_74757_a("Initialized", this.init);
        tags.func_74768_a("Capacity", this.capacity);
        tags.func_74768_a("castingDelay", this.castingDelay);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (this.liquid != null) {
            return false;
        }
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return slot == 1;
    }
}

