/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.logic;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import tconstruct.inventory.FurnaceContainer;
import tconstruct.library.blocks.InventoryLogic;
import tconstruct.library.util.IActiveLogic;
import tconstruct.library.util.IFacingLogic;

public class FurnaceLogic
extends InventoryLogic
implements IActiveLogic,
IFacingLogic,
ISidedInventory {
    boolean active = false;
    public int fuel;
    public int fuelGague;
    public int progress;
    public int fuelScale = 200;
    byte direction;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{2, 1};
    private static final int[] slots_sides = new int[]{1};

    public FurnaceLogic() {
        super(3);
    }

    @Override
    public String getDefaultName() {
        return "container.furnace";
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean flag) {
        this.active = flag;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.fuelScale;
    }

    public int gaugeFuelScaled(int scale) {
        if (this.fuelGague == 0) {
            this.fuelGague = this.fuel;
            if (this.fuelGague == 0) {
                this.fuelGague = this.fuelScale;
            }
        }
        return this.fuel * scale / this.fuelGague;
    }

    public void func_70316_g() {
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.fuel <= 0 && this.canSmelt()) {
            this.fuel = this.fuelGague = FurnaceLogic.getItemBurnTime(this.inventory[1]);
            if (this.fuel > 0) {
                if (this.inventory[1].func_77973_b().func_77634_r()) {
                    this.inventory[1] = new ItemStack(this.inventory[1].func_77973_b().func_77668_q());
                } else {
                    --this.inventory[1].field_77994_a;
                }
                if (this.inventory[1].field_77994_a <= 0) {
                    this.inventory[1] = null;
                }
                updateInventory = true;
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.progress;
            if (this.progress >= this.fuelScale) {
                this.progress = 0;
                this.cookItems();
                updateInventory = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (burning != this.isBurning()) {
            this.setActive(this.isBurning());
            updateInventory = true;
        }
        if (updateInventory) {
            this.func_70296_d();
        }
    }

    public void cookItems() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().getSmeltingResult(this.inventory[0]);
            if (this.inventory[2] == null) {
                this.inventory[2] = itemstack.func_77946_l();
            } else if (this.inventory[2].func_77969_a(itemstack)) {
                this.inventory[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
        }
    }

    public boolean canSmelt() {
        if (this.inventory[0] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().getSmeltingResult(this.inventory[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.inventory[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public ItemStack getResultFor(ItemStack stack) {
        ItemStack result = FurnaceRecipes.func_77602_a().getSmeltingResult(stack);
        if (result != null) {
            return result.func_77946_l();
        }
        return null;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        int i = stack.func_77973_b().field_77779_bT;
        Item item = stack.func_77973_b();
        if (stack.func_77973_b() instanceof ItemBlock && Block.field_71973_m[i] != null) {
            Block block = Block.field_71973_m[i];
            if (block == Block.field_72092_bO) {
                return 150;
            }
            if (block == Block.field_71951_J) {
                return 1200;
            }
            if (block.field_72018_cp == Material.field_76245_d) {
                return 300;
            }
            if (block == Block.field_111034_cE) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_77825_f().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (i == Item.field_77669_D.field_77779_bT) {
            return 100;
        }
        if (i == Item.field_77705_m.field_77779_bT) {
            return 1600;
        }
        if (i == Item.field_77775_ay.field_77779_bT) {
            return 20000;
        }
        if (i == Block.field_71987_y.field_71990_ca) {
            return 100;
        }
        if (i == Item.field_77731_bo.field_77779_bT) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.active = tags.func_74767_n("Active");
        this.fuel = tags.func_74762_e("Fuel");
        this.fuelGague = tags.func_74762_e("FuelGague");
        this.readNetworkNBT(tags);
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        tags.func_74757_a("Active", this.active);
        tags.func_74768_a("Fuel", this.fuel);
        tags.func_74768_a("FuelGague", this.fuelGague);
        this.writeNetworkNBT(tags);
    }

    public void readNetworkNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
    }

    public void writeNetworkNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeNetworkNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readNetworkNBT(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new FurnaceContainer(inventoryplayer, this);
    }

    @Override
    public byte getRenderDirection() {
        return this.direction;
    }

    @Override
    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    @Override
    @Deprecated
    public void setDirection(int side) {
    }

    @Override
    @Deprecated
    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
        switch (facing) {
            case 0: {
                this.direction = (byte)2;
                break;
            }
            case 1: {
                this.direction = (byte)5;
                break;
            }
            case 2: {
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.direction = (byte)4;
            }
        }
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return FurnaceLogic.getItemBurnTime(par0ItemStack) > 0;
    }

    @Override
    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 2 ? false : (par1 == 1 ? FurnaceLogic.isItemFuel(par2ItemStack) : true);
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? slots_bottom : (par1 == 1 ? slots_top : slots_sides);
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return par3 != 0 || par1 != 1 || par2ItemStack.field_77993_c == Item.field_77788_aw.field_77779_bT;
    }
}

