/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.lwjgl.opengl.GL11;
import tconstruct.blocks.logic.CastingChannelLogic;
import tconstruct.client.block.BlockSkinRenderHelper;

public class BlockRenderCastingChannel
implements ISimpleBlockRenderingHandler {
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        renderer.func_83020_a(0.3125, 0.375, 0.3125, 0.6875, 0.5, 0.6875);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.3125, 0.375, 0.0, 0.6875, 0.5, 0.3125);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.3125, 0.5, 0.0, 0.375, 0.625, 0.3125);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.625, 0.5, 0.0, 0.6875, 0.625, 0.3125);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.3125, 0.375, 0.6875, 0.6875, 0.5, 1.0);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.3125, 0.5, 0.6875, 0.375, 0.625, 1.0);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.625, 0.5, 0.6875, 0.6875, 0.625, 1.0);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.3125, 0.375, 0.3125, 0.375, 0.625, 0.6875);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.625, 0.375, 0.3125, 0.6875, 0.625, 0.6875);
        this.renderStandardBlock(block, metadata, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == renderID) {
            FluidTankInfo tankSub;
            ForgeDirection dir;
            double[] bounds;
            CastingChannelLogic tile = (CastingChannelLogic)world.func_72796_p(x, y, z);
            Set<ForgeDirection> outputs = tile.getOutputs().keySet();
            if (!outputs.contains(ForgeDirection.DOWN)) {
                renderer.func_83020_a(0.3125, 0.375, 0.3125, 0.6875, 0.5, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            } else {
                renderer.func_83020_a(0.375, 0.125, 0.3125, 0.625, 0.5, 0.375);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.375, 0.125, 0.625, 0.625, 0.5, 0.6875);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.3125, 0.125, 0.3125, 0.375, 0.5, 0.6875);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.625, 0.125, 0.3125, 0.6875, 0.5, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            }
            if (outputs.contains(ForgeDirection.NORTH)) {
                renderer.func_83020_a(0.3125, 0.375, 0.0, 0.6875, 0.5, 0.3125);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.3125, 0.5, 0.0, 0.375, 0.625, 0.3125);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.625, 0.5, 0.0, 0.6875, 0.625, 0.3125);
                renderer.func_78570_q(block, x, y, z);
            } else {
                renderer.func_83020_a(0.375, 0.5, 0.3125, 0.625, 0.625, 0.375);
                renderer.func_78570_q(block, x, y, z);
            }
            if (outputs.contains(ForgeDirection.SOUTH)) {
                renderer.func_83020_a(0.3125, 0.375, 0.6875, 0.6875, 0.5, 1.0);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.3125, 0.5, 0.6875, 0.375, 0.625, 1.0);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.625, 0.5, 0.6875, 0.6875, 0.625, 1.0);
                renderer.func_78570_q(block, x, y, z);
            } else {
                renderer.func_83020_a(0.375, 0.5, 0.625, 0.625, 0.625, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            }
            if (outputs.contains(ForgeDirection.WEST)) {
                renderer.func_83020_a(0.0, 0.375, 0.3125, 0.3125, 0.5, 0.6875);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.0, 0.5, 0.3125, 0.375, 0.625, 0.375);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.0, 0.5, 0.625, 0.375, 0.625, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            } else {
                renderer.func_83020_a(0.3125, 0.5, 0.3125, 0.375, 0.625, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            }
            if (outputs.contains(ForgeDirection.EAST)) {
                renderer.func_83020_a(0.6875, 0.375, 0.3125, 1.0, 0.5, 0.6875);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.625, 0.5, 0.3125, 1.0, 0.625, 0.375);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.625, 0.5, 0.625, 1.0, 0.625, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            } else {
                renderer.func_83020_a(0.625, 0.5, 0.3125, 0.6875, 0.625, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            }
            FluidTankInfo tankMain = tile.getTankInfo(null)[0];
            if (tankMain.fluid != null) {
                float liquidAmount = (float)tankMain.fluid.amount / (float)tankMain.capacity * 0.125f;
                double startY = tile.tankBelow();
                renderer.func_83020_a(0.375, startY, 0.375, 0.625, 0.51 + (double)liquidAmount, 0.625);
                this.renderLiquidPart(world, x, y, z, block, renderer, tankMain.fluid, false);
            }
            Iterator<ForgeDirection> i$ = outputs.iterator();
            while (i$.hasNext() && (bounds = this.getRenderboundsForLiquid(dir = i$.next())) != null && (tankSub = tile.getTankInfo(dir)[0]) != null && tankSub.fluid != null) {
                float liquidAmount = (float)tankSub.fluid.amount / (float)tankSub.capacity * 0.125f / 2.0f;
                renderer.func_83020_a(bounds[0], 0.5, bounds[1], bounds[2], 0.51 + (double)liquidAmount, bounds[3]);
                this.renderLiquidPart(world, x, y, z, block, renderer, tankSub.fluid, false);
            }
        }
        return true;
    }

    private double[] getRenderboundsForLiquid(ForgeDirection dir) {
        switch (dir) {
            case NORTH: {
                return new double[]{0.375, 0.0, 0.625, 0.375};
            }
            case SOUTH: {
                return new double[]{0.375, 0.625, 0.625, 1.0};
            }
            case WEST: {
                return new double[]{0.0, 0.375, 0.375, 0.625};
            }
            case EAST: {
                return new double[]{0.625, 0.375, 1.0, 0.625};
            }
        }
        return null;
    }

    private void renderLiquidPart(IBlockAccess world, int x, int y, int z, Block block, RenderBlocks renderer, FluidStack fluidStack, boolean useFlowingTexture) {
        int color = block.func_71920_b(world, x, y, z);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        Fluid fluid = fluidStack.getFluid();
        if (fluid.canBePlacedInWorld() && !useFlowingTexture) {
            BlockSkinRenderHelper.renderMetadataBlock(Block.field_71973_m[fluid.getBlockID()], 0, x, y, z, renderer, world);
        } else if (useFlowingTexture) {
            BlockSkinRenderHelper.renderLiquidBlock(fluid.getFlowingIcon(), fluid.getFlowingIcon(), x, y, z, renderer, world);
        } else {
            BlockSkinRenderHelper.renderLiquidBlock(fluid.getStillIcon(), fluid.getFlowingIcon(), x, y, z, renderer, world);
        }
    }

    private void renderStandardBlock(Block block, int meta, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_78613_a(block, 0.0, 0.0, 0.0, block.func_71858_a(0, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_78617_b(block, 0.0, 0.0, 0.0, block.func_71858_a(1, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_78611_c(block, 0.0, 0.0, 0.0, block.func_71858_a(2, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_78622_d(block, 0.0, 0.0, 0.0, block.func_71858_a(3, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_78573_e(block, 0.0, 0.0, 0.0, block.func_71858_a(4, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_78605_f(block, 0.0, 0.0, 0.0, block.func_71858_a(5, meta));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return renderID;
    }
}

