/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.entity;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockRail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CartEntity
extends Entity
implements IInventory,
IEntityAdditionalSpawnData {
    protected ItemStack[] cargoItems = new ItemStack[36];
    protected int fuel = 0;
    protected boolean field_70499_f = false;
    private int pullcartType;
    public double pushX;
    public double pushZ;
    protected boolean field_82345_h = true;
    protected static final int[][][] matrix = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    protected int turnProgress;
    protected double minecartX;
    protected double minecartY;
    protected double minecartZ;
    protected double minecartYaw;
    protected double minecartPitch;
    @SideOnly(value=Side.CLIENT)
    protected double velocityX;
    @SideOnly(value=Side.CLIENT)
    protected double velocityY;
    @SideOnly(value=Side.CLIENT)
    protected double velocityZ;
    public static float defaultMaxSpeedRail = 0.4f;
    public static float defaultMaxSpeedGround = 0.4f;
    public static float defaultMaxSpeedAirLateral = 0.4f;
    public static float defaultMaxSpeedAirVertical = -1.0f;
    public static double defaultDragRidden = 0.997f;
    public static double defaultDragEmpty = 0.96f;
    public static double defaultDragAir = 0.95f;
    protected boolean canUseRail = true;
    protected boolean canBePushed = true;
    protected float maxSpeedRail;
    protected float maxSpeedGround;
    protected float maxSpeedAirLateral;
    protected float maxSpeedAirVertical;
    protected double dragAir;
    Entity entityFollowing;

    public CartEntity(World par1World) {
        super(par1World);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.7f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.field_70138_W = 1.0f;
        this.maxSpeedRail = defaultMaxSpeedRail;
        this.maxSpeedGround = defaultMaxSpeedGround;
        this.maxSpeedAirLateral = defaultMaxSpeedAirLateral;
        this.maxSpeedAirVertical = defaultMaxSpeedAirVertical;
        this.dragAir = defaultDragAir;
    }

    public CartEntity(World world, int type) {
        this(world);
        this.pullcartType = type;
    }

    public CartEntity(World world, double x, double y, double z, int type) {
        this(world);
        this.func_70107_b(x, y + (double)this.field_70129_M, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.pullcartType = type;
        this.field_70138_W = 1.0f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(0));
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return par1Entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return this.canBePushed;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.0 - (double)0.3f;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.func_85032_ar()) {
                return false;
            }
            this.func_70494_i(-this.func_70493_k());
            this.func_70497_h(10);
            this.func_70018_K();
            this.setDamage(this.getDamage() + par2 * 10);
            if (par1DamageSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.setDamage(100);
            }
            if (this.getDamage() > 40) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.func_70106_y();
                this.dropCartAsItem();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70106_y() {
        if (this.field_82345_h) {
            for (int var1 = 0; var1 < this.func_70302_i_(); ++var1) {
                ItemStack var2 = this.func_70301_a(var1);
                if (var2 == null) continue;
                float var3 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
                float var4 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
                float var5 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
                while (var2.field_77994_a > 0) {
                    int var6 = this.field_70146_Z.nextInt(21) + 10;
                    if (var6 > var2.field_77994_a) {
                        var6 = var2.field_77994_a;
                    }
                    var2.field_77994_a -= var6;
                    EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)var3, this.field_70163_u + (double)var4, this.field_70161_v + (double)var5, new ItemStack(var2.field_77993_c, var6, var2.func_77960_j()));
                    if (var2.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)var2.func_77978_p().func_74737_b());
                    }
                    float var8 = 0.05f;
                    entityitem.field_70159_w = (float)this.field_70146_Z.nextGaussian() * var8;
                    entityitem.field_70181_x = (float)this.field_70146_Z.nextGaussian() * var8 + 0.2f;
                    entityitem.field_70179_y = (float)this.field_70146_Z.nextGaussian() * var8;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_70106_y();
    }

    public void func_71027_c(int par1) {
        this.field_82345_h = false;
        super.func_71027_c(par1);
    }

    public void func_70071_h_() {
        int var2;
        if (this.func_70496_j() > 0) {
            this.func_70497_h(this.func_70496_j() - 1);
        }
        if (this.getDamage() > 0) {
            this.setDamage(this.getDamage() - 1);
        }
        if (this.field_70163_u < -64.0) {
            this.func_70076_C();
        }
        if (this.isMinecartPowered() && this.field_70146_Z.nextInt(4) == 0 && this.pullcartType == 2 && ((Object)((Object)this)).getClass() == CartEntity.class) {
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u + 0.8, this.field_70161_v, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof WorldServer) {
            this.field_70170_p.field_72984_F.func_76320_a("portal");
            MinecraftServer var1 = ((WorldServer)this.field_70170_p).func_73046_m();
            var2 = this.func_82145_z();
            if (!this.field_71087_bX || var1.func_71255_r()) {
                // empty if block
            }
            if (this.field_71088_bW > 0) {
                --this.field_71088_bW;
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.turnProgress > 0) {
                double var46 = this.field_70165_t + (this.minecartX - this.field_70165_t) / (double)this.turnProgress;
                double var48 = this.field_70163_u + (this.minecartY - this.field_70163_u) / (double)this.turnProgress;
                double var5 = this.field_70161_v + (this.minecartZ - this.field_70161_v) / (double)this.turnProgress;
                double var7 = MathHelper.func_76138_g((double)(this.minecartYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + var7 / (double)this.turnProgress);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.minecartPitch - (double)this.field_70125_A) / (double)this.turnProgress);
                --this.turnProgress;
                this.func_70107_b(var46, var48, var5);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else {
            double var51;
            int var47;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70181_x -= (double)0.04f;
            int var45 = MathHelper.func_76128_c((double)this.field_70165_t);
            if (BlockRail.func_72180_d_((World)this.field_70170_p, (int)var45, (int)((var2 = MathHelper.func_76128_c((double)this.field_70163_u)) - 1), (int)(var47 = MathHelper.func_76128_c((double)this.field_70161_v)))) {
                --var2;
            }
            double var4 = 0.4;
            double var6 = 0.0078125;
            int var8 = this.field_70170_p.func_72798_a(var45, var2, var47);
            this.moveMinecartOffRail(var45, var2, var47);
            if (this.entityFollowing != null) {
                this.moveTowardsEntity(this.entityFollowing);
            }
            this.func_70017_D();
            this.field_70125_A = 0.0f;
            double var49 = this.field_70169_q - this.field_70165_t;
            double var50 = this.field_70166_s - this.field_70161_v;
            if (var49 * var49 + var50 * var50 > 0.001) {
                this.field_70177_z = (float)(Math.atan2(var50, var49) * 180.0 / Math.PI);
                if (this.field_70499_f) {
                    this.field_70177_z += 180.0f;
                }
            }
            if ((var51 = (double)MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70126_B))) < -170.0 || var51 >= 170.0) {
                this.field_70177_z += 180.0f;
                this.field_70499_f = !this.field_70499_f;
            }
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            AxisAlignedBB box = this.field_70121_D.func_72314_b(0.2, 0.0, 0.2);
            List var15 = this.field_70170_p.func_72839_b((Entity)this, box);
            if (var15 != null && !var15.isEmpty()) {
                for (int var52 = 0; var52 < var15.size(); ++var52) {
                    Entity var17 = (Entity)var15.get(var52);
                    if (var17 == this.field_70153_n || !var17.func_70104_M() || !(var17 instanceof CartEntity)) continue;
                    var17.func_70108_f((Entity)this);
                }
            }
            if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                if (this.field_70153_n.field_70154_o == this) {
                    this.field_70153_n.field_70154_o = null;
                }
                this.field_70153_n = null;
            }
            this.updateFuel();
        }
    }

    void moveTowardsEntity(Entity entity) {
        double var15 = entity.field_70165_t;
        double var19 = entity.field_70161_v;
        if (this.calculateDistance(this.field_70169_q, var15) > 1.5 || this.calculateDistance(this.field_70166_s, var19) > 1.5) {
            double var28 = this.field_70169_q;
            double var30 = this.field_70166_s;
            double var36 = this.calculateDistance(var28, var15);
            double var38 = this.calculateDistance(var30, var19);
            double var40 = 1.0;
            double var42 = 1.0;
            if (var36 > var38) {
                double var46 = 1.0;
                double var44 = var38 / var36;
                var42 = var44 / 3.0;
                var40 = var46 / 3.0;
            } else if (var38 > var36) {
                double var44 = 1.0;
                double var46 = var36 / var38;
                var40 = var46 / 3.0;
                var42 = var44 / 3.0;
            }
            this.field_70159_w = var15 > var28 ? var40 : -var40;
            this.field_70179_y = var19 > var30 ? var42 : -var42;
        }
    }

    public double calculateDistance(double pos1, double pos2) {
        double distance = Math.abs(pos1 - pos2);
        return distance;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_70495_a(double par1, double par3, double par5, double par7) {
        int var11;
        int var10;
        int var9 = MathHelper.func_76128_c((double)par1);
        if (BlockRail.func_72180_d_((World)this.field_70170_p, (int)var9, (int)((var10 = MathHelper.func_76128_c((double)par3)) - 1), (int)(var11 = MathHelper.func_76128_c((double)par5)))) {
            --var10;
        }
        int var12 = this.field_70170_p.func_72798_a(var9, var10, var11);
        return null;
    }

    public Vec3 func_70489_a(double par1, double par3, double par5) {
        int var10;
        int var9;
        int var8;
        int var7 = MathHelper.func_76128_c((double)par1);
        if (BlockRail.func_72180_d_((World)this.field_70170_p, (int)var7, (int)((var8 = MathHelper.func_76128_c((double)par3)) - 1), (int)(var9 = MathHelper.func_76128_c((double)par5)))) {
            --var8;
        }
        if (BlockRail.func_72184_d((int)(var10 = this.field_70170_p.func_72798_a(var7, var8, var9)))) {
            int var11 = 0;
            par3 = var8;
            if (var11 >= 2 && var11 <= 5) {
                par3 = var8 + 1;
            }
            int[][] var12 = matrix[var11];
            double var13 = 0.0;
            double var15 = (double)var7 + 0.5 + (double)var12[0][0] * 0.5;
            double var17 = (double)var8 + 0.5 + (double)var12[0][1] * 0.5;
            double var19 = (double)var9 + 0.5 + (double)var12[0][2] * 0.5;
            double var21 = (double)var7 + 0.5 + (double)var12[1][0] * 0.5;
            double var23 = (double)var8 + 0.5 + (double)var12[1][1] * 0.5;
            double var25 = (double)var9 + 0.5 + (double)var12[1][2] * 0.5;
            double var27 = var21 - var15;
            double var29 = (var23 - var17) * 2.0;
            double var31 = var25 - var19;
            if (var27 == 0.0) {
                par1 = (double)var7 + 0.5;
                var13 = par5 - (double)var9;
            } else if (var31 == 0.0) {
                par5 = (double)var9 + 0.5;
                var13 = par1 - (double)var7;
            } else {
                double var33 = par1 - var15;
                double var35 = par5 - var19;
                var13 = (var33 * var27 + var35 * var31) * 2.0;
            }
            par1 = var15 + var27 * var13;
            par3 = var17 + var29 * var13;
            par5 = var19 + var31 * var13;
            if (var29 < 0.0) {
                par3 += 1.0;
            }
            if (var29 > 0.0) {
                par3 += 0.5;
            }
            return this.field_70170_p.func_82732_R().func_72345_a(par1, par3, par5);
        }
        return null;
    }

    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74768_a("Type", this.pullcartType);
        if (this.isPoweredCart()) {
            par1NBTTagCompound.func_74780_a("PushX", this.pushX);
            par1NBTTagCompound.func_74780_a("PushZ", this.pushZ);
            par1NBTTagCompound.func_74768_a("Fuel", this.fuel);
        }
        if (this.func_70302_i_() > 0) {
            NBTTagList var2 = new NBTTagList();
            for (int var3 = 0; var3 < this.cargoItems.length; ++var3) {
                if (this.cargoItems[var3] == null) continue;
                NBTTagCompound var4 = new NBTTagCompound();
                var4.func_74774_a("Slot", (byte)var3);
                this.cargoItems[var3].func_77955_b(var4);
                var2.func_74742_a((NBTBase)var4);
            }
            par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
        }
    }

    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.pullcartType = par1NBTTagCompound.func_74762_e("Type");
        if (this.isPoweredCart()) {
            this.pushX = par1NBTTagCompound.func_74769_h("PushX");
            this.pushZ = par1NBTTagCompound.func_74769_h("PushZ");
            try {
                this.fuel = par1NBTTagCompound.func_74762_e("Fuel");
            }
            catch (ClassCastException e) {
                this.fuel = par1NBTTagCompound.func_74765_d("Fuel");
            }
        }
        if (this.func_70302_i_() > 0) {
            NBTTagList var2 = par1NBTTagCompound.func_74761_m("Items");
            this.cargoItems = new ItemStack[this.func_70302_i_()];
            for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
                NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
                int var5 = var4.func_74771_c("Slot") & 0xFF;
                if (var5 < 0 || var5 >= this.cargoItems.length) continue;
                this.cargoItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.5f;
    }

    public void func_70108_f(Entity par1Entity) {
        if (!this.field_70170_p.field_72995_K && par1Entity != this.field_70153_n) {
            double var4;
            double var2;
            double var6;
            if (par1Entity instanceof EntityLiving && !(par1Entity instanceof EntityPlayer) && !(par1Entity instanceof EntityIronGolem) && this.canBeRidden() && this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.01 && this.field_70153_n == null && par1Entity.field_70154_o == null) {
                par1Entity.func_70078_a((Entity)this);
            }
            if ((var6 = (var2 = par1Entity.field_70165_t - this.field_70165_t) * var2 + (var4 = par1Entity.field_70161_v - this.field_70161_v) * var4) >= (double)1.0E-4f) {
                var6 = MathHelper.func_76133_a((double)var6);
                var2 /= var6;
                var4 /= var6;
                double var8 = 1.0 / var6;
                if (var8 > 1.0) {
                    var8 = 1.0;
                }
                var2 *= var8;
                var4 *= var8;
                var2 *= (double)0.1f;
                var4 *= (double)0.1f;
                var2 *= (double)(1.0f - this.field_70144_Y);
                var4 *= (double)(1.0f - this.field_70144_Y);
                var2 *= 0.5;
                var4 *= 0.5;
                if (par1Entity instanceof CartEntity) {
                    Vec3 var15;
                    double var10 = par1Entity.field_70165_t - this.field_70165_t;
                    double var12 = par1Entity.field_70161_v - this.field_70161_v;
                    Vec3 var14 = this.field_70170_p.func_82732_R().func_72345_a(var10, 0.0, var12).func_72432_b();
                    double var16 = Math.abs(var14.func_72430_b(var15 = this.field_70170_p.func_82732_R().func_72345_a((double)MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)), 0.0, (double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f))).func_72432_b()));
                    if (var16 < 0.8) {
                        return;
                    }
                    double var18 = par1Entity.field_70159_w + this.field_70159_w;
                    double var20 = par1Entity.field_70179_y + this.field_70179_y;
                    if (((CartEntity)par1Entity).isPoweredCart() && !this.isPoweredCart()) {
                        this.field_70159_w *= (double)0.2f;
                        this.field_70179_y *= (double)0.2f;
                        this.func_70024_g(par1Entity.field_70159_w - var2, 0.0, par1Entity.field_70179_y - var4);
                        par1Entity.field_70159_w *= (double)0.95f;
                        par1Entity.field_70179_y *= (double)0.95f;
                    } else if (!((CartEntity)par1Entity).isPoweredCart() && this.isPoweredCart()) {
                        par1Entity.field_70159_w *= (double)0.2f;
                        par1Entity.field_70179_y *= (double)0.2f;
                        par1Entity.func_70024_g(this.field_70159_w + var2, 0.0, this.field_70179_y + var4);
                        this.field_70159_w *= (double)0.95f;
                        this.field_70179_y *= (double)0.95f;
                    } else {
                        this.field_70159_w *= (double)0.2f;
                        this.field_70179_y *= (double)0.2f;
                        this.func_70024_g((var18 /= 2.0) - var2, 0.0, (var20 /= 2.0) - var4);
                        par1Entity.field_70159_w *= (double)0.2f;
                        par1Entity.field_70179_y *= (double)0.2f;
                        par1Entity.func_70024_g(var18 + var2, 0.0, var20 + var4);
                    }
                } else {
                    this.func_70024_g(-var2, 0.0, -var4);
                    par1Entity.func_70024_g(var2 / 4.0, 0.0, var4 / 4.0);
                }
            }
        }
    }

    public int func_70302_i_() {
        return this.pullcartType == 1 && ((Object)((Object)this)).getClass() == CartEntity.class ? 27 : 0;
    }

    public ItemStack func_70301_a(int par1) {
        return this.cargoItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.cargoItems[par1] != null) {
            if (this.cargoItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.cargoItems[par1];
                this.cargoItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.cargoItems[par1].func_77979_a(par2);
            if (this.cargoItems[par1].field_77994_a == 0) {
                this.cargoItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.cargoItems[par1] != null) {
            ItemStack var2 = this.cargoItems[par1];
            this.cargoItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.cargoItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "container.minecart";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean interact(EntityPlayer player) {
        if (player.func_70093_af()) {
            this.entityFollowing = this.entityFollowing == null ? player : null;
            return true;
        }
        if (this.canBeRidden()) {
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70153_n != player) {
                return true;
            }
            if (!this.field_70170_p.field_72995_K) {
                player.func_70078_a((Entity)this);
            }
        } else if (this.func_70302_i_() > 0) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_71007_a((IInventory)this);
            }
        } else if (this.pullcartType == 2 && ((Object)((Object)this)).getClass() == CartEntity.class) {
            ItemStack var2 = player.field_71071_by.func_70448_g();
            if (var2 != null && var2.field_77993_c == Item.field_77705_m.field_77779_bT) {
                if (--var2.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
                this.fuel += 3600;
            }
            this.pushX = this.field_70165_t - player.field_70165_t;
            this.pushZ = this.field_70161_v - player.field_70161_v;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.minecartX = par1;
        this.minecartY = par3;
        this.minecartZ = par5;
        this.minecartYaw = par7;
        this.minecartPitch = par8;
        this.turnProgress = par9 + 2;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        this.velocityX = this.field_70159_w = par1;
        this.velocityY = this.field_70181_x = par3;
        this.velocityZ = this.field_70179_y = par5;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70128_L ? false : par1EntityPlayer.func_70068_e((Entity)this) <= 64.0;
    }

    public boolean isMinecartPowered() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    protected void setMinecartPowered(boolean par1) {
        if (par1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(this.field_70180_af.func_75683_a(16) | 1)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(this.field_70180_af.func_75683_a(16) & 0xFFFFFFFE)));
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void setDamage(int par1) {
        this.field_70180_af.func_75692_b(19, (Object)par1);
    }

    public int getDamage() {
        return this.field_70180_af.func_75679_c(19);
    }

    public void func_70497_h(int par1) {
        this.field_70180_af.func_75692_b(17, (Object)par1);
    }

    public int func_70496_j() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void func_70494_i(int par1) {
        this.field_70180_af.func_75692_b(18, (Object)par1);
    }

    public int func_70493_k() {
        return this.field_70180_af.func_75679_c(18);
    }

    public void dropCartAsItem() {
        for (ItemStack item : this.getItemsDropped()) {
            this.func_70099_a(item, 0.0f);
        }
    }

    public List<ItemStack> getItemsDropped() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack getCartItem() {
        return null;
    }

    public boolean isPoweredCart() {
        return this.pullcartType == 2 && ((Object)((Object)this)).getClass() == CartEntity.class;
    }

    public boolean isStorageCart() {
        return this.pullcartType == 1 && ((Object)((Object)this)).getClass() == CartEntity.class;
    }

    public boolean canBeRidden() {
        return this.pullcartType == 0 && ((Object)((Object)this)).getClass() == CartEntity.class;
    }

    public boolean canUseRail() {
        return false;
    }

    public void setCanUseRail(boolean use) {
        this.canUseRail = use;
    }

    public boolean shouldDoRailFunctions() {
        return true;
    }

    public int getCartType() {
        return this.pullcartType;
    }

    protected double getDrag() {
        return this.field_70153_n != null ? defaultDragRidden : defaultDragEmpty;
    }

    protected void applyDragAndPushForces() {
        if (this.isPoweredCart()) {
            double d27 = MathHelper.func_76133_a((double)(this.pushX * this.pushX + this.pushZ * this.pushZ));
            if (d27 > 0.01) {
                this.pushX /= d27;
                this.pushZ /= d27;
                double d29 = 0.04;
                this.field_70159_w *= 0.8;
                this.field_70181_x *= 0.0;
                this.field_70179_y *= 0.8;
                this.field_70159_w += this.pushX * d29;
                this.field_70179_y += this.pushZ * d29;
            } else {
                this.field_70159_w *= 0.9;
                this.field_70181_x *= 0.0;
                this.field_70179_y *= 0.9;
            }
        }
        this.field_70159_w *= this.getDrag();
        this.field_70181_x *= 0.0;
        this.field_70179_y *= this.getDrag();
    }

    protected void updatePushForces() {
        double push;
        if (this.isPoweredCart() && (push = (double)MathHelper.func_76133_a((double)(this.pushX * this.pushX + this.pushZ * this.pushZ))) > 0.01 && this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.001) {
            this.pushX /= push;
            this.pushZ /= push;
            if (this.pushX * this.field_70159_w + this.pushZ * this.field_70179_y < 0.0) {
                this.pushX = 0.0;
                this.pushZ = 0.0;
            } else {
                this.pushX = this.field_70159_w;
                this.pushZ = this.field_70179_y;
            }
        }
    }

    protected void moveMinecartOffRail(int i, int j, int k) {
        double d2 = this.getMaxSpeedGround();
        if (!this.field_70122_E) {
            d2 = this.getMaxSpeedAirLateral();
        }
        if (this.field_70159_w < -d2) {
            this.field_70159_w = -d2;
        }
        if (this.field_70159_w > d2) {
            this.field_70159_w = d2;
        }
        if (this.field_70179_y < -d2) {
            this.field_70179_y = -d2;
        }
        if (this.field_70179_y > d2) {
            this.field_70179_y = d2;
        }
        double moveY = this.field_70181_x;
        if (this.getMaxSpeedAirVertical() > 0.0f && this.field_70181_x > (double)this.getMaxSpeedAirVertical()) {
            moveY = this.getMaxSpeedAirVertical();
            if (Math.abs(this.field_70159_w) < (double)0.3f && Math.abs(this.field_70179_y) < (double)0.3f) {
                this.field_70181_x = moveY = (double)0.15f;
            }
        }
        if (this.field_70122_E) {
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        }
        this.func_70091_d(this.field_70159_w, moveY, this.field_70179_y);
        if (!this.field_70122_E) {
            this.field_70159_w *= this.getDragAir();
            this.field_70181_x *= this.getDragAir();
            this.field_70179_y *= this.getDragAir();
        }
    }

    protected void updateFuel() {
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (this.fuel <= 0) {
            this.pushZ = 0.0;
            this.pushX = 0.0;
        }
        this.setMinecartPowered(this.fuel > 0);
    }

    protected void adjustSlopeVelocities(int metadata) {
        double acceleration = 0.0078125;
        if (metadata == 2) {
            this.field_70159_w -= acceleration;
        } else if (metadata == 3) {
            this.field_70159_w += acceleration;
        } else if (metadata == 4) {
            this.field_70179_y += acceleration;
        } else if (metadata == 5) {
            this.field_70179_y -= acceleration;
        }
    }

    public float getMaxSpeedRail() {
        return this.maxSpeedRail;
    }

    public void setMaxSpeedRail(float value) {
        this.maxSpeedRail = value;
    }

    public float getMaxSpeedGround() {
        return this.maxSpeedGround;
    }

    public void setMaxSpeedGround(float value) {
        this.maxSpeedGround = value;
    }

    public float getMaxSpeedAirLateral() {
        return this.maxSpeedAirLateral;
    }

    public void setMaxSpeedAirLateral(float value) {
        this.maxSpeedAirLateral = value;
    }

    public float getMaxSpeedAirVertical() {
        return this.maxSpeedAirVertical;
    }

    public void setMaxSpeedAirVertical(float value) {
        this.maxSpeedAirVertical = value;
    }

    public double getDragAir() {
        return this.dragAir;
    }

    public void setDragAir(double value) {
        this.dragAir = value;
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeInt(this.pullcartType);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.pullcartType = data.readInt();
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }
}

