/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.crafting;

import net.minecraft.block.Block;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import tconstruct.common.TContent;

public enum FluidType {
    Water(Block.field_72037_aS.field_71990_ca, 0, 20, FluidRegistry.getFluid((String)"water"), false),
    Iron(Block.field_72083_ai.field_71990_ca, 0, 600, TContent.moltenIronFluid, true),
    Gold(Block.field_72105_ah.field_71990_ca, 0, 400, TContent.moltenGoldFluid, false),
    Tin(TContent.metalBlock.field_71990_ca, 5, 400, TContent.moltenTinFluid, false),
    Copper(TContent.metalBlock.field_71990_ca, 3, 550, TContent.moltenCopperFluid, true),
    Aluminum(TContent.metalBlock.field_71990_ca, 6, 350, TContent.moltenAluminumFluid, false),
    NaturalAluminum(TContent.oreSlag.field_71990_ca, 6, 350, TContent.moltenAluminumFluid, false),
    Cobalt(TContent.metalBlock.field_71990_ca, 0, 650, TContent.moltenCobaltFluid, true),
    Ardite(TContent.metalBlock.field_71990_ca, 1, 650, TContent.moltenArditeFluid, true),
    AluminumBrass(TContent.metalBlock.field_71990_ca, 7, 350, TContent.moltenAlubrassFluid, false),
    Alumite(TContent.metalBlock.field_71990_ca, 8, 800, TContent.moltenAlumiteFluid, true),
    Manyullyn(TContent.metalBlock.field_71990_ca, 2, 750, TContent.moltenManyullynFluid, true),
    Bronze(TContent.metalBlock.field_71990_ca, 4, 500, TContent.moltenBronzeFluid, true),
    Steel(TContent.metalBlock.field_71990_ca, 9, 700, TContent.moltenSteelFluid, true),
    Nickel(TContent.metalBlock.field_71990_ca, 0, 400, TContent.moltenNickelFluid, false),
    Lead(TContent.metalBlock.field_71990_ca, 0, 400, TContent.moltenLeadFluid, false),
    Silver(TContent.metalBlock.field_71990_ca, 0, 400, TContent.moltenSilverFluid, false),
    Platinum(TContent.metalBlock.field_71990_ca, 0, 400, TContent.moltenShinyFluid, false),
    Invar(TContent.metalBlock.field_71990_ca, 0, 400, TContent.moltenInvarFluid, false),
    Electrum(TContent.metalBlock.field_71990_ca, 0, 400, TContent.moltenElectrumFluid, false),
    Obsidian(Block.field_72089_ap.field_71990_ca, 0, 750, TContent.moltenObsidianFluid, true),
    Ender(TContent.metalBlock.field_71990_ca, 10, 500, TContent.moltenEnderFluid, false),
    Glass(Block.field_71939_E.field_71990_ca, 0, 625, TContent.moltenGlassFluid, false),
    Stone(Block.field_71981_t.field_71990_ca, 0, 800, TContent.moltenStoneFluid, true),
    Emerald(Block.field_72068_bR.field_71990_ca, 0, 575, TContent.moltenEmeraldFluid, false),
    Slime(TContent.slimeGel.field_71990_ca, 0, 250, TContent.blueSlimeFluid, false),
    PigIron(TContent.meatBlock.field_71990_ca, 0, 610, TContent.pigIronFluid, true),
    Glue(TContent.glueBlock.field_71990_ca, 0, 125, TContent.glueFluid, false);

    public final int renderBlockID;
    public final int renderMeta;
    public final int baseTemperature;
    public final Fluid fluid;
    public final boolean isToolpart;

    private FluidType(int blockID, int meta, int baseTemperature, Fluid fluid, boolean isToolpart) {
        this.renderBlockID = blockID;
        this.renderMeta = meta;
        this.baseTemperature = baseTemperature;
        this.fluid = fluid;
        this.isToolpart = isToolpart;
    }

    public static FluidType getFluidType(Fluid searchedFluid) {
        for (FluidType ft : FluidType.values()) {
            if (ft.fluid.getBlockID() != searchedFluid.getBlockID()) continue;
            return ft;
        }
        return null;
    }

    public static int getTemperatureByFluid(Fluid searchedFluid) {
        for (FluidType ft : FluidType.values()) {
            if (ft.fluid.getBlockID() != searchedFluid.getBlockID()) continue;
            return ft.baseTemperature;
        }
        return 800;
    }
}

