/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ModBoolean;

public class ModButtertouch
extends ModBoolean {
    public ModButtertouch(ItemStack[] items, int effect) {
        super(items, effect, "Silk Touch", "\u00a7e", "Silky");
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        ToolCore toolItem = (ToolCore)tool.func_77973_b();
        if (!this.validType(toolItem)) {
            return false;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (!tags.func_74767_n("Lava") && !tags.func_74764_b("Lapis")) {
            return tags.func_74762_e("Modifiers") > 0 && !tags.func_74767_n(this.key);
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        tags.func_74757_a(this.key, true);
        this.addEnchantment(tool, Enchantment.field_77348_q, 1);
        int modifiers = tags.func_74762_e("Modifiers");
        tags.func_74768_a("Modifiers", --modifiers);
        int attack = tags.func_74762_e("Attack");
        if ((attack -= 3) < 0) {
            attack = 0;
        }
        tags.func_74768_a("Attack", attack);
        int miningSpeed = tags.func_74762_e("MiningSpeed");
        if ((miningSpeed -= 300) < 0) {
            miningSpeed = 0;
        }
        tags.func_74768_a("MiningSpeed", miningSpeed);
        if (tags.func_74764_b("MiningSpeed2")) {
            int miningSpeed2 = tags.func_74762_e("MiningSpeed2");
            if ((miningSpeed2 -= 300) < 0) {
                miningSpeed2 = 0;
            }
            tags.func_74768_a("MiningSpeed2", miningSpeed2);
        }
        this.addToolTip(tool, this.color + this.tooltipName, this.color + this.key);
    }

    public void addEnchantment(ItemStack tool, Enchantment enchant, int level) {
        NBTTagCompound enchantTag;
        NBTTagList tags = new NBTTagList("ench");
        Map enchantMap = EnchantmentHelper.func_82781_a((ItemStack)tool);
        Iterator iterator = enchantMap.keySet().iterator();
        boolean hasEnchant = false;
        while (iterator.hasNext()) {
            enchantTag = new NBTTagCompound();
            int index = (Integer)iterator.next();
            int lvl = (Integer)enchantMap.get(index);
            if (index == enchant.field_77352_x) {
                hasEnchant = true;
                enchantTag.func_74777_a("id", (short)index);
                enchantTag.func_74777_a("lvl", (short)((byte)level));
                tags.func_74742_a((NBTBase)enchantTag);
                continue;
            }
            enchantTag.func_74777_a("id", (short)index);
            enchantTag.func_74777_a("lvl", (short)((byte)lvl));
            tags.func_74742_a((NBTBase)enchantTag);
        }
        if (!hasEnchant) {
            enchantTag = new NBTTagCompound();
            enchantTag.func_74777_a("id", (short)enchant.field_77352_x);
            enchantTag.func_74777_a("lvl", (short)((byte)level));
            tags.func_74742_a((NBTBase)enchantTag);
        }
        tool.field_77990_d.func_74782_a("ench", (NBTBase)tags);
    }

    @Override
    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.toolCategories());
        return list.contains("weapon") || list.contains("harvest");
    }
}

