/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util.player;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import tconstruct.TConstruct;
import tconstruct.common.TContent;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.util.config.PHConstruct;
import tconstruct.util.player.ArmorExtended;
import tconstruct.util.player.KnapsackInventory;
import tconstruct.util.player.TPlayerStats;

public class TPlayerHandler
implements IPlayerTracker {
    public ConcurrentHashMap<String, TPlayerStats> playerStats = new ConcurrentHashMap();
    public static HashSet<Integer> knapsackDimensions = new HashSet();
    private final String serverLocation = "https://dl.dropboxusercontent.com/u/42769935/sticks.txt";
    private final int timeout = 1000;
    private HashSet<String> stickUsers = new HashSet();
    Random rand = new Random();

    public void onPlayerLogin(EntityPlayer player) {
        NBTTagList list;
        NBTTagCompound compound;
        NBTTagCompound tags = player.getEntityData();
        if (!tags.func_74764_b("TConstruct")) {
            tags.func_74766_a("TConstruct", new NBTTagCompound());
        }
        TPlayerStats stats = new TPlayerStats();
        stats.player = new WeakReference<EntityPlayer>(player);
        stats.armor = new ArmorExtended();
        stats.armor.init(player);
        stats.armor.readFromNBT(player);
        stats.knapsack = new KnapsackInventory();
        if (knapsackDimensions.contains(player.field_71093_bK)) {
            stats.knapsack.init(player, "", player.field_71093_bK, false);
        } else {
            stats.knapsack.init(player);
        }
        stats.knapsack.readFromNBT(player);
        stats.level = player.field_71068_ca;
        stats.hunger = player.func_71024_bL().func_75116_a();
        stats.previousDimension = player.field_71093_bK;
        stats.beginnerManual = tags.func_74775_l("TConstruct").func_74767_n("beginnerManual");
        stats.materialManual = tags.func_74775_l("TConstruct").func_74767_n("materialManual");
        stats.smelteryManual = tags.func_74775_l("TConstruct").func_74767_n("smelteryManual");
        stats.battlesignBonus = tags.func_74775_l("TConstruct").func_74767_n("battlesignBonus");
        if (!PHConstruct.enableHealthRegen) {
            player.field_70170_p.func_82736_K().func_82764_b("naturalRegeneration", "false");
        }
        if (!stats.beginnerManual) {
            ItemStack pattern;
            ItemStack diary;
            stats.beginnerManual = true;
            stats.battlesignBonus = true;
            tags.func_74775_l("TConstruct").func_74757_a("beginnerManual", true);
            tags.func_74775_l("TConstruct").func_74757_a("battlesignBonus", true);
            if (PHConstruct.beginnerBook && !player.field_71071_by.func_70441_a(diary = new ItemStack(TContent.manualBook))) {
                AbilityHelper.spawnItemAtPlayer(player, diary);
            }
            if (player.field_71092_bJ.toLowerCase().equals("fudgy_fetus")) {
                pattern = new ItemStack(TContent.woodPattern, 1, 22);
                compound = new NBTTagCompound();
                compound.func_74766_a("display", new NBTTagCompound());
                compound.func_74775_l("display").func_74778_a("Name", "\u00a7fFudgy_Fetus' Full Guard Pattern");
                list = new NBTTagList();
                list.func_74742_a((NBTBase)new NBTTagString("Lore", "\u00a72\u00a7oThe creator and the creation"));
                list.func_74742_a((NBTBase)new NBTTagString("Lore", "\u00a72\u00a7oare united at last!"));
                compound.func_74775_l("display").func_74782_a("Lore", (NBTBase)list);
                pattern.func_77982_d(compound);
                AbilityHelper.spawnItemAtPlayer(player, pattern);
            }
            if (player.field_71092_bJ.toLowerCase().equals("zerokyuuni")) {
                pattern = new ItemStack(Item.field_77669_D);
                compound = new NBTTagCompound();
                compound.func_74766_a("display", new NBTTagCompound());
                compound.func_74775_l("display").func_74778_a("Name", "\u00a78Cheaty Inventory");
                list = new NBTTagList();
                list.func_74742_a((NBTBase)new NBTTagString("Lore", "\u00a72\u00a7oNyaa~"));
                compound.func_74775_l("display").func_74782_a("Lore", (NBTBase)list);
                pattern.func_77982_d(compound);
                AbilityHelper.spawnItemAtPlayer(player, pattern);
            }
            if (player.field_71092_bJ.toLowerCase().equals("zisteau")) {
                this.spawnPigmanModifier(player);
            }
        } else if (!stats.battlesignBonus) {
            stats.battlesignBonus = true;
            ItemStack modifier = new ItemStack(TContent.creativeModifier);
            tags.func_74775_l("TConstruct").func_74757_a("battlesignBonus", true);
            compound = new NBTTagCompound();
            compound.func_74766_a("display", new NBTTagCompound());
            list = new NBTTagList();
            list.func_74742_a((NBTBase)new NBTTagString("Lore", "Battlesigns were buffed recently."));
            list.func_74742_a((NBTBase)new NBTTagString("Lore", "This might make up for it."));
            compound.func_74775_l("display").func_74782_a("Lore", (NBTBase)list);
            compound.func_74778_a("TargetLock", TContent.battlesign.getToolName());
            modifier.func_77982_d(compound);
            AbilityHelper.spawnItemAtPlayer(player, modifier);
            if (player.field_71092_bJ.toLowerCase().equals("zisteau")) {
                this.spawnPigmanModifier(player);
            }
        }
        this.playerStats.put(player.field_71092_bJ, stats);
        NBTTagCompound persistTag = tags.func_74775_l("PlayerPersisted");
        if (this.stickUsers.contains(player.field_71092_bJ) && !persistTag.func_74764_b("TCon-Stick")) {
            ItemStack stick = new ItemStack(Item.field_77669_D);
            persistTag.func_74757_a("TCon-Stick", true);
            NBTTagCompound compound2 = new NBTTagCompound();
            compound2.func_74766_a("display", new NBTTagCompound());
            compound2.func_74775_l("display").func_74778_a("Name", "\u00a7fStick of Patronage");
            NBTTagList list2 = new NBTTagList();
            list2.func_74742_a((NBTBase)new NBTTagString("Lore", "Thank you for supporting"));
            list2.func_74742_a((NBTBase)new NBTTagString("Lore", "Tinkers' Construct!"));
            compound2.func_74775_l("display").func_74782_a("Lore", (NBTBase)list2);
            stick.func_77982_d(compound2);
            stick.func_77966_a(Enchantment.field_77337_m, 2);
            stick.func_77966_a(Enchantment.field_77338_j, 3);
            AbilityHelper.spawnItemAtPlayer(player, stick);
            tags.func_74766_a("PlayerPersisted", persistTag);
        }
        if (PHConstruct.gregtech && Loader.isModLoaded((String)"GregTech-Addon")) {
            PHConstruct.gregtech = false;
            if (PHConstruct.lavaFortuneInteraction) {
                player.func_71035_c("Warning: Cross-mod Exploit Present!");
                player.func_71035_c("Solution 1: Disable Reverse Smelting recipes from GregTech.");
                player.func_71035_c("Solution 2: Disable Auto-Smelt/Fortune interaction from TConstruct.");
            }
        }
        this.updatePlayerInventory(player, stats);
    }

    void spawnPigmanModifier(EntityPlayer entityplayer) {
        ItemStack modifier = new ItemStack(TContent.creativeModifier);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74766_a("display", new NBTTagCompound());
        compound.func_74775_l("display").func_74778_a("Name", "Zistonian Bonus Modifier");
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagString("Lore", "Zombie Pigmen seem to have a natural affinty"));
        list.func_74742_a((NBTBase)new NBTTagString("Lore", "for these types of weapons."));
        compound.func_74775_l("display").func_74782_a("Lore", (NBTBase)list);
        compound.func_74778_a("TargetLock", TContent.battlesign.getToolName());
        modifier.func_77982_d(compound);
        AbilityHelper.spawnItemAtPlayer(entityplayer, modifier);
    }

    void updatePlayerInventory(EntityPlayer player, TPlayerStats stats) {
        this.updatePlayerInventory(player, stats, true);
    }

    void updatePlayerInventory(EntityPlayer player, TPlayerStats stats, boolean armor) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            if (armor) {
                outputStream.writeByte(4);
                stats.armor.writeInventoryToStream(outputStream);
            } else {
                outputStream.writeByte(3);
                stats.knapsack.writeInventoryToStream(outputStream);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "TConstruct";
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
    }

    public void onPlayerLogout(EntityPlayer entityplayer) {
        this.savePlayerStats(entityplayer, true);
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
        this.savePlayerStats(player, false);
        this.updatePlayerInventory(player, this.getPlayerStats(player.field_71092_bJ));
        TPlayerStats stats = this.getPlayerStats(player.field_71092_bJ);
        boolean global = knapsackDimensions.contains(player.field_71093_bK);
        if (!global || !stats.knapsack.globalKnapsack) {
            stats.knapsack.init(player, "", player.field_71093_bK, !global);
            stats.knapsack.readFromNBT(player);
            this.updatePlayerInventory(player, stats, false);
        }
    }

    void savePlayerStats(EntityPlayer player, boolean clean) {
        TPlayerStats stats;
        if (player != null && (stats = this.getPlayerStats(player.field_71092_bJ)) != null && stats.armor != null) {
            stats.armor.saveToNBT(player);
            stats.knapsack.saveToNBT(player);
            if (clean) {
                this.playerStats.remove(player.field_71092_bJ);
            }
        }
    }

    public void onPlayerRespawn(EntityPlayer entityplayer) {
        TPlayerStats stats = this.getPlayerStats(entityplayer.field_71092_bJ);
        stats.player = new WeakReference<EntityPlayer>(entityplayer);
        stats.armor.recalculateHealth(entityplayer, stats);
        if (PHConstruct.keepLevels) {
            entityplayer.field_71068_ca = stats.level;
        }
        if (PHConstruct.keepHunger) {
            entityplayer.func_71024_bL().func_75122_a(-1 * (20 - stats.hunger), 0.0f);
        }
        NBTTagCompound tags = entityplayer.getEntityData();
        NBTTagCompound tTag = new NBTTagCompound();
        tTag.func_74757_a("beginnerManual", stats.beginnerManual);
        tTag.func_74757_a("materialManual", stats.materialManual);
        tTag.func_74757_a("smelteryManual", stats.smelteryManual);
        tTag.func_74757_a("battlesignBonus", stats.battlesignBonus);
        tags.func_74766_a("TConstruct", tTag);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT && PHConstruct.keepHunger) {
            entityplayer.func_71024_bL().func_75114_a(stats.hunger);
        }
        this.updatePlayerInventory(entityplayer, this.getPlayerStats(entityplayer.field_71092_bJ));
    }

    @ForgeSubscribe
    public void livingFall(LivingFallEvent evt) {
        if (evt.entityLiving instanceof EntityPlayer) {
            evt.distance -= 1.0f;
        }
    }

    @ForgeSubscribe
    public void playerDrops(PlayerDropsEvent evt) {
        TPlayerStats stats = this.getPlayerStats(evt.entityPlayer.field_71092_bJ);
        stats.level = evt.entityPlayer.field_71068_ca / 2;
        int hunger = evt.entityPlayer.func_71024_bL().func_75116_a();
        stats.hunger = hunger < 6 ? 6 : evt.entityPlayer.func_71024_bL().func_75116_a();
    }

    public TPlayerStats getPlayerStats(String username) {
        TPlayerStats stats = this.playerStats.get(username);
        if (stats == null) {
            stats = new TPlayerStats();
            this.playerStats.put(username, stats);
        }
        return stats;
    }

    public EntityPlayer getEntityPlayer(String username) {
        TPlayerStats stats = this.playerStats.get(username);
        if (stats == null) {
            return null;
        }
        return (EntityPlayer)stats.player.get();
    }

    public TPlayerHandler() {
        this.buildStickURLDatabase("https://dl.dropboxusercontent.com/u/42769935/sticks.txt");
    }

    public void buildStickURLDatabase(String location) {
        TConstruct.logger.info("Building stick database");
        try {
            String nick;
            URL url = new URL(location);
            URLConnection con = url.openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            InputStream io = con.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(io));
            int linetracker = 1;
            while ((nick = br.readLine()) != null) {
                if (!nick.startsWith("--")) {
                    this.stickUsers.add(nick);
                }
                ++linetracker;
            }
            br.close();
        }
        catch (Exception e) {
            TConstruct.logger.log(Level.SEVERE, e.getMessage() != null ? e.getMessage() : "UNKOWN DL ERROR", e);
        }
    }
}

