/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.blocks.logic;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.Hopper;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import tconstruct.library.util.CoordTuple;
import tconstruct.library.util.IFacingLogic;
import tsteelworks.blocks.logic.HighOvenLogic;
import tsteelworks.blocks.logic.TSMultiServantLogic;
import tsteelworks.inventory.HighOvenDuctContainer;
import tsteelworks.lib.ConfigCore;
import tsteelworks.util.InventoryHelper;

public class HighOvenDuctLogic
extends TSMultiServantLogic
implements IFacingLogic,
Hopper {
    public static final int MODE_OXIDIZER = 0;
    public static final int MODE_REDUCER = 1;
    public static final int MODE_PURIFIER = 2;
    public static final int MODE_FUEL = 3;
    public static final int MODE_MELTABLE = 4;
    public static final int MODE_OUTPUT = 5;
    byte direction = 0;
    int mode = 0;
    boolean redstoneActivated = false;
    private ItemStack[] inventory = new ItemStack[9];
    private int transferCooldown = -1;

    public void func_70316_g() {
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
            --this.transferCooldown;
            if (!this.isCoolingDown()) {
                this.setTransferCooldown(0);
                this.updateDuct();
            }
        }
    }

    public boolean updateDuct() {
        boolean flag = false;
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K && !this.isCoolingDown()) {
            this.setTransferCooldown(0);
            flag = this.insertItemToInventory();
            boolean bl = flag = this.suckItemsIntoDuct() || flag;
            if (flag) {
                this.setTransferCooldown(8);
                this.func_70296_d();
            }
        }
        return flag;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new HighOvenDuctContainer(inventoryplayer, this);
    }

    public boolean getRedstoneActive() {
        return this.redstoneActivated;
    }

    public void setRedstoneActive(boolean flag) {
        this.redstoneActivated = flag;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int newMode) {
        if (newMode == 5 && !this.isOutputDuct()) {
            this.getHighOvenController().outputDuct = new CoordTuple(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        } else if (newMode != 5 && this.isOutputDuct()) {
            this.getHighOvenController().outputDuct = null;
        }
        this.mode = newMode < 5 ? newMode : 5;
    }

    public HighOvenLogic getHighOvenController() {
        int mx = this.getMasterPosition().x;
        int my = this.getMasterPosition().y;
        int mz = this.getMasterPosition().z;
        return (HighOvenLogic)this.field_70331_k.func_72796_p(mx, my, mz);
    }

    boolean isOutputDuct() {
        if (this.getHighOvenController().outputDuct == null) {
            return false;
        }
        int x = this.getHighOvenController().outputDuct.x;
        int y = this.getHighOvenController().outputDuct.y;
        int z = this.getHighOvenController().outputDuct.z;
        CoordTuple compare = new CoordTuple(x, y, z);
        CoordTuple pos = new CoordTuple(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return this.mode == 5 && compare == pos;
    }

    private boolean insertItemToInventory() {
        if (!this.hasValidMaster() || this.redstoneActivated) {
            return false;
        }
        IInventory masterInventory = this.getOutputInventory();
        if (masterInventory == null) {
            return false;
        }
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (this.func_70301_a(slot) == null) continue;
            ItemStack copyStack = this.func_70301_a(slot).func_77946_l();
            ItemStack outputStack = this.insertStack(masterInventory, this.func_70298_a(slot, 1), this.getRenderDirection());
            if (outputStack == null || outputStack.field_77994_a == 0) {
                masterInventory.func_70296_d();
                return true;
            }
            this.func_70299_a(slot, copyStack);
        }
        return false;
    }

    boolean suckItemsIntoDuct() {
        EntityItem entityitem;
        if (this.mode == 5 || this.redstoneActivated) {
            return false;
        }
        IInventory inventory = this.getExternalInventory(this.direction);
        if (inventory != null) {
            boolean side = false;
            if (inventory instanceof ISidedInventory) {
                int[] slots;
                ISidedInventory isidedinventory = (ISidedInventory)inventory;
                for (int slot : slots = isidedinventory.func_94128_d(0)) {
                    if (!this.pullStackFromInventory(inventory, slot, 0)) continue;
                    return true;
                }
            } else {
                int j = inventory.func_70302_i_();
                if (j == 0) {
                    return false;
                }
                for (int k = 0; k < j; ++k) {
                    if (!this.pullStackFromInventory(inventory, k, 0)) continue;
                    return true;
                }
            }
        } else if (ConfigCore.enableDuctVacuum && (entityitem = InventoryHelper.getItemEntityAtLocation(this.func_70314_l(), this.func_96107_aA(), this.func_96109_aB(), this.func_96108_aC(), this.direction)) != null) {
            return this.pullStackFromEntity(entityitem, this.mode);
        }
        return false;
    }

    private boolean pullStackFromInventory(IInventory inventory, int slot, int side) {
        ItemStack itemstack = inventory.func_70301_a(slot);
        if (itemstack == null || InventoryHelper.canExtractItemFromInventory(inventory, itemstack, slot, side)) {
            // empty if block
        }
        if (itemstack == null) {
            return false;
        }
        ItemStack itemstack1 = itemstack.func_77946_l();
        ItemStack outputStack = this.insertStack((IInventory)this, inventory.func_70298_a(slot, 1), -1);
        if (outputStack == null || outputStack.field_77994_a == 0) {
            inventory.func_70296_d();
            return true;
        }
        inventory.func_70299_a(slot, itemstack1);
        return false;
    }

    public boolean pullStackFromEntity(EntityItem item, int transferMode) {
        boolean flag = false;
        if (item == null) {
            return false;
        }
        ItemStack itemstack = item.func_92059_d().func_77946_l();
        ItemStack itemstack1 = this.insertStack((IInventory)this, itemstack, -1);
        if (itemstack1 != null && itemstack1.field_77994_a != 0) {
            item.func_92058_a(itemstack1);
        } else {
            flag = true;
            item.func_70106_y();
        }
        return flag;
    }

    public ItemStack insertStack(IInventory inventory, ItemStack stack, int side) {
        if (inventory instanceof ISidedInventory && side > -1) {
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            int[] slot = isidedinventory.func_94128_d(side);
            for (int i = 0; i < slot.length && stack != null && stack.field_77994_a > 0; ++i) {
                stack = this.sendItemsToLocation(inventory, stack, slot[i], side);
            }
        } else if (this.mode == 4) {
            for (int slot = 4; slot < inventory.func_70302_i_() && stack != null && stack.field_77994_a > 0; ++slot) {
                stack = this.sendItemsToLocation(inventory, stack, slot, side);
            }
        } else if (this.mode == 5) {
            int k = inventory.func_70302_i_();
            for (int slot = 0; slot < k && stack != null && stack.field_77994_a > 0; ++slot) {
                stack = this.sendItemsToLocation(inventory, stack, slot, side);
            }
        } else if (this.mode < 4) {
            stack = this.sendItemsToLocation(inventory, stack, this.mode, side);
        }
        if (stack != null && stack.field_77994_a == 0) {
            stack = null;
        }
        return stack;
    }

    private ItemStack sendItemsToLocation(IInventory iinventory, ItemStack stack, int slot, int side) {
        ItemStack masterStack = iinventory.func_70301_a(slot);
        if (InventoryHelper.canInsertItemToInventory(iinventory, stack, slot, side)) {
            int max;
            boolean flag = false;
            if (masterStack == null) {
                int max2 = Math.min(stack.func_77976_d(), iinventory.func_70297_j_());
                if (max2 >= stack.field_77994_a) {
                    iinventory.func_70299_a(slot, stack);
                    stack = null;
                } else {
                    iinventory.func_70299_a(slot, stack.func_77979_a(max2));
                }
                flag = true;
            } else if (InventoryHelper.areItemStacksEqualItem(masterStack, stack) && (max = Math.min(stack.func_77976_d(), iinventory.func_70297_j_())) > masterStack.field_77994_a) {
                int l = Math.min(stack.field_77994_a, max - masterStack.field_77994_a);
                stack.field_77994_a -= l;
                masterStack.field_77994_a += l;
                boolean bl = flag = l > 0;
            }
            if (flag) {
                iinventory.func_70296_d();
            }
        }
        return stack;
    }

    private IInventory getOutputInventory() {
        return this.mode == 5 ? this.getExternalInventory(this.direction) : this.getHighOvenController();
    }

    public IInventory getExternalInventory(byte facing) {
        double checkXPos = this.func_96107_aA();
        double checkYPos = this.func_96109_aB();
        double checkZPos = this.func_96108_aC();
        switch (facing) {
            case 0: {
                checkYPos = this.func_96109_aB() - 1.0;
                break;
            }
            case 1: {
                checkYPos = this.func_96109_aB() + 1.0;
                break;
            }
            case 2: {
                checkZPos = this.func_96108_aC() - 1.0;
                break;
            }
            case 3: {
                checkZPos = this.func_96108_aC() + 1.0;
                break;
            }
            case 4: {
                checkXPos = this.func_96107_aA() - 1.0;
                break;
            }
            case 5: {
                checkXPos = this.func_96107_aA() + 1.0;
                break;
            }
        }
        return InventoryHelper.getInventoryAtLocation(this.func_70314_l(), checkXPos, checkYPos, checkZPos);
    }

    public double func_96107_aA() {
        return this.field_70329_l;
    }

    public double func_96109_aB() {
        return this.field_70330_m;
    }

    public double func_96108_aC() {
        return this.field_70327_n;
    }

    public void setTransferCooldown(int value) {
        this.transferCooldown = value;
    }

    public boolean isCoolingDown() {
        return this.transferCooldown > 0;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= quantity) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                return stack;
            }
            ItemStack split = this.inventory[slot].func_77979_a(quantity);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return split;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70011_f((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public String func_70303_b() {
        return "container.HighOvenDuct";
    }

    public boolean func_94042_c() {
        return this.func_70303_b() != null && this.func_70303_b().length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return slot < this.func_70302_i_() && (this.inventory[slot] == null || itemstack.field_77994_a + this.inventory[slot].field_77994_a <= this.func_70297_j_());
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        this.mode = tags.func_74762_e("Mode");
        this.redstoneActivated = tags.func_74767_n("RedstoneActivated");
        super.func_70307_a(tags);
        NBTTagList itemList = tags.func_74761_m("Items");
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.transferCooldown = tags.func_74762_e("TransferCooldown");
        this.direction = tags.func_74771_c("Direction");
        for (int iter = 0; iter < itemList.func_74745_c(); ++iter) {
            NBTTagCompound tagList = (NBTTagCompound)itemList.func_74743_b(iter);
            byte slotID = tagList.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.inventory.length) continue;
            this.inventory[slotID] = ItemStack.func_77949_a((NBTTagCompound)tagList);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        NBTTagList nbttaglist = new NBTTagList();
        for (int iter = 0; iter < this.inventory.length; ++iter) {
            if (this.inventory[iter] == null) continue;
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.func_74774_a("Slot", (byte)iter);
            this.inventory[iter].func_77955_b(tagList);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        tags.func_74768_a("TransferCooldown", this.transferCooldown);
        tags.func_74782_a("Items", (NBTBase)nbttaglist);
        tags.func_74774_a("Direction", this.direction);
        tags.func_74757_a("RedstoneActivated", this.redstoneActivated);
        tags.func_74768_a("Mode", this.mode);
    }

    @Override
    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.func_70296_d();
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

