/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.client.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.client.TProxyClient;
import tconstruct.client.block.BlockSkinRenderHelper;
import tsteelworks.blocks.logic.DeepTankLogic;

public class DeepTankRender
implements ISimpleBlockRenderingHandler {
    public static int deeptankModel = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == deeptankModel) {
            TProxyClient.renderStandardInvBlock((RenderBlocks)renderer, (Block)block, (int)metadata);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == deeptankModel) {
            if (world.func_72805_g(x, y, z) == 13) {
                return this.renderDeepTank(world, x, y, z, block, modelID, renderer);
            }
            renderer.func_78570_q(block, x, y, z);
        }
        return true;
    }

    public boolean renderDeepTank(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        renderer.func_78570_q(block, x, y, z);
        DeepTankLogic logic = (DeepTankLogic)world.func_72796_p(x, y, z);
        if (logic.validStructure) {
            int posX = logic.centerPos.x - (logic.xDistanceToRim() - 1);
            int posY = logic.centerPos.y;
            int posZ = logic.centerPos.z - (logic.zDistanceToRim() - 1);
            float base = 0.0f;
            int yBase = 0;
            int liquidBase = 0;
            for (FluidStack liquid : logic.fluidlist) {
                int liquidSize = liquid.amount;
                while (liquidSize > 0) {
                    int i;
                    int room = logic.layerFluidCapacity() - liquidBase;
                    int countSize = liquidSize > room ? room : liquidSize;
                    liquidSize -= countSize;
                    float height = countSize > logic.layerFluidCapacity() ? 1.0f : (float)countSize / (float)logic.layerFluidCapacity();
                    float renderBase = base;
                    float renderHeight = height + base;
                    base += height;
                    liquidBase += countSize;
                    Fluid fluid = liquid.getFluid();
                    if (logic.innerMaxX == logic.innerMaxZ) {
                        for (i = 0; i < logic.innerSpaceTotal(); ++i) {
                            float minX = i % logic.innerMaxX == 0 ? -0.001f : 0.0f;
                            float minZ = i / logic.innerMaxX == 0 ? -0.001f : 0.0f;
                            float maxX = i % logic.innerMaxZ == 2 ? 1.001f : 1.0f;
                            float maxZ = i / logic.innerMaxZ == 2 ? 1.001f : 1.0f;
                            renderer.func_83020_a((double)minX, (double)renderBase, (double)minZ, (double)maxX, (double)renderHeight, (double)maxZ);
                            int rx = posX + i % logic.innerMaxX;
                            int ry = posY + yBase;
                            int rz = posZ + i / logic.innerMaxZ;
                            if (fluid.canBePlacedInWorld()) {
                                BlockSkinRenderHelper.renderMetadataBlock((Block)Block.field_71973_m[fluid.getBlockID()], (int)0, (int)rx, (int)ry, (int)rz, (RenderBlocks)renderer, (IBlockAccess)world);
                                continue;
                            }
                            BlockSkinRenderHelper.renderLiquidBlock((Icon)fluid.getStillIcon(), (Icon)fluid.getFlowingIcon(), (int)rx, (int)ry, (int)rz, (RenderBlocks)renderer, (IBlockAccess)world);
                        }
                    } else {
                        for (i = 0; i < logic.innerSpaceTotal(); ++i) {
                            int modZ = this.getRenderZOffset(logic.innerMaxX, logic.innerMaxZ);
                            float minX = i % logic.innerMaxX == 0 ? -0.001f : 0.0f;
                            float minZ = i / logic.innerMaxZ == 0 ? -0.001f : 0.0f;
                            float maxX = i % logic.innerMaxX == 2 ? 1.001f : 1.0f;
                            float maxZ = i / logic.innerMaxZ == 2 ? 1.001f : 1.0f;
                            renderer.func_83020_a((double)minX, (double)renderBase, (double)minZ, (double)maxX, (double)renderHeight, (double)maxZ);
                            int rx = posX + i % logic.innerMaxX;
                            int ry = posY + yBase;
                            int rz = posZ + i / modZ;
                            if (fluid.canBePlacedInWorld()) {
                                BlockSkinRenderHelper.renderMetadataBlock((Block)Block.field_71973_m[fluid.getBlockID()], (int)0, (int)rx, (int)ry, (int)rz, (RenderBlocks)renderer, (IBlockAccess)world);
                                continue;
                            }
                            BlockSkinRenderHelper.renderLiquidBlock((Icon)fluid.getStillIcon(), (Icon)fluid.getFlowingIcon(), (int)rx, (int)ry, (int)rz, (RenderBlocks)renderer, (IBlockAccess)world);
                        }
                    }
                    if (countSize != room) continue;
                    base = 0.0f;
                    ++yBase;
                    liquidBase = 0;
                }
            }
        }
        return true;
    }

    public int getRenderZOffset(int x, int z) {
        if (x == 1) {
            switch (z) {
                case 3: {
                    return z - 2;
                }
                case 5: {
                    return z - 4;
                }
                case 7: {
                    return z - 6;
                }
                case 9: {
                    return z - 8;
                }
            }
            return z;
        }
        if (x == 3) {
            switch (z) {
                case 1: {
                    return z + 4;
                }
                case 5: {
                    return z - 2;
                }
                case 7: {
                    return z - 4;
                }
                case 9: {
                    return z - 6;
                }
            }
            return z;
        }
        if (x == 5) {
            switch (z) {
                case 1: {
                    return z + 4;
                }
                case 3: {
                    return z + 2;
                }
                case 7: {
                    return z - 2;
                }
                case 9: {
                    return z - 4;
                }
            }
            return z;
        }
        if (x == 7) {
            switch (z) {
                case 1: {
                    return z + 6;
                }
                case 3: {
                    return z + 4;
                }
                case 5: {
                    return z + 2;
                }
                case 9: {
                    return z - 2;
                }
            }
            return z;
        }
        if (x == 9) {
            switch (z) {
                case 1: {
                    return z + 8;
                }
                case 3: {
                    return z + 6;
                }
                case 5: {
                    return z + 4;
                }
                case 7: {
                    return z + 2;
                }
            }
            return z;
        }
        return z;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return deeptankModel;
    }
}

