/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.FluidStack;
import tsteelworks.blocks.logic.DeepTankLogic;
import tsteelworks.blocks.logic.HighOvenDuctLogic;
import tsteelworks.blocks.logic.HighOvenLogic;
import tsteelworks.lib.Repo;
import tsteelworks.lib.TSLogger;

public class TSPacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (packet.field_73630_a.equals("TSteelworks")) {
            if (side == Side.SERVER) {
                this.handleServerPacket(packet, (EntityPlayerMP)player);
            } else {
                this.handleClientPacket(packet, (EntityPlayer)player);
            }
        }
    }

    Entity getEntity(World world, int id) {
        for (Object o : world.field_72996_f) {
            if (((Entity)o).field_70157_k != id) continue;
            return (Entity)o;
        }
        return null;
    }

    void handleClientPacket(Packet250CustomPayload packet, EntityPlayer player) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            inputStream.readByte();
        }
        catch (Exception e) {
            TSLogger.warning("Failed at reading client packet for TSteelworks.");
            e.printStackTrace();
        }
    }

    void handleServerPacket(Packet250CustomPayload packet, EntityPlayerMP player) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            FluidStack temp;
            TileEntity te;
            int fluidID;
            boolean isShiftPressed;
            int z;
            int y;
            int x;
            WorldServer world;
            int dimension;
            byte packetID = inputStream.readByte();
            if (packetID == Repo.ovenPacketID) {
                dimension = inputStream.readInt();
                world = DimensionManager.getWorld((int)dimension);
                x = inputStream.readInt();
                y = inputStream.readInt();
                z = inputStream.readInt();
                isShiftPressed = inputStream.readBoolean();
                fluidID = inputStream.readInt();
                te = world.func_72796_p(x, y, z);
                if (te instanceof HighOvenLogic) {
                    temp = null;
                    for (FluidStack liquid : ((HighOvenLogic)te).moltenMetal) {
                        if (liquid.fluidID != fluidID) continue;
                        temp = liquid;
                    }
                    if (temp != null) {
                        ((HighOvenLogic)te).moltenMetal.remove(temp);
                        if (isShiftPressed) {
                            ((HighOvenLogic)te).moltenMetal.add(temp);
                        } else {
                            ((HighOvenLogic)te).moltenMetal.add(0, temp);
                        }
                    }
                    PacketDispatcher.sendPacketToAllInDimension((Packet)te.func_70319_e(), (int)dimension);
                }
            }
            if (packetID == Repo.ductPacketID) {
                dimension = inputStream.readInt();
                world = DimensionManager.getWorld((int)dimension);
                x = inputStream.readInt();
                y = inputStream.readInt();
                z = inputStream.readInt();
                int mode = inputStream.readInt();
                TileEntity te2 = world.func_72796_p(x, y, z);
                if (te2 instanceof HighOvenDuctLogic) {
                    int tempMode = ((HighOvenDuctLogic)te2).getMode();
                    if (tempMode != mode) {
                        ((HighOvenDuctLogic)te2).setMode(mode);
                    }
                    PacketDispatcher.sendPacketToAllInDimension((Packet)te2.func_70319_e(), (int)dimension);
                }
            }
            if (packetID == Repo.tankPacketID) {
                dimension = inputStream.readInt();
                world = DimensionManager.getWorld((int)dimension);
                x = inputStream.readInt();
                y = inputStream.readInt();
                z = inputStream.readInt();
                isShiftPressed = inputStream.readBoolean();
                fluidID = inputStream.readInt();
                te = world.func_72796_p(x, y, z);
                if (te instanceof DeepTankLogic) {
                    temp = null;
                    for (FluidStack liquid : ((DeepTankLogic)te).fluidlist) {
                        if (liquid.fluidID != fluidID) continue;
                        temp = liquid;
                    }
                    if (temp != null) {
                        ((DeepTankLogic)te).fluidlist.remove(temp);
                        if (isShiftPressed) {
                            ((DeepTankLogic)te).fluidlist.add(temp);
                        } else {
                            ((DeepTankLogic)te).fluidlist.add(0, temp);
                        }
                    }
                    PacketDispatcher.sendPacketToAllInDimension((Packet)te.func_70319_e(), (int)dimension);
                }
            }
        }
        catch (IOException e) {
            TSLogger.warning("Failed at reading server packet for TSteelworks.");
            e.printStackTrace();
        }
    }
}

