/*
 * Decompiled with CFR 0.152.
 */
package extracells.items;

import appeng.api.IAEItemStack;
import appeng.api.Util;
import appeng.api.me.items.IStorageCell;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.Extracells;
import extracells.ItemEnum;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ItemStoragePhysical
extends Item
implements IStorageCell {
    public static final String[] suffixes = new String[]{"256k", "1024k", "4096k", "16348k", "container", "adjustable"};
    public static final int[] bytes_cell = new int[]{262144, 0x100000, 0x400000, 0x1000000, 65536};
    public static final int[] types_cell = new int[]{63, 63, 63, 63, 1};
    @SideOnly(value=Side.CLIENT)
    private Icon[] icons;

    public ItemStoragePhysical(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(Extracells.ModTab);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int par1) {
        int j = MathHelper.func_76125_a((int)par1, (int)0, (int)5);
        return this.icons[j];
    }

    public void func_94581_a(IconRegister iconRegister) {
        this.icons = new Icon[suffixes.length];
        for (int i = 0; i < suffixes.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("extracells:storage.physical." + suffixes[i]);
        }
    }

    public String func_77667_c(ItemStack itemstack) {
        int i = itemstack.func_77960_j();
        return "item.storage.physical." + suffixes[i];
    }

    public String func_77628_j(ItemStack stack) {
        Boolean hasName = !Util.getCellRegistry().getHandlerForCell(stack).getName().isEmpty();
        String partitionName = Util.getCellRegistry().getHandlerForCell(stack).getName();
        long used_bytes = Util.getCellRegistry().getHandlerForCell(stack).usedBytes();
        if (stack.func_77960_j() == 4) {
            if (used_bytes != 0L) {
                return StatCollector.func_74838_a((String)this.func_77667_c(stack)) + " - " + ((ItemStack)Util.getCellRegistry().getHandlerForCell(stack).getAvailableItems().getItems().get(0)).func_82833_r();
            }
            return StatCollector.func_74838_a((String)"tooltip.empty1") + " " + StatCollector.func_74838_a((String)this.func_77667_c(stack));
        }
        if (hasName.booleanValue()) {
            return StatCollector.func_74838_a((String)this.func_77667_c(stack)) + " - " + partitionName;
        }
        return StatCollector.func_74838_a((String)this.func_77667_c(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int i, CreativeTabs creativeTab, List listSubItems) {
        for (int j = 0; j < 6; ++j) {
            ItemStack toAdd = new ItemStack(i, 1, j);
            if (j == 5 && !toAdd.func_77942_o()) {
                toAdd.func_77982_d(new NBTTagCompound());
                toAdd.func_77978_p().func_74768_a("custom_size", 4096);
                toAdd.func_77978_p().func_74768_a("custom_types", 27);
            }
            listSubItems.add(toAdd);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        Boolean partitioned = Util.getCellRegistry().getHandlerForCell(stack).isPreformatted();
        Boolean fuzzy = Util.getCellRegistry().getHandlerForCell(stack).isFuzzyPreformatted();
        long used_bytes = Util.getCellRegistry().getHandlerForCell(stack).usedBytes();
        long total_bytes = Util.getCellRegistry().getHandlerForCell(stack).totalBytes();
        long used_types = Util.getCellRegistry().getHandlerForCell(stack).storedItemTypes();
        long total_types = Util.getCellRegistry().getHandlerForCell(stack).getTotalItemTypes();
        if (stack.func_77960_j() != 4) {
            list.add(used_bytes + " " + StatCollector.func_74838_a((String)"Appeng.GuiITooltip.Of") + " " + total_bytes + " " + StatCollector.func_74838_a((String)"Appeng.GuiITooltip.BytesUsed"));
            list.add(used_types + " " + StatCollector.func_74838_a((String)"Appeng.GuiITooltip.Of") + " " + total_types + " " + StatCollector.func_74838_a((String)"Appeng.GuiITooltip.Types"));
        } else if (stack.func_77960_j() == 4) {
            if (used_bytes != 0L) {
                list.add(StatCollector.func_74838_a((String)"tooltip.block") + ": " + ((ItemStack)Util.getCellRegistry().getHandlerForCell(stack).getAvailableItems().getItems().get(0)).func_82833_r());
            } else {
                list.add(StatCollector.func_74838_a((String)"tooltip.block") + ": -");
            }
            list.add(used_bytes + " " + StatCollector.func_74838_a((String)"Appeng.GuiITooltip.Of") + " " + total_bytes + " " + StatCollector.func_74838_a((String)"Appeng.GuiITooltip.BytesUsed"));
        }
        if (partitioned.booleanValue()) {
            if (fuzzy.booleanValue()) {
                list.add(StatCollector.func_74838_a((String)"Appeng.GuiITooltip.Partitioned") + " - " + StatCollector.func_74838_a((String)"Appeng.GuiITooltip.Fuzzy"));
            } else {
                list.add(StatCollector.func_74838_a((String)"Appeng.GuiITooltip.Partitioned") + " - " + StatCollector.func_74838_a((String)"Appeng.GuiITooltip.Precise"));
            }
        }
    }

    public int getBytes(ItemStack i) {
        if (i.func_77960_j() == 5) {
            if (i.func_77942_o()) {
                return i.func_77978_p().func_74762_e("custom_size");
            }
            return 0;
        }
        return bytes_cell[i.func_77960_j()];
    }

    public int BytePerType(ItemStack i) {
        if (i.func_77960_j() == 5) {
            if (i.func_77942_o()) {
                if (Math.round(i.func_77978_p().func_74762_e("custom_types") / 128) == 0) {
                    return 1;
                }
                return Math.round(i.func_77978_p().func_74762_e("custom_types") / 128);
            }
            return 1;
        }
        return bytes_cell[i.func_77960_j()] / 128;
    }

    public int getTotalTypes(ItemStack i) {
        if (i.func_77960_j() == 5) {
            if (i.func_77942_o()) {
                return i.func_77978_p().func_74762_e("custom_types");
            }
            return 0;
        }
        return types_cell[i.func_77960_j()];
    }

    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requesetedAddition) {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack par1) {
        return EnumRarity.epic;
    }

    public ItemStack func_77659_a(ItemStack i, World w, EntityPlayer p) {
        if (p.func_70093_af()) {
            if (i.func_77960_j() == 0 || i.func_77960_j() == 1 || i.func_77960_j() == 2 || i.func_77960_j() == 3) {
                if (Util.getCellRegistry().getHandlerForCell(i).storedItemCount() == 0L && p.field_71071_by.func_70441_a(new ItemStack(ItemEnum.STORAGECASING.getItemInstance(), 1, 0))) {
                    return new ItemStack(ItemEnum.STORAGECOMPONENT.getItemInstance(), 1, i.func_77960_j());
                }
            } else if (i.func_77960_j() == 4 && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                switch (i.func_77978_p().func_74762_e("mode")) {
                    case 0: {
                        i.func_77978_p().func_74768_a("mode", 1);
                        p.func_71035_c(StatCollector.func_74838_a((String)"tooltip.mode") + ": " + StatCollector.func_74838_a((String)"tooltip.equaltrade1"));
                        break;
                    }
                    case 1: {
                        i.func_77978_p().func_74768_a("mode", 2);
                        p.func_71035_c(StatCollector.func_74838_a((String)"tooltip.mode") + ": " + StatCollector.func_74838_a((String)"tooltip.equaltrade3"));
                        break;
                    }
                    case 2: {
                        i.func_77978_p().func_74768_a("mode", 0);
                        p.func_71035_c(StatCollector.func_74838_a((String)"tooltip.mode") + ": " + StatCollector.func_74838_a((String)"tooltip.placement"));
                    }
                }
            }
        }
        return i;
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        if (itemstack.func_77960_j() == 4) {
            ForgeDirection face = ForgeDirection.getOrientation((int)side);
            if (world.func_72798_a(x + face.offsetX, y + face.offsetY, z + face.offsetZ) == 0 && Util.getCellRegistry().getHandlerForCell(itemstack).storedItemTypes() != 0L) {
                if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                    IAEItemStack request = Util.createItemStack((ItemStack)((ItemStack)Util.getCellRegistry().getHandlerForCell(itemstack).getAvailableItems().getItems().get(0)).func_77946_l());
                    ItemStack block = request.getItemStack();
                    if (block.func_77973_b() instanceof ItemBlock) {
                        ItemBlock itemblock = (ItemBlock)request.getItem();
                        if (world.func_72798_a(x, y, z) != 7) {
                            block0 : switch (itemstack.func_77978_p().func_74762_e("mode")) {
                                case 0: {
                                    request.setStackSize(1L);
                                    itemblock.onItemUseFirst(request.getItemStack(), player, world, x, y, z, side, xOffset, yOffset, zOffset);
                                    itemblock.func_77648_a(request.getItemStack(), player, world, x, y, z, side, xOffset, yOffset, zOffset);
                                    Util.getCellRegistry().getHandlerForCell(itemstack).extractItems(request);
                                    break;
                                }
                                case 1: {
                                    request.setStackSize(1L);
                                    world.func_94578_a(x, y, z, true);
                                    this.placeBlock(request.getItemStack(), world, player, x, y, z, side, xOffset, yOffset, zOffset);
                                    Util.getCellRegistry().getHandlerForCell(itemstack).extractItems(request);
                                    break;
                                }
                                case 2: {
                                    request.setStackSize(9L);
                                    if (Util.getCellRegistry().getHandlerForCell(itemstack).storedItemCount() <= 9L) break;
                                    switch (ForgeDirection.getOrientation((int)side)) {
                                        case DOWN: {
                                            for (int posX = x - 1; posX < x + 2; ++posX) {
                                                for (int posZ = z - 1; posZ < z + 2; ++posZ) {
                                                    world.func_94578_a(posX, y, posZ, true);
                                                    this.placeBlock(request.getItemStack(), world, player, x, y, z, side, xOffset, yOffset, zOffset);
                                                }
                                            }
                                            Util.getCellRegistry().getHandlerForCell(itemstack).extractItems(request);
                                            break block0;
                                        }
                                        case EAST: {
                                            for (int posZ = z - 1; posZ < z + 2; ++posZ) {
                                                for (int posY = y - 1; posY < y + 2; ++posY) {
                                                    world.func_94578_a(x, posY, posZ, true);
                                                    this.placeBlock(request.getItemStack(), world, player, x, posY, posZ, side, xOffset, yOffset, zOffset);
                                                }
                                            }
                                            Util.getCellRegistry().getHandlerForCell(itemstack).extractItems(request);
                                            break block0;
                                        }
                                        case NORTH: {
                                            for (int posX = x - 1; posX < x + 2; ++posX) {
                                                for (int posY = y - 1; posY < y + 2; ++posY) {
                                                    world.func_94578_a(posX, posY, z, true);
                                                    this.placeBlock(request.getItemStack(), world, player, posX, posY, z, side, xOffset, yOffset, zOffset);
                                                }
                                            }
                                            Util.getCellRegistry().getHandlerForCell(itemstack).extractItems(request);
                                            break block0;
                                        }
                                        case SOUTH: {
                                            for (int posX = x - 1; posX < x + 2; ++posX) {
                                                for (int posY = y - 1; posY < y + 2; ++posY) {
                                                    world.func_94578_a(posX, posY, z, true);
                                                    this.placeBlock(request.getItemStack(), world, player, posX, posY, z, side, xOffset, yOffset, zOffset);
                                                }
                                            }
                                            Util.getCellRegistry().getHandlerForCell(itemstack).extractItems(request);
                                            break block0;
                                        }
                                        case UNKNOWN: {
                                            break block0;
                                        }
                                        case UP: {
                                            for (int posX = x - 1; posX < x + 2; ++posX) {
                                                for (int posZ = z - 1; posZ < z + 2; ++posZ) {
                                                    world.func_94578_a(posX, y, posZ, true);
                                                    this.placeBlock(request.getItemStack(), world, player, posX, y, posZ, side, xOffset, yOffset, zOffset);
                                                }
                                            }
                                            Util.getCellRegistry().getHandlerForCell(itemstack).extractItems(request);
                                            break block0;
                                        }
                                        case WEST: {
                                            for (int posZ = z - 1; posZ < z + 2; ++posZ) {
                                                for (int posY = y - 1; posY < y + 2; ++posY) {
                                                    world.func_94578_a(x, posY, posZ, true);
                                                    this.placeBlock(request.getItemStack(), world, player, x, posY, posZ, side, xOffset, yOffset, zOffset);
                                                }
                                            }
                                            Util.getCellRegistry().getHandlerForCell(itemstack).extractItems(request);
                                            break block0;
                                        }
                                    }
                                }
                            }
                            return true;
                        }
                        return false;
                    }
                    player.func_71035_c(StatCollector.func_74838_a((String)"tooltip.onlyblocks"));
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void placeBlock(ItemStack itemstack, World world, EntityPlayer player, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        ItemBlock itemblock = (ItemBlock)itemstack.func_77973_b();
        switch (ForgeDirection.getOrientation((int)side)) {
            case DOWN: {
                itemblock.onItemUseFirst(itemstack, player, world, x, y++, z, side, xOffset, yOffset, zOffset);
                itemblock.func_77648_a(itemstack, player, world, x, y++, z, side, xOffset, yOffset, zOffset);
                break;
            }
            case EAST: {
                itemblock.onItemUseFirst(itemstack, player, world, x--, y, z, side, xOffset, yOffset, zOffset);
                itemblock.func_77648_a(itemstack, player, world, x--, y, z, side, xOffset, yOffset, zOffset);
                break;
            }
            case NORTH: {
                itemblock.onItemUseFirst(itemstack, player, world, x, y, z++, side, xOffset, yOffset, zOffset);
                itemblock.func_77648_a(itemstack, player, world, x, y, z++, side, xOffset, yOffset, zOffset);
                break;
            }
            case SOUTH: {
                itemblock.onItemUseFirst(itemstack, player, world, x, y, z--, side, xOffset, yOffset, zOffset);
                itemblock.func_77648_a(itemstack, player, world, x, y, z--, side, xOffset, yOffset, zOffset);
                break;
            }
            case UNKNOWN: {
                break;
            }
            case UP: {
                itemblock.onItemUseFirst(itemstack, player, world, x, y--, z, side, xOffset, yOffset, zOffset);
                itemblock.func_77648_a(itemstack, player, world, x, y--, z, side, xOffset, yOffset, zOffset);
                break;
            }
            case WEST: {
                itemblock.onItemUseFirst(itemstack, player, world, x++, y, z, side, xOffset, yOffset, zOffset);
                itemblock.func_77648_a(itemstack, player, world, x++, y, z, side, xOffset, yOffset, zOffset);
                break;
            }
        }
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(ItemStack i) {
        return i != null ? i.func_77973_b() == this : false;
    }
}

