/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.IAEItemStack;
import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.config.RedstoneModeInput;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.ITileCable;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import extracells.BlockEnum;
import extracells.Extracells;
import extracells.ItemEnum;
import extracells.gui.widget.WidgetFluidModes;
import extracells.tileentity.ColorableECTile;
import extracells.util.ECPrivateInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBusFluidImport
extends ColorableECTile
implements IGridMachine,
IDirectionalMETile,
IFluidHandler,
ITileCable {
    boolean powerStatus = true;
    boolean redstoneFlag = false;
    boolean networkReady = true;
    boolean redstoneStatus = false;
    boolean fluidHandlerCached = false;
    boolean redStoneCached = false;
    private IGridInterface grid;
    private String customName = StatCollector.func_74838_a((String)"tile.block.fluid.bus.import");
    private ECPrivateInventory inventory = new ECPrivateInventory(this.customName, 8, 1);
    private RedstoneModeInput redstoneMode = RedstoneModeInput.Ignore;
    private WidgetFluidModes.FluidMode fluidMode = WidgetFluidModes.FluidMode.DROPS;
    private IFluidHandler fluidHandler = null;
    private int currentTick = 0;
    private final int tickRate = Extracells.tickRateImport;

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            ++this.currentTick;
            if (this.currentTick == this.tickRate) {
                this.currentTick = 0;
                this.doUpdateEntity();
            }
        }
    }

    public void doUpdateEntity() {
        if (!this.redStoneCached || !this.fluidHandlerCached) {
            BlockEnum.FLUIDIMPORT.getBlockInstance().func_71863_a(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 1);
            this.redStoneCached = true;
            this.fluidHandlerCached = true;
        }
        if (!this.field_70331_k.field_72995_K && this.isPowered() && this.grid != null && this.fluidHandler != null) {
            switch (this.getRedstoneMode()) {
                case WhenOn: {
                    if (!this.redstoneStatus) break;
                    this.doWork(this.fluidMode);
                    break;
                }
                case WhenOff: {
                    if (this.redstoneStatus) break;
                    this.doWork(this.fluidMode);
                    break;
                }
                case OnPulse: {
                    if (!this.redstoneStatus) {
                        this.redstoneFlag = false;
                        break;
                    }
                    if (!this.redstoneFlag) {
                        this.doWork(this.fluidMode);
                        break;
                    }
                    this.redstoneFlag = true;
                    this.doWork(this.fluidMode);
                    break;
                }
                case Ignore: {
                    this.doWork(this.fluidMode);
                    break;
                }
            }
        }
    }

    public void setFluidHandler(IFluidHandler handler) {
        this.fluidHandler = handler;
    }

    public void setRedstoneStatus(boolean redstone) {
        this.redstoneStatus = redstone;
    }

    private void doWork(WidgetFluidModes.FluidMode mode) {
        int modeAmount = mode.getAmount() * this.tickRate;
        float modeCost = mode.getCost() * (float)this.tickRate;
        ForgeDirection facing = ForgeDirection.getOrientation((int)this.func_70322_n());
        FluidStack drainable = this.fluidHandler.drain(facing.getOpposite(), modeAmount, false);
        if (drainable != null && drainable.amount > 0) {
            List<Fluid> fluidFilter = this.getFilterFluids(this.inventory.slots);
            IAEItemStack toImport = Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), drainable.amount, drainable.fluidID));
            IMEInventoryHandler cellArray = this.getGrid().getCellArray();
            if (cellArray != null) {
                FluidStack drained;
                IAEItemStack notImported = cellArray.calculateItemAddition(toImport.copy());
                if (fluidFilter != null && !fluidFilter.isEmpty() && fluidFilter.size() > 0) {
                    FluidStack drained2;
                    if (fluidFilter.contains(drainable.getFluid()) && notImported == null && this.grid.useMEEnergy(modeCost, "Import Fluid") && (drained2 = this.fluidHandler.drain(facing.getOpposite(), (int)toImport.getStackSize(), true)) != null) {
                        cellArray.addItems(toImport.copy());
                    }
                } else if (notImported == null && this.grid.useMEEnergy(modeCost, "Import Fluid") && (drained = this.fluidHandler.drain(facing.getOpposite(), (int)toImport.getStackSize(), true)) != null) {
                    cellArray.addItems(toImport.copy());
                }
            }
        }
    }

    public List<Fluid> getFilterFluids(List<ItemStack> filterItemStacks) {
        ArrayList<Fluid> filterFluids = new ArrayList<Fluid>();
        if (filterItemStacks != null) {
            for (ItemStack entry : filterItemStacks) {
                FluidStack contained;
                if (entry == null) continue;
                if (entry.func_77973_b() instanceof IFluidContainerItem && (contained = ((IFluidContainerItem)entry.func_77973_b()).getFluid(entry)) != null) {
                    filterFluids.add(contained.getFluid());
                }
                if (!FluidContainerRegistry.isFilledContainer((ItemStack)entry)) continue;
                filterFluids.add(FluidContainerRegistry.getFluidForFilledItem((ItemStack)entry).getFluid());
            }
        }
        return filterFluids;
    }

    public RedstoneModeInput getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneModeInput mode) {
        this.redstoneMode = mode;
    }

    public WidgetFluidModes.FluidMode getFluidMode() {
        return this.fluidMode;
    }

    public void setFluidMode(WidgetFluidModes.FluidMode mode) {
        this.fluidMode = mode;
    }

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = this.getColorDataForPacket();
        this.func_70310_b(nbtTag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        super.onDataPacket(net, packet);
        this.func_70307_a(packet.field_73331_e);
    }

    public void func_70312_q() {
        super.func_70312_q();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public void func_70313_j() {
        super.func_70313_j();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public WorldCoord getLocation() {
        return new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isValid() {
        return true;
    }

    public void setPowerStatus(boolean hasPower) {
        this.powerStatus = hasPower;
    }

    public boolean isPowered() {
        return this.powerStatus;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setGrid(IGridInterface gi) {
        this.grid = gi;
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public boolean canConnect(ForgeDirection dir) {
        return dir.ordinal() != this.field_70325_p;
    }

    public float getPowerDrainPerTick() {
        return 0.0f;
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74782_a("Items", (NBTBase)this.inventory.writeToNBT());
        if (this.getInventory().func_94042_c()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        nbt.func_74768_a("RedstoneMode", this.getRedstoneMode().ordinal());
        nbt.func_74768_a("FluidMode", this.getFluidMode().ordinal());
        nbt.func_74757_a("RedstoneState", this.redstoneStatus);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList nbttaglist = nbt.func_74761_m("Items");
        this.inventory.readFromNBT(nbttaglist);
        if (nbt.func_74764_b("CustomName")) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        this.setRedstoneMode(RedstoneModeInput.values()[nbt.func_74762_e("RedstoneMode")]);
        this.setFluidMode(WidgetFluidModes.FluidMode.values()[nbt.func_74762_e("FluidMode")]);
        this.redstoneStatus = nbt.func_74767_n("RedstoneState");
    }

    public ECPrivateInventory getInventory() {
        return this.inventory;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.redstoneStatus && this.getRedstoneMode() == RedstoneModeInput.WhenOn || this.redstoneStatus && this.getRedstoneMode() == RedstoneModeInput.WhenOff) {
            return 0;
        }
        if (resource != null && this.getGrid() != null && this.isPowered() && from.ordinal() == this.field_70325_p) {
            int amount = resource.amount;
            int fluidID = resource.fluidID;
            IAEItemStack temp = Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), amount, fluidID));
            temp.setStackSize((long)amount);
            IMEInventoryHandler cellArray = this.getGrid().getCellArray();
            if (cellArray != null) {
                IAEItemStack added = doFill ? cellArray.addItems(temp) : cellArray.calculateItemAddition(temp);
                if (added == null) {
                    if (doFill) {
                        this.getGrid().useMEEnergy((float)(amount / 50), "Import Fluid");
                    }
                    return resource.amount;
                }
                if (added.getStackSize() > 0L) {
                    if (doFill) {
                        this.getGrid().useMEEnergy((float)(((long)amount - added.getStackSize()) / 50L), "Import Fluid");
                    }
                    return (int)((long)resource.amount - added.getStackSize());
                }
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.grid != null) {
            IMEInventoryHandler cellArray = this.grid.getCellArray();
            return cellArray != null && fluid != null && cellArray.canAccept(Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1, fluid.getID())));
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.getGrid() != null && from.ordinal() == this.field_70325_p) {
            ArrayList<FluidTankInfo> tankInfo = new ArrayList<FluidTankInfo>();
            FluidTankInfo[] tankArray = new FluidTankInfo[1];
            IMEInventoryHandler cellArray = this.grid.getCellArray();
            if (cellArray != null) {
                for (IAEItemStack item : cellArray.getAvailableItems()) {
                    if (item.getItem() != ItemEnum.FLUIDDISPLAY.getItemInstance()) continue;
                    tankInfo.add(new FluidTankInfo(new FluidStack(FluidRegistry.getFluid((int)item.getItemDamage()), (int)item.getStackSize()), (int)this.getGrid().getCellArray().freeBytes()));
                }
                if (tankInfo.isEmpty()) {
                    tankInfo.add(new FluidTankInfo(null, (int)cellArray.freeBytes()));
                }
                tankArray = tankInfo.toArray(tankArray);
                return tankArray;
            }
        }
        return null;
    }

    public boolean coveredConnections() {
        return false;
    }

    public void setNetworkReady(boolean isReady) {
        this.networkReady = isReady;
    }

    public boolean isMachineActive() {
        return this.powerStatus && this.networkReady;
    }
}

