/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.events.GridStorageUpdateEvent;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.me.tiles.ICellContainer;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import extracells.tileentity.ColorableECTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityHardMEDrive
extends ColorableECTile
implements IInventory,
IGridMachine,
ICellContainer {
    Boolean powerStatus = true;
    Boolean networkReady = true;
    private IGridInterface grid;
    private String customName = StatCollector.func_74838_a((String)"tile.block.hardmedrive");
    private ItemStack[] slots = new ItemStack[3];

    public void func_70312_q() {
        super.func_70312_q();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public void func_70313_j() {
        super.func_70313_j();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = this.getColorDataForPacket();
        this.func_70310_b(nbtTag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_94042_c()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList nbttaglist = nbt.func_74761_m("Items");
        this.slots = new ItemStack[this.func_70302_i_()];
        if (nbt.func_74764_b("CustomName")) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.slots.length) continue;
            this.slots[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public int func_70302_i_() {
        return 3;
    }

    public ItemStack func_70301_a(int i) {
        if (this.slots[i] != null) {
            return this.slots[i];
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemstack = this.slots[i];
                this.slots[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemstack = this.slots[i];
            this.slots[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.slots[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n), this.getGrid()));
    }

    public String func_70303_b() {
        return this.customName;
    }

    public boolean func_94042_c() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return Util.getCellRegistry().isCellHandled(itemstack);
    }

    public WorldCoord getLocation() {
        return new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isValid() {
        return true;
    }

    public void setPowerStatus(boolean hasPower) {
        this.powerStatus = hasPower;
    }

    public boolean isPowered() {
        return this.powerStatus;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setGrid(IGridInterface gi) {
        this.grid = gi;
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public List<IMEInventoryHandler> getCellArray() {
        if (this.powerStatus.booleanValue()) {
            ArrayList<IMEInventoryHandler> cellArray = new ArrayList<IMEInventoryHandler>();
            for (ItemStack current : this.slots) {
                if (!Util.getCellRegistry().isCellHandled(current)) continue;
                cellArray.add(Util.getCellRegistry().getHandlerForCell(current));
            }
            return cellArray;
        }
        return null;
    }

    public int getPriority() {
        return 0;
    }

    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    public void setNetworkReady(boolean isReady) {
        this.networkReady = isReady;
    }

    public boolean isMachineActive() {
        return this.powerStatus != false && this.networkReady != false;
    }
}

