/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.lib.lang.LangUtil;
import java.util.HashSet;

public enum ChunkLoaderShape {
    Square("square"),
    Circle("circle"),
    LineX("linex"),
    LineZ("linez");

    String name;

    private ChunkLoaderShape(String s) {
        this.name = s;
    }

    public HashSet<abp> getChunks(int radius, abp center) {
        HashSet<abp> chunkset = new HashSet<abp>();
        --radius;
        switch (this) {
            case Square: {
                for (int x = center.a - radius; x <= center.a + radius; ++x) {
                    for (int z = center.b - radius; z <= center.b + radius; ++z) {
                        chunkset.add(new abp(x, z));
                    }
                }
                break;
            }
            case LineX: {
                for (int x = center.a - radius; x <= center.a + radius; ++x) {
                    chunkset.add(new abp(x, center.b));
                }
                break;
            }
            case LineZ: {
                for (int z = center.b - radius; z <= center.b + radius; ++z) {
                    chunkset.add(new abp(center.a, z));
                }
                break;
            }
            case Circle: {
                for (int x = center.a - radius; x <= center.a + radius; ++x) {
                    for (int z = center.b - radius; z <= center.b + radius; ++z) {
                        int relx = x - center.a;
                        int relz = z - center.b;
                        double dist = Math.sqrt(relx * relx + relz * relz);
                        if (!(dist <= (double)radius)) continue;
                        chunkset.add(new abp(x, z));
                    }
                }
                break;
            }
        }
        return chunkset;
    }

    public ChunkLoaderShape next() {
        int index = this.ordinal();
        if (++index == ChunkLoaderShape.values().length) {
            index = 0;
        }
        return ChunkLoaderShape.values()[index];
    }

    public ChunkLoaderShape prev() {
        int index = this.ordinal();
        if (--index == -1) {
            index = ChunkLoaderShape.values().length - 1;
        }
        return ChunkLoaderShape.values()[index];
    }

    public HashSet<abp> getLoadedChunks(int chunkx, int chunkz, int radius) {
        HashSet<abp> chunkSet = new HashSet<abp>();
        switch (this) {
            case Square: {
                for (int cx = chunkx - radius; cx <= chunkx + radius; ++cx) {
                    for (int cz = chunkz - radius; cz <= chunkz + radius; ++cz) {
                        chunkSet.add(new abp(cx, cz));
                    }
                }
                break;
            }
            case LineX: {
                for (int cx = chunkx - radius; cx <= chunkx + radius; ++cx) {
                    chunkSet.add(new abp(cx, chunkz));
                }
                break;
            }
            case LineZ: {
                for (int cz = chunkz - radius; cz <= chunkz + radius; ++cz) {
                    chunkSet.add(new abp(chunkx, cz));
                }
                break;
            }
            case Circle: {
                for (int cx = chunkx - radius; cx <= chunkx + radius; ++cx) {
                    for (int cz = chunkz - radius; cz <= chunkz + radius; ++cz) {
                        double distSquared = (cx - chunkx) * (cx - chunkx) + (cz - chunkz) * (cz - chunkz);
                        if (!(distSquared <= (double)(radius * radius))) continue;
                        chunkSet.add(new abp(cx, cz));
                    }
                }
                break;
            }
        }
        return chunkSet;
    }

    public String getName() {
        return LangUtil.translateG((String)("chickenchunks.shape." + this.name), (Object[])new Object[0]);
    }
}

