/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.lighting;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IVertexModifier;
import codechicken.lib.render.UV;
import codechicken.lib.vec.Vector3;

public class PlanarLightModel
implements IVertexModifier {
    public static PlanarLightModel standardLightModel = LightModel.standardLightModel.reducePlanar();
    public ColourRGBA[] colours = new ColourRGBA[6];

    public PlanarLightModel(int[] colours) {
        for (int i = 0; i < 6; ++i) {
            this.colours[i] = new ColourRGBA(colours[i]);
        }
    }

    @Override
    public void applyModifiers(CCModel m, bfq tess, Vector3 vec, UV uv, Vector3 normal, int i) {
        ColourRGBA light = this.colours[CCModel.findSide(normal)];
        int colour = m == null || m.colours == null ? -1 : m.colours[i];
        Colour res = new ColourRGBA(colour).multiply(light);
        CCRenderState.vertexColour(res.r & 0xFF, res.g & 0xFF, res.b & 0xFF, res.a & 0xFF);
    }

    @Override
    public boolean needsNormals() {
        return true;
    }
}

