/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.packet;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.MetaPacket;
import codechicken.lib.vec.BlockCoord;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.ITinyPacketHandler;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fluids.FluidStack;

public final class PacketCustom
implements MCDataInput,
MCDataOutput {
    public static PacketAssembler assembler = new PacketAssembler();
    public static IPacketCarrier carrier250 = new Packet250Carrier();
    public static IPacketCarrier carrier131 = new Packet131Carrier();
    private static int assemblyID = 0;
    private Object channel;
    private int type;
    private boolean isChunkDataPacket;
    private ByteArrayOutputStream dataarrayout;
    private DataOutputStream dataout;
    private DataInputStream datain;
    private static HashMap<String, CustomPacketHandler> clienthandlermap = new HashMap();
    private static HashMap<String, CustomPacketHandler> serverhandlermap = new HashMap();

    public static IPacketCarrier carrierForChannel(Object channel) {
        if (channel instanceof String) {
            return carrier250;
        }
        if (FMLNetworkHandler.instance().findNetworkModHandler(channel) != null) {
            return carrier131;
        }
        return null;
    }

    public static void writeInt(byte[] b, int pos, int i) {
        b[pos++] = (byte)(i >>> 24);
        b[pos++] = (byte)(i >> 16);
        b[pos++] = (byte)(i >> 8);
        b[pos++] = (byte)i;
    }

    public static int readInt(byte[] b, int pos) {
        return (b[pos++] & 0xFF) << 24 | (b[pos++] & 0xFF) << 16 | (b[pos++] & 0xFF) << 8 | b[pos++] & 0xFF;
    }

    private PacketCustom(Object channel, int type, byte[] data) {
        this.channel = channel;
        this.type = type;
        if (type > 128) {
            data = this.decompress(data);
        }
        this.datain = new DataInputStream(new ByteArrayInputStream(data));
    }

    public PacketCustom(Object channel, int type) {
        if (type <= 0 || type >= 128) {
            throw new IllegalArgumentException("Packet type: " + type + " is not within required 0 < t < 0x80");
        }
        this.channel = channel;
        this.type = type;
        this.isChunkDataPacket = false;
        this.dataarrayout = new ByteArrayOutputStream();
        this.dataout = new DataOutputStream(this.dataarrayout);
    }

    public boolean incoming() {
        return this.dataout == null;
    }

    public int getType() {
        return this.type & 0x7F;
    }

    public PacketCustom setChunkDataPacket() {
        this.isChunkDataPacket = true;
        return this;
    }

    private byte[] decompress(byte[] cdata) {
        if ((this.type & 0x80) == 0) {
            return cdata;
        }
        Inflater inflater = new Inflater();
        try {
            byte[] ddata = new byte[PacketCustom.readInt(cdata, 0)];
            inflater.setInput(cdata, 4, cdata.length - 4);
            inflater.inflate(ddata);
            byte[] byArray = ddata;
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            inflater.end();
        }
    }

    public PacketCustom compressed() {
        if (this.incoming()) {
            throw new IllegalStateException("Tried to compress an incoming packet");
        }
        if ((this.type & 0x80) != 0) {
            throw new IllegalStateException("Packet already compressed");
        }
        this.type |= 0x80;
        return this;
    }

    private byte[] compress(byte[] data) {
        Deflater deflater = new Deflater();
        try {
            deflater.setInput(data, 0, data.length);
            deflater.finish();
            byte[] cbuf = new byte[data.length];
            int clen = deflater.deflate(cbuf, 0, data.length);
            if (clen == data.length || !deflater.finished()) {
                this.type &= 0x7F;
                byte[] byArray = data;
                return byArray;
            }
            byte[] cdata = new byte[clen + 4];
            PacketCustom.writeInt(cdata, 0, data.length);
            System.arraycopy(cbuf, 0, cdata, 4, clen);
            this.type |= 0x80;
            byte[] byArray = cdata;
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            deflater.end();
        }
    }

    public ey toPacket() {
        if (this.incoming()) {
            throw new IllegalStateException("Tried to write an incoming packet");
        }
        try {
            this.dataout.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] data = this.dataarrayout.toByteArray();
        if (data.length > 32000 || (this.type & 0x80) != 0) {
            data = this.compress(data);
        }
        IPacketCarrier carrier = PacketCustom.carrierForChannel(this.channel);
        if (data.length > 32000 && carrier.shortCapped()) {
            MetaPacket payload = new MetaPacket(new ey[0]);
            int asmID = assemblyID++;
            byte[] hdata = new byte[9];
            PacketCustom.writeInt(hdata, 0, asmID);
            hdata[4] = (byte)this.type;
            PacketCustom.writeInt(hdata, 5, data.length);
            payload.packets.add(carrier.write(this.channel, this.isChunkDataPacket, 128, hdata));
            for (int i = 0; i < data.length; i += 32000) {
                int size = Math.min(data.length - i, 32000);
                byte[] sdata = new byte[size + 4];
                PacketCustom.writeInt(sdata, 0, asmID);
                System.arraycopy(data, i, sdata, 4, size);
                payload.packets.add(carrier.write(this.channel, this.isChunkDataPacket, 128, sdata));
            }
            return payload;
        }
        return carrier.write(this.channel, this.isChunkDataPacket, this.type, data);
    }

    @Override
    public PacketCustom writeBoolean(boolean b) {
        try {
            this.dataout.writeBoolean(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public PacketCustom writeByte(int b) {
        try {
            this.dataout.writeByte(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public PacketCustom writeShort(int s) {
        try {
            this.dataout.writeShort(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public PacketCustom writeInt(int i) {
        try {
            this.dataout.writeInt(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public PacketCustom writeFloat(float f) {
        try {
            this.dataout.writeFloat(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public PacketCustom writeDouble(double d) {
        try {
            this.dataout.writeDouble(d);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public PacketCustom writeLong(long l) {
        try {
            this.dataout.writeLong(l);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public PacketCustom writeChar(char c) {
        try {
            this.dataout.writeChar(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public PacketCustom writeByteArray(byte[] barray) {
        try {
            this.dataout.write(barray);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public PacketCustom writeCoord(int x, int y, int z) {
        this.writeInt(x);
        this.writeInt(y);
        this.writeInt(z);
        return this;
    }

    @Override
    public PacketCustom writeCoord(BlockCoord coord) {
        this.writeInt(coord.x);
        this.writeInt(coord.y);
        this.writeInt(coord.z);
        return this;
    }

    @Override
    public PacketCustom writeString(String s) {
        try {
            if (s.length() > 65535) {
                throw new IOException("String length: " + s.length() + "too long.");
            }
            this.dataout.writeShort(s.length());
            this.dataout.writeChars(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public PacketCustom writeItemStack(ye stack) {
        this.writeItemStack(stack, false);
        return this;
    }

    public PacketCustom writeItemStack(ye stack, boolean large) {
        if (stack == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(stack.d);
            if (large) {
                this.writeInt(stack.b);
            } else {
                this.writeByte(stack.b);
            }
            this.writeShort(stack.k());
            this.writeNBTTagCompound(stack.e);
        }
        return this;
    }

    @Override
    public PacketCustom writeNBTTagCompound(by compound) {
        try {
            if (compound == null) {
                this.writeShort(-1);
            } else {
                byte[] bytes = ci.a((by)compound);
                this.writeShort((short)bytes.length);
                this.writeByteArray(bytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public PacketCustom writeFluidStack(FluidStack fluid) {
        if (fluid == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(fluid.fluidID);
            this.writeInt(fluid.amount);
            this.writeNBTTagCompound(fluid.tag);
        }
        return this;
    }

    @Override
    public boolean readBoolean() {
        try {
            return this.datain.readBoolean();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readUByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public byte readByte() {
        try {
            return this.datain.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public short readShort() {
        try {
            return this.datain.readShort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readInt() {
        try {
            return this.datain.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public float readFloat() {
        try {
            return this.datain.readFloat();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double readDouble() {
        try {
            return this.datain.readDouble();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.datain.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public char readChar() {
        try {
            return this.datain.readChar();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BlockCoord readCoord() {
        return new BlockCoord(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    public byte[] readByteArray(int length) {
        try {
            byte[] barray = new byte[length];
            this.datain.readFully(barray, 0, length);
            return barray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readString() {
        try {
            int length = this.datain.readUnsignedShort();
            char[] chars = new char[length];
            for (int i = 0; i < length; ++i) {
                chars[i] = this.readChar();
            }
            return new String(chars);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ye readItemStack() {
        return this.readItemStack(false);
    }

    public ye readItemStack(boolean large) {
        ye item = null;
        short itemID = this.readShort();
        if (itemID >= 0) {
            int stackSize = large ? this.readInt() : (int)this.readByte();
            short damage = this.readShort();
            item = new ye((int)itemID, stackSize, (int)damage);
            item.e = this.readNBTTagCompound();
        }
        return item;
    }

    @Override
    public by readNBTTagCompound() {
        try {
            short len = this.readShort();
            if (len < 0) {
                return null;
            }
            byte[] bytes = this.readByteArray(len);
            return ci.a((byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FluidStack readFluidStack() {
        FluidStack fluid = null;
        short fluidID = this.readShort();
        if (fluidID >= 0) {
            fluid = new FluidStack((int)fluidID, this.readInt(), this.readNBTTagCompound());
        }
        return fluid;
    }

    public static void assignHandler(String channel, int firstID, int lastID, ICustomPacketHandler IHandler) {
        Side side = IHandler instanceof IClientPacketHandler ? Side.CLIENT : Side.SERVER;
        HashMap<String, CustomPacketHandler> handlerMap = side.isClient() ? clienthandlermap : serverhandlermap;
        CustomPacketHandler handler = handlerMap.get(channel);
        if (handler == null) {
            handler = side.isClient() ? new ClientPacketHandler(channel) : new ServerPacketHandler(channel);
            handlerMap.put(channel, handler);
        }
        handler.registerRange(firstID, lastID, IHandler);
    }

    public static void assignHandler(Object mod, ICustomPacketHandler handler) {
        NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mod);
        if (nmh == null || nmh.getTinyPacketHandler() == null || !(nmh.getTinyPacketHandler() instanceof CustomTinyPacketHandler)) {
            throw new IllegalStateException("Invalid network tiny packet handler for mod: " + mod);
        }
        ((CustomTinyPacketHandler)nmh.getTinyPacketHandler()).registerSidedHandler(handler);
    }

    public void sendToPlayer(uf player) {
        PacketCustom.sendToPlayer(this.toPacket(), player);
    }

    public static void sendToPlayer(ey packet, uf player) {
        if (player == null) {
            PacketCustom.sendToClients(packet);
        } else {
            ((jv)player).a.b(packet);
        }
    }

    public void sendToClients() {
        PacketCustom.sendToClients(this.toPacket());
    }

    public static void sendToClients(ey packet) {
        MinecraftServer.F().af().a(packet);
    }

    public void sendPacketToAllAround(double x, double y, double z, double range, int dim) {
        PacketCustom.sendToAllAround(this.toPacket(), x, y, z, range, dim);
    }

    public static void sendToAllAround(ey packet, double x, double y, double z, double range, int dim) {
        MinecraftServer.F().af().a(x, y, z, range, dim, packet);
    }

    public void sendToDimension(int dim) {
        PacketCustom.sendToDimension(this.toPacket(), dim);
    }

    public static void sendToDimension(ey packet, int dim) {
        MinecraftServer.F().af().a(packet, dim);
    }

    public void sendToChunk(abw world, int chunkX, int chunkZ) {
        PacketCustom.sendToChunk(this.toPacket(), world, chunkX, chunkZ);
    }

    public static void sendToChunk(ey packet, abw world, int chunkX, int chunkZ) {
        jq p = ((js)world).s().a(chunkX, chunkZ, false);
        if (p != null) {
            p.a(packet);
        }
    }

    public void sendToOps() {
        PacketCustom.sendToOps(this.toPacket());
    }

    public static void sendToOps(ey packet) {
        for (jv player : MinecraftServer.F().af().a) {
            if (!MinecraftServer.F().af().e(player.bu)) continue;
            PacketCustom.sendToPlayer(packet, (uf)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendToServer() {
        PacketCustom.sendToServer(this.toPacket());
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendToServer(ey packet) {
        atv.w().q().c(packet);
    }

    public static class Packet131Carrier
    implements IPacketCarrier {
        @Override
        public int readType(ey packet) {
            return ((dr)packet).b & 0xFF;
        }

        @Override
        public byte[] readData(ey packet) {
            return ((dr)packet).c;
        }

        @Override
        public Object readChannel(ey packet) {
            return ((dr)packet).a;
        }

        @Override
        public ey write(Object channel, boolean chunkDataPacket, int type, byte[] data) {
            NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(channel);
            dr payload = new dr((short)nmh.getNetworkId(), (short)type, data);
            payload.s = chunkDataPacket;
            return payload;
        }

        @Override
        public boolean shortCapped() {
            return true;
        }
    }

    public static class Packet250Carrier
    implements IPacketCarrier {
        @Override
        public int readType(ey packet) {
            return ((ea)packet).c[0] & 0xFF;
        }

        @Override
        public byte[] readData(ey packet) {
            byte[] data = ((ea)packet).c;
            return Arrays.copyOfRange(data, 1, data.length);
        }

        @Override
        public Object readChannel(ey packet) {
            return ((ea)packet).a;
        }

        @Override
        public ey write(Object channel, boolean chunkDataPacket, int type, byte[] data) {
            byte[] pdata = new byte[data.length + 1];
            pdata[0] = (byte)type;
            System.arraycopy(data, 0, pdata, 1, data.length);
            ea payload = new ea();
            payload.a = (String)channel;
            payload.s = chunkDataPacket;
            payload.c = pdata;
            payload.b = payload.c.length;
            return payload;
        }

        @Override
        public boolean shortCapped() {
            return true;
        }
    }

    public static interface IPacketCarrier {
        public int readType(ey var1);

        public byte[] readData(ey var1);

        public Object readChannel(ey var1);

        public ey write(Object var1, boolean var2, int var3, byte[] var4);

        public boolean shortCapped();
    }

    private static class NetClientHandlerHelper
    implements IConnectionHandler {
        private static boolean registered = false;
        public static bcw handler;

        private NetClientHandlerHelper() {
        }

        public static void register() {
            if (registered) {
                return;
            }
            NetworkRegistry.instance().registerConnectionHandler((IConnectionHandler)new NetClientHandlerHelper());
            registered = true;
        }

        public void connectionOpened(ez netClientHandler, MinecraftServer server, cm manager) {
            handler = (bcw)netClientHandler;
        }

        public void connectionOpened(ez netClientHandler, String server, int port, cm manager) {
            handler = (bcw)netClientHandler;
        }

        public void connectionClosed(cm manager) {
        }

        public String connectionReceived(jy netHandler, cm manager) {
            return null;
        }

        public void clientLoggedIn(ez clientHandler, cm manager, ep login) {
        }

        public void playerLoggedIn(Player player, ez netHandler, cm manager) {
        }
    }

    public static final class CustomTinyPacketHandler
    implements ITinyPacketHandler {
        private ClientTinyPacketHandler clientDelegate;
        private ServerTinyPacketHandler serverDelegate;

        public void handle(ez handler, dr packet) {
            PacketCustom packetCustom = assembler.assemble(carrier131, (ey)packet);
            if (packetCustom == null) {
                return;
            }
            if (handler instanceof ka) {
                this.serverDelegate.handle(packetCustom, handler);
            } else {
                this.clientDelegate.handle(packetCustom, handler);
            }
        }

        private void registerSidedHandler(ICustomPacketHandler handler) {
            if (handler instanceof IClientPacketHandler) {
                if (this.clientDelegate != null) {
                    throw new IllegalStateException("Client handler already registered");
                }
                this.clientDelegate = new ClientTinyPacketHandler((IClientPacketHandler)handler);
            } else if (handler instanceof IServerPacketHandler) {
                if (this.serverDelegate != null) {
                    throw new IllegalStateException("Server handler already registered");
                }
                this.serverDelegate = new ServerTinyPacketHandler((IServerPacketHandler)handler);
            } else {
                throw new IllegalStateException("Handler is not a client or server handler");
            }
        }
    }

    private static class ClientTinyPacketHandler {
        IClientPacketHandler clientHandler;

        public ClientTinyPacketHandler(IClientPacketHandler handler) {
            this.clientHandler = handler;
        }

        public void handle(PacketCustom packetCustom, ez handler) {
            this.clientHandler.handlePacket(packetCustom, (bcw)handler, atv.w());
        }
    }

    private static class ServerTinyPacketHandler {
        IServerPacketHandler serverHandler;

        public ServerTinyPacketHandler(IServerPacketHandler handler) {
            this.serverHandler = handler;
        }

        public void handle(PacketCustom packetCustom, ez handler) {
            this.serverHandler.handlePacket(packetCustom, (ka)handler, ((ka)handler).c);
        }
    }

    private static class ServerPacketHandler
    extends CustomPacketHandler {
        public ServerPacketHandler(String channel) {
            super(channel);
        }

        @Override
        public Side getSide() {
            return Side.SERVER;
        }

        @Override
        public void handle(ICustomPacketHandler handler, PacketCustom packet, Player player) {
            ((IServerPacketHandler)handler).handlePacket(packet, ((jv)player).a, (jv)player);
        }
    }

    private static class ClientPacketHandler
    extends CustomPacketHandler {
        public ClientPacketHandler(String channel) {
            super(channel);
            NetClientHandlerHelper.register();
        }

        @Override
        public Side getSide() {
            return Side.CLIENT;
        }

        @Override
        public void handle(ICustomPacketHandler handler, PacketCustom packet, Player player) {
            ((IClientPacketHandler)handler).handlePacket(packet, NetClientHandlerHelper.handler, atv.w());
        }
    }

    private static abstract class CustomPacketHandler
    implements IPacketHandler {
        HashMap<Integer, ICustomPacketHandler> handlermap = new HashMap();

        public CustomPacketHandler(String channel) {
            NetworkRegistry.instance().registerChannel((IPacketHandler)this, channel, this.getSide());
        }

        public void onPacketData(cm manager, ea packet, Player player) {
            PacketCustom packetCustom = assembler.assemble(carrier250, (ey)packet);
            if (packetCustom == null) {
                return;
            }
            ICustomPacketHandler handler = this.handlermap.get(packetCustom.getType());
            if (handler != null) {
                this.handle(handler, packetCustom, player);
            }
        }

        public void registerRange(int firstID, int lastID, ICustomPacketHandler handler) {
            for (int i = firstID; i <= lastID; ++i) {
                this.handlermap.put(i, handler);
            }
        }

        public abstract Side getSide();

        public abstract void handle(ICustomPacketHandler var1, PacketCustom var2, Player var3);
    }

    public static class PacketAssembler {
        public HashMap<Integer, AssemblyEntry> assemblerMap = new HashMap();

        public PacketCustom assemble(IPacketCarrier carrier, ey packet) {
            int type = carrier.readType(packet);
            if (type != 128) {
                return new PacketCustom(carrier.readChannel(packet), carrier.readType(packet), carrier.readData(packet));
            }
            byte[] data = carrier.readData(packet);
            int asmID = PacketCustom.readInt(data, 0);
            AssemblyEntry e = this.assemblerMap.get(asmID);
            if (e == null) {
                e = new AssemblyEntry(carrier.readChannel(packet), data[4] & 0xFF, PacketCustom.readInt(data, 5));
                this.assemblerMap.put(asmID, e);
                return null;
            }
            e.append(data, 4, data.length - 4);
            PacketCustom ret = e.finished();
            if (ret != null) {
                this.assemblerMap.remove(asmID);
            }
            return ret;
        }

        public class AssemblyEntry {
            Object channel;
            int type;
            int pos;
            byte[] data;

            public AssemblyEntry(Object channel, int type, int length) {
                this.channel = channel;
                this.type = type;
                this.data = new byte[length];
            }

            public void append(byte[] b, int off, int len) {
                System.arraycopy(b, off, this.data, this.pos, len);
                this.pos += len;
            }

            public PacketCustom finished() {
                if (this.pos < this.data.length) {
                    return null;
                }
                return new PacketCustom(this.channel, this.type, this.data);
            }
        }
    }

    public static interface IServerPacketHandler
    extends ICustomPacketHandler {
        public void handlePacket(PacketCustom var1, ka var2, jv var3);
    }

    public static interface IClientPacketHandler
    extends ICustomPacketHandler {
        public void handlePacket(PacketCustom var1, bcw var2, atv var3);
    }

    public static interface ICustomPacketHandler {
    }
}

