/*
 * Decompiled with CFR 0.152.
 */
package enviromine;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import enviromine.EnviroDamageSource;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.EM_PhysManager;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockSand;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingSand;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityPhysicsBlock
extends EntityFallingSand
implements IEntityAdditionalSpawnData {
    public boolean isAnvil2 = true;
    public boolean isBreakingAnvil2;
    public int fallHurtMax2;
    public float fallHurtAmount2;
    public boolean isLandSlide = false;

    public EntityPhysicsBlock(World world) {
        super(world);
        List entityList;
        this.func_82154_e(true);
        this.fallHurtMax2 = 40;
        this.fallHurtAmount2 = 2.0f;
        if (EM_Settings.entityFailsafe > 0 && !world.field_72995_K && (entityList = this.field_70170_p.func_72872_a(EntityPhysicsBlock.class, this.field_70121_D.func_72314_b(8.0, 8.0, 8.0))).size() >= 1024) {
            if (EM_Settings.entityFailsafe == 1) {
                EnviroMine.logger.log(Level.WARNING, "Entity fail safe activated! Canceling new entities!");
                EnviroMine.logger.log(Level.WARNING, "Location: " + this.field_70165_t + "," + this.field_70163_u + "," + this.field_70161_v);
                EnviroMine.logger.log(Level.WARNING, "No.: " + entityList.size());
                EM_PhysManager.physSchedule.clear();
                this.func_70106_y();
                return;
            }
            if (EM_Settings.entityFailsafe >= 2) {
                EnviroMine.logger.log(Level.SEVERE, "Entity fail safe activated! Deleting excess entities!");
                EnviroMine.logger.log(Level.SEVERE, "Location: " + this.field_70165_t + "," + this.field_70163_u + "," + this.field_70161_v);
                EnviroMine.logger.log(Level.SEVERE, "No.: " + entityList.size());
                for (EntityPhysicsBlock oldPhysBlock : entityList) {
                    if (oldPhysBlock.field_70128_L) continue;
                    oldPhysBlock.func_70106_y();
                }
                this.func_70106_y();
                EM_PhysManager.physSchedule.clear();
                return;
            }
        }
    }

    public EntityPhysicsBlock(World world, double x, double y, double z, int id, int meta, boolean update) {
        super(world, x, y, z, EntityPhysicsBlock.flowerID(id), meta);
        List entityList;
        this.func_82154_e(true);
        this.fallHurtMax2 = 40;
        this.fallHurtAmount2 = 2.0f;
        if (id == 0) {
            this.func_70106_y();
        }
        if (EM_Settings.entityFailsafe > 0 && !world.field_72995_K && (entityList = this.field_70170_p.func_72872_a(EntityPhysicsBlock.class, this.field_70121_D.func_72314_b(8.0, 8.0, 8.0))).size() >= 512) {
            if (EM_Settings.entityFailsafe == 1) {
                EnviroMine.logger.log(Level.WARNING, "Entity fail safe activated! Canceling new entities!");
                EnviroMine.logger.log(Level.WARNING, "Location: " + this.field_70165_t + "," + this.field_70163_u + "," + this.field_70161_v);
                EnviroMine.logger.log(Level.WARNING, "No.: " + entityList.size());
                EM_PhysManager.physSchedule.clear();
                this.func_70106_y();
                return;
            }
            if (EM_Settings.entityFailsafe >= 2) {
                EnviroMine.logger.log(Level.SEVERE, "Entity fail safe activated! Deleting excess entities!");
                EnviroMine.logger.log(Level.SEVERE, "Location: " + this.field_70165_t + "," + this.field_70163_u + "," + this.field_70161_v);
                EnviroMine.logger.log(Level.SEVERE, "No.: " + entityList.size());
                for (EntityPhysicsBlock oldPhysBlock : entityList) {
                    if (oldPhysBlock.field_70128_L) continue;
                    oldPhysBlock.func_70106_y();
                }
                this.func_70106_y();
                EM_PhysManager.physSchedule.clear();
                return;
            }
        }
        EM_PhysManager.usedSlidePositions.add("" + MathHelper.func_76128_c((double)this.field_70165_t) + "," + MathHelper.func_76128_c((double)this.field_70161_v));
        if (update) {
            EM_PhysManager.schedulePhysUpdate(world, (int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z), false, "Collapse");
        }
    }

    public static int flowerID(int id) {
        if (Block.field_71973_m[id] instanceof BlockFlower) {
            return 0;
        }
        return id;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        if (this.field_70287_a == 0) {
            this.func_70106_y();
        } else {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            ++this.field_70286_c;
            this.field_70181_x -= (double)0.04f;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.98f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)0.98f;
            if (!this.field_70170_p.field_72995_K) {
                int i = MathHelper.func_76128_c((double)this.field_70165_t);
                int j = MathHelper.func_76128_c((double)this.field_70163_u);
                int k = MathHelper.func_76128_c((double)this.field_70161_v);
                if (this.field_70286_c == 1) {
                    if (this.field_70170_p.func_72798_a(i, j, k) != this.field_70287_a && !this.isLandSlide) {
                        this.func_70106_y();
                        return;
                    }
                    this.field_70170_p.func_94571_i(i, j, k);
                }
                try {
                    AxisAlignedBB axisalignedbb = Block.field_71973_m[this.field_70287_a].func_71872_e(this.field_70170_p, i, j - 1, k);
                    if (axisalignedbb != null) {
                        List fallingBlocks = this.field_70170_p.func_72872_a(EntityPhysicsBlock.class, axisalignedbb);
                        fallingBlocks.remove((Object)this);
                        if (fallingBlocks.size() >= 1 && this.isLandSlide) {
                            this.field_70181_x = 0.0;
                            this.func_70107_b((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
                        }
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                if (this.field_70122_E) {
                    this.field_70159_w *= (double)0.7f;
                    this.field_70179_y *= (double)0.7f;
                    this.field_70181_x *= -0.5;
                    if (this.field_70170_p.func_72798_a(i, j, k) != Block.field_72095_ac.field_71990_ca) {
                        this.func_70106_y();
                        if (!this.field_70170_p.func_72931_a(Block.field_82510_ck.field_71990_ca, i, j, k, true, 1, (Entity)null, (ItemStack)null) && !EM_PhysManager.blockNotSolid(this.field_70170_p, i, j, k, false)) {
                            ++j;
                        }
                        if (!this.isBreakingAnvil2 && this.field_70170_p.func_72931_a(Block.field_82510_ck.field_71990_ca, i, j, k, true, 1, (Entity)null, (ItemStack)null) && !BlockSand.func_72191_e_((World)this.field_70170_p, (int)i, (int)(j - 1), (int)k) && this.field_70170_p.func_72832_d(i, j, k, this.field_70287_a, this.field_70285_b, 3)) {
                            TileEntity tileentity;
                            EM_PhysManager.schedulePhysUpdate(this.field_70170_p, i, j, k, true, "Collapse");
                            if (Block.field_71973_m[this.field_70287_a] instanceof BlockSand) {
                                ((BlockSand)Block.field_71973_m[this.field_70287_a]).func_82519_a_(this.field_70170_p, i, j, k, this.field_70285_b);
                            }
                            if (this.field_98051_e != null && Block.field_71973_m[this.field_70287_a] instanceof ITileEntityProvider && (tileentity = this.field_70170_p.func_72796_p(i, j, k)) != null) {
                                NBTTagCompound nbttagcompound = new NBTTagCompound();
                                tileentity.func_70310_b(nbttagcompound);
                                for (NBTBase nbtbase : this.field_98051_e.func_74758_c()) {
                                    if (nbtbase.func_74740_e().equals("x") || nbtbase.func_74740_e().equals("y") || nbtbase.func_74740_e().equals("z")) continue;
                                    nbttagcompound.func_74782_a(nbtbase.func_74740_e(), nbtbase.func_74737_b());
                                }
                                tileentity.func_70307_a(nbttagcompound);
                                tileentity.func_70296_d();
                            }
                        } else if (this.field_70284_d && !this.isBreakingAnvil2) {
                            this.func_70099_a(new ItemStack(this.field_70287_a, 1, Block.field_71973_m[this.field_70287_a].func_71899_b(this.field_70285_b)), 0.0f);
                        }
                    }
                } else if (this.field_70286_c > 100 && !this.field_70170_p.field_72995_K && (j < 1 || j > 256) || this.field_70286_c > 600) {
                    if (this.field_70284_d) {
                        this.func_70099_a(new ItemStack(this.field_70287_a, 1, Block.field_71973_m[this.field_70287_a].func_71899_b(this.field_70285_b)), 0.0f);
                    }
                    this.func_70106_y();
                }
            }
        }
    }

    protected void func_70069_a(float par1) {
        if (this.isAnvil2) {
            int i = MathHelper.func_76123_f((float)(par1 - 1.0f));
            if (this.isLandSlide) {
                i = 2;
            }
            if (i > 0) {
                ArrayList arraylist = new ArrayList(this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D));
                EnviroDamageSource damagesource = this.isLandSlide ? EnviroDamageSource.landslide : (this.field_70287_a == Block.field_82510_ck.field_71990_ca ? DamageSource.field_82728_o : DamageSource.field_82729_p);
                for (Entity entity : arraylist) {
                    entity.func_70097_a((DamageSource)damagesource, (float)Math.min(MathHelper.func_76141_d((float)((float)i * this.fallHurtAmount2)), this.fallHurtMax2));
                }
                if (this.field_70287_a == Block.field_82510_ck.field_71990_ca && (double)this.field_70146_Z.nextFloat() < (double)0.05f + (double)i * 0.05) {
                    int j = this.field_70285_b >> 2;
                    int k = this.field_70285_b & 3;
                    if (++j > 2) {
                        this.isBreakingAnvil2 = true;
                    } else {
                        this.field_70285_b = k | j << 2;
                    }
                }
            }
        }
    }

    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("HurtEntities2", this.isAnvil2);
        par1NBTTagCompound.func_74776_a("FallHurtAmount2", this.fallHurtAmount2);
        par1NBTTagCompound.func_74768_a("FallHurtMax2", this.fallHurtMax2);
        par1NBTTagCompound.func_74757_a("Landslide", this.isLandSlide);
    }

    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("HurtEntities2")) {
            this.isAnvil2 = par1NBTTagCompound.func_74767_n("HurtEntities2");
            this.fallHurtAmount2 = par1NBTTagCompound.func_74760_g("FallHurtAmount2");
            this.fallHurtMax2 = par1NBTTagCompound.func_74762_e("FallHurtMax2");
        } else if (this.field_70287_a == Block.field_82510_ck.field_71990_ca) {
            this.isAnvil2 = true;
        }
        this.isLandSlide = par1NBTTagCompound.func_74767_n("Landslide");
        if (this.field_70287_a == 0) {
            this.func_70106_y();
        }
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        NBTTagCompound tags = new NBTTagCompound();
        this.func_70014_b(tags);
        try {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)tags);
            data.writeShort((int)((short)abyte.length));
            data.write(abyte);
        }
        catch (IOException e) {
            EnviroMine.logger.log(Level.WARNING, "An error occured while writing physics entity properites!");
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteArrayDataInput data) {
        try {
            NBTTagCompound tags = Packet.func_73283_d((DataInput)data);
            this.func_70037_a(tags);
        }
        catch (IOException e) {
            EnviroMine.logger.log(Level.WARNING, "An error occured while reading physics entity properites!");
            e.printStackTrace();
        }
    }
}

