/*
 * Decompiled with CFR 0.152.
 */
package enviromine.core;

import cpw.mods.fml.common.registry.EntityRegistry;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.keybinds.AddRemoveCustom;
import enviromine.trackers.ArmorProperties;
import enviromine.trackers.BlockProperties;
import enviromine.trackers.EntityProperties;
import enviromine.trackers.ItemProperties;
import enviromine.trackers.StabilityType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.Configuration;

public class EM_ConfigHandler {
    public static String configPath = "config/enviromine/";
    static String customPath = configPath + "CustomProperties/";
    static String armorCat = "armor";
    static String blockCat = "blocks";
    static String entityCat = "entity";
    static String itemsCat = "items";
    static String[] APName;
    static String[] BPName;
    static String[] EPName;
    static String[] IPName;
    static String[] SPName;

    public static int initConfig() {
        EM_ConfigHandler.setPropertyNames();
        EM_ConfigHandler.CheckDir(new File(customPath));
        EnviroMine.logger.log(Level.INFO, "Loading configs...");
        File stabConfigFile = new File(configPath + "StabilityTypes.cfg");
        EM_ConfigHandler.loadStabilityTypes(stabConfigFile);
        if (EM_Settings.useDefaultConfig) {
            EM_ConfigHandler.loadDefaultArmorProperties();
        }
        File[] customFiles = EM_ConfigHandler.GetFileList(customPath);
        for (int i = 0; i < customFiles.length; ++i) {
            EM_ConfigHandler.LoadCustomObjects(customFiles[i]);
        }
        File configFile = new File(configPath + "EnviroMine.cfg");
        EM_ConfigHandler.loadGeneralConfig(configFile);
        int Total = EM_Settings.armorProperties.size() + EM_Settings.blockProperties.size() + EM_Settings.livingProperties.size() + EM_Settings.itemProperties.size();
        return Total;
    }

    private static void setPropertyNames() {
        APName = new String[9];
        EM_ConfigHandler.APName[0] = "01.ID";
        EM_ConfigHandler.APName[1] = "02.Temp Add - Night";
        EM_ConfigHandler.APName[2] = "03.Temp Add - Shade";
        EM_ConfigHandler.APName[3] = "04.Temp Add - Sun";
        EM_ConfigHandler.APName[4] = "05.Temp Multiplier - Night";
        EM_ConfigHandler.APName[5] = "06.Temp Multiplier - Shade";
        EM_ConfigHandler.APName[6] = "07.Temp Multiplier - Sun";
        EM_ConfigHandler.APName[7] = "08.Sanity";
        EM_ConfigHandler.APName[8] = "09.Air";
        BPName = new String[12];
        EM_ConfigHandler.BPName[0] = "01.ID";
        EM_ConfigHandler.BPName[1] = "02.MetaID";
        EM_ConfigHandler.BPName[2] = "03.DropID";
        EM_ConfigHandler.BPName[3] = "04.DropMetaID";
        EM_ConfigHandler.BPName[4] = "05.DropNumber";
        EM_ConfigHandler.BPName[5] = "06.Enable Temperature";
        EM_ConfigHandler.BPName[6] = "07.Temperature";
        EM_ConfigHandler.BPName[7] = "08.Air Quality";
        EM_ConfigHandler.BPName[8] = "09.Sanity";
        EM_ConfigHandler.BPName[9] = "10.Stability";
        EM_ConfigHandler.BPName[10] = "11.Slides";
        EM_ConfigHandler.BPName[11] = "12.Slides When Wet";
        EPName = new String[15];
        EM_ConfigHandler.EPName[0] = "01.Entity ID";
        EM_ConfigHandler.EPName[1] = "02.Enable EnviroTracker";
        EM_ConfigHandler.EPName[2] = "03.Enable Dehydration";
        EM_ConfigHandler.EPName[3] = "04.Enable BodyTemp";
        EM_ConfigHandler.EPName[4] = "05.Enable Air Quality";
        EM_ConfigHandler.EPName[5] = "06.Immune To Frost";
        EM_ConfigHandler.EPName[6] = "07.Immune To Heat";
        EM_ConfigHandler.EPName[7] = "08.Ambient Sanity";
        EM_ConfigHandler.EPName[8] = "09.Hit Sanity";
        EM_ConfigHandler.EPName[9] = "10.Ambient Temperature";
        EM_ConfigHandler.EPName[10] = "11.Hit Temperature";
        EM_ConfigHandler.EPName[11] = "12.Ambient Air";
        EM_ConfigHandler.EPName[12] = "13.Hit Air";
        EM_ConfigHandler.EPName[13] = "14.Ambient Hydration";
        EM_ConfigHandler.EPName[14] = "15.Hit Hydration";
        IPName = new String[11];
        EM_ConfigHandler.IPName[0] = "01.ID";
        EM_ConfigHandler.IPName[1] = "02.Damage";
        EM_ConfigHandler.IPName[2] = "03.Enable Ambient Temperature";
        EM_ConfigHandler.IPName[3] = "04.Ambient Temperature";
        EM_ConfigHandler.IPName[4] = "05.Ambient Air Quality";
        EM_ConfigHandler.IPName[5] = "06.Ambient Santity";
        EM_ConfigHandler.IPName[6] = "07.Effect Temperature";
        EM_ConfigHandler.IPName[7] = "08.Effect Air Quality";
        EM_ConfigHandler.IPName[8] = "09.Effect Sanity";
        EM_ConfigHandler.IPName[9] = "10.Effect Hydration";
        EM_ConfigHandler.IPName[10] = "11.Effect Temperature Cap";
        SPName = new String[6];
        EM_ConfigHandler.SPName[0] = "01.Enable Physics";
        EM_ConfigHandler.SPName[1] = "02.Max Support Distance";
        EM_ConfigHandler.SPName[2] = "03.Min Missing Blocks To Fall";
        EM_ConfigHandler.SPName[3] = "04.Max Missing Blocks To Fall";
        EM_ConfigHandler.SPName[4] = "05.Can Hang";
        EM_ConfigHandler.SPName[5] = "06.Holds Others Up";
    }

    public static void loadGeneralConfig(File file) {
        Configuration config;
        try {
            config = new Configuration(file, true);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            EnviroMine.logger.log(Level.WARNING, "FAILED TO LOAD MAIN CONFIG!\nBACKUP SETTINGS ARE NOW IN EFFECT!");
            return;
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
            EnviroMine.logger.log(Level.WARNING, "FAILED TO LOAD MAIN CONFIG!\nBACKUP SETTINGS ARE NOW IN EFFECT!");
            return;
        }
        config.load();
        EM_Settings.shaftGen = config.get("World Generation", "Enable Village MineShafts", true, "Generates mineshafts in villages").getBoolean(true);
        EM_Settings.enablePhysics = config.get("general", "Enable Physics", true, "Turn physics On/Off").getBoolean(true);
        EM_Settings.enableLandslide = config.get("general", "Enable Physics Landslide", true).getBoolean(true);
        EM_Settings.enableSanity = config.get("general", "Allow Sanity", true).getBoolean(true);
        EM_Settings.enableHydrate = config.get("general", "Allow Hydration", true).getBoolean(true);
        EM_Settings.enableBodyTemp = config.get("general", "Allow Body Temperature", true).getBoolean(true);
        EM_Settings.enableAirQ = config.get("general", "Allow Air Quality", true, "True/False to turn Enviromine Trackers for Sanity, Air Quality, Hydration, and Body Temperature.").getBoolean(true);
        EM_Settings.trackNonPlayer = config.get("general", "Track NonPlayer entities", false, "Track enviromine properties on Non-player entites(mobs & animals)").getBoolean(false);
        EM_Settings.updateCheck = config.get("general", "Check For Updates", true).getBoolean(true);
        EM_Settings.physBlockID = config.get("general", "Enviro Physics Entity ID", EntityRegistry.findGlobalUniqueEntityId()).getInt(EntityRegistry.findGlobalUniqueEntityId());
        EM_Settings.villageAssist = config.get("general", "Enable villager assistance", true).getBoolean(true);
        EM_Settings.limitCauldron = config.get("general", "Limit Cauldron Drinking", true).getBoolean(true);
        String PhySetCat = "Physics";
        EM_Settings.spreadIce = config.get(PhySetCat, "Large Ice Cracking", false, "Setting Large Ice Cracking to true can cause Massive Lag").getBoolean(false);
        EM_Settings.updateCap = config.get(PhySetCat, "Consecutive Physics Update Cap", 128, "This will change maximum number of blocks that can be updated with physics at a time. - 1 = Unlimited").getInt(128);
        EM_Settings.physInterval = config.get(PhySetCat, "Physics Interval", 2, "The number of ticks between physics update passes (must be 2 or more)").getInt(2);
        EM_Settings.stoneCracks = config.get(PhySetCat, "Stone Cracks Before Falling", true).getBoolean(true);
        EM_Settings.defaultStability = config.get(PhySetCat, "Default Stability Type (BlockIDs > 175)", "loose").getString();
        EM_Settings.worldDelay = config.get(PhySetCat, "World Start Delay", 1000, "How long after world start until the physics system kicks in (DO NOT SET TOO LOW)").getInt(1000);
        EM_Settings.chunkDelay = config.get(PhySetCat, "Chunk Physics Delay", 500, "How long until individual chunk's physics starts after loading (DO NOT SET TOO LOW)").getInt(500);
        EM_Settings.physInterval = EM_Settings.physInterval >= 2 ? EM_Settings.physInterval : 2;
        EM_Settings.entityFailsafe = config.get(PhySetCat, "Physics entity fail safe level", 1, "0 = No action, 1 = Limit to < 1024 per 8x8 block area, 2 = Delete excessive entities & Dump physics (EMERGENCY ONLY)").getInt(1);
        String GuiSetCat = "GUI Settings";
        EM_Settings.sweatParticals = config.get(GuiSetCat, "Show Sweat Particales", true).getBoolean(true);
        EM_Settings.insaneParticals = config.get(GuiSetCat, "Show Insanity Particles", true, "Show/Hide Particales").getBoolean(true);
        EM_Settings.useFarenheit = config.get(GuiSetCat, "Use Farenheit instead of Celsius", false, "Will display either Farenhit or Celcius on GUI").getBoolean(false);
        EM_Settings.heatBarPos = config.get(GuiSetCat, "Position Heat Bar", "Bottom_Left").getString();
        EM_Settings.waterBarPos = config.get(GuiSetCat, "Position Thirst Bar", "Bottom_Left").getString();
        EM_Settings.sanityBarPos = config.get(GuiSetCat, "Position Sanity Bar", "Bottom_Right").getString();
        EM_Settings.oxygenBarPos = config.get(GuiSetCat, "Position Air Quality Bar", "Bottom_Right", "Change position of Enviro Bars. Options: Bottom_Left, Bottom_Right, Bottom_Center_Left, Bottom_Center_Right, Top_Left, Top_Right, Top_Center, Middle_Left, Middle_Right, Custom_#,# (Custom_X(0-100),Y(0-100))").getString();
        EM_Settings.minimalHud = config.get(GuiSetCat, "Minimalistic Bars", false, "WARNING: This option will hide the ambient air temperature! It will also override icons and text to true.").getBoolean(false);
        EM_Settings.ShowDebug = config.get(GuiSetCat, "Show Gui Debugging Info", false, "Show Hide Gui Text Display and Icons").getBoolean(false);
        EM_Settings.ShowText = config.get(GuiSetCat, "Show Gui Status Text", true).getBoolean(true);
        EM_Settings.ShowGuiIcons = config.get(GuiSetCat, "Show Gui Icons", true).getBoolean(true);
        EM_Settings.allowTinting = config.get(GuiSetCat, "Do Screen Tinting", true, "Disable this if you experience a 'blackout' with low status values").getBoolean(true);
        EM_Settings.dirtBottleID = config.get("item", "Dirty Water Bottle", 5001).getInt(5001);
        EM_Settings.saltBottleID = config.get("item", "Salt Water Bottle", 5002).getInt(5002);
        EM_Settings.coldBottleID = config.get("item", "Cold Water Bottle", 5003).getInt(5003);
        EM_Settings.camelPackID = config.get("item", "Camel Pack", 5004).getInt(5004);
        EM_Settings.hypothermiaPotionID = -1;
        EM_Settings.heatstrokePotionID = -1;
        EM_Settings.frostBitePotionID = -1;
        EM_Settings.dehydratePotionID = -1;
        EM_Settings.insanityPotionID = -1;
        EM_Settings.hypothermiaPotionID = config.get("Potions", "Hypothermia", EM_ConfigHandler.nextAvailPotion(27)).getInt(EM_ConfigHandler.nextAvailPotion(27));
        EM_Settings.heatstrokePotionID = config.get("Potions", "Heat Stroke", EM_ConfigHandler.nextAvailPotion(28)).getInt(EM_ConfigHandler.nextAvailPotion(28));
        EM_Settings.frostBitePotionID = config.get("Potions", "Frostbite", EM_ConfigHandler.nextAvailPotion(29)).getInt(EM_ConfigHandler.nextAvailPotion(29));
        EM_Settings.dehydratePotionID = config.get("Potions", "Dehydration", EM_ConfigHandler.nextAvailPotion(30)).getInt(EM_ConfigHandler.nextAvailPotion(30));
        EM_Settings.insanityPotionID = config.get("Potions", "Insanity", EM_ConfigHandler.nextAvailPotion(31)).getInt(EM_ConfigHandler.nextAvailPotion(31));
        EM_Settings.tempMult = config.get("Speed Multipliers", "BodyTemp", 1.0).getDouble(1.0);
        EM_Settings.hydrationMult = config.get("Speed Multipliers", "Hydration", 1.0).getDouble(1.0);
        EM_Settings.airMult = config.get("Speed Multipliers", "AirQuality", 1.0).getDouble(1.0);
        EM_Settings.sanityMult = config.get("Speed Multipliers", "Sanity", 1.0).getDouble(1.0);
        EM_Settings.tempMult = EM_Settings.tempMult < 0.0 ? 0.0 : EM_Settings.tempMult;
        EM_Settings.hydrationMult = EM_Settings.hydrationMult < 0.0 ? 0.0 : EM_Settings.hydrationMult;
        EM_Settings.airMult = EM_Settings.airMult < 0.0 ? 0.0 : EM_Settings.airMult;
        EM_Settings.sanityMult = EM_Settings.sanityMult < 0.0 ? 0.0 : EM_Settings.sanityMult;
        String ConSetCat = "Config";
        EM_Settings.genArmorConfigs = config.get(ConSetCat, "Generate Armor Configs", true, "Will attempt to find and generate blank configs for any custom armors loaded before EnviroMine.").getBoolean(true);
        EM_Settings.useDefaultConfig = config.get(ConSetCat, "Generate Defaults", true).getBoolean(true);
        config.save();
    }

    static int nextAvailPotion(int startID) {
        for (int i = startID; i > 0; ++i) {
            if (i == EM_Settings.hypothermiaPotionID || i == EM_Settings.heatstrokePotionID || i == EM_Settings.frostBitePotionID || i == EM_Settings.dehydratePotionID || i == EM_Settings.insanityPotionID) continue;
            if (i >= Potion.field_76425_a.length) {
                return i;
            }
            if (Potion.field_76425_a[i] != null) continue;
            return i;
        }
        return startID;
    }

    public static File[] GetFileList(String path) {
        File f = new File(path);
        File[] list = f.listFiles();
        return list;
    }

    private static boolean isCFGFile(String fileName) {
        String patternString = "(.*\\.cfg$)";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(fileName);
        return matcher.matches();
    }

    public static void CheckDir(File Dir) {
        boolean dirFlag = false;
        if (Dir.exists()) {
            return;
        }
        try {
            dirFlag = Dir.mkdirs();
        }
        catch (SecurityException Se) {
            EnviroMine.logger.log(Level.WARNING, "Error while creating config directory:\n" + Se);
        }
        if (!dirFlag) {
            EnviroMine.logger.log(Level.WARNING, "Failed to create config directory!");
        }
    }

    public static void LoadCustomObjects(File customFiles) {
        boolean datFile = EM_ConfigHandler.isCFGFile(customFiles.getName());
        if (datFile) {
            Configuration config;
            try {
                config = new Configuration(customFiles, true);
                EnviroMine.logger.log(Level.INFO, "Loading Config File: " + customFiles.getAbsolutePath());
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                EnviroMine.logger.log(Level.WARNING, "FAILED TO LOAD CUSTOM CONFIG: " + customFiles.getName() + "\nNEW SETTINGS WILL BE IGNORED!");
                return;
            }
            catch (StringIndexOutOfBoundsException e) {
                e.printStackTrace();
                EnviroMine.logger.log(Level.WARNING, "FAILED TO LOAD CUSTOM CONFIG: " + customFiles.getName() + "\nNEW SETTINGS WILL BE IGNORED!");
                return;
            }
            config.load();
            config.addCustomCategoryComment(armorCat, "Custom armor properties");
            config.addCustomCategoryComment(blockCat, "Custom block properties");
            config.addCustomCategoryComment(entityCat, "Custom entity properties");
            config.addCustomCategoryComment(itemsCat, "Custom item properties");
            ArrayList catagory = new ArrayList();
            Set nameList = config.getCategoryNames();
            Iterator nameListData = nameList.iterator();
            while (nameListData.hasNext()) {
                catagory.add(nameListData.next());
            }
            for (int x = 0; x <= catagory.size() - 1; ++x) {
                String CurCat = (String)catagory.get(x);
                if (CurCat.isEmpty() || !CurCat.contains(".")) continue;
                String parent = CurCat.split("\\.")[0];
                if (parent.equals(blockCat)) {
                    EM_ConfigHandler.LoadBlockProperty(config, (String)catagory.get(x));
                    continue;
                }
                if (parent.equals(armorCat)) {
                    EM_ConfigHandler.LoadArmorProperty(config, (String)catagory.get(x));
                    continue;
                }
                if (parent.equals(itemsCat)) {
                    EM_ConfigHandler.LoadItemProperty(config, (String)catagory.get(x));
                    continue;
                }
                if (parent.equals(entityCat)) {
                    EM_ConfigHandler.LoadLivingProperty(config, (String)catagory.get(x));
                    continue;
                }
                EnviroMine.logger.log(Level.WARNING, "Failed to load object " + CurCat);
            }
            config.save();
        }
    }

    private static void LoadItemProperty(Configuration config, String category) {
        config.addCustomCategoryComment(category, "");
        int id = config.get(category, IPName[0], 0).getInt(0);
        int meta = config.get(category, IPName[1], 0).getInt(0);
        boolean enableTemp = config.get(category, IPName[2], false).getBoolean(false);
        float ambTemp = (float)config.get(category, IPName[3], 0.0).getDouble(0.0);
        float ambAir = (float)config.get(category, IPName[4], 0.0).getDouble(0.0);
        float ambSanity = (float)config.get(category, IPName[5], 0.0).getDouble(0.0);
        float effTemp = (float)config.get(category, IPName[6], 0.0).getDouble(0.0);
        float effAir = (float)config.get(category, IPName[7], 0.0).getDouble(0.0);
        float effSanity = (float)config.get(category, IPName[8], 0.0).getDouble(0.0);
        float effHydration = (float)config.get(category, IPName[9], 0.0).getDouble(0.0);
        float effTempCap = (float)config.get(category, IPName[10], 37.0).getDouble(37.0);
        ItemProperties entry = new ItemProperties(id, meta, enableTemp, ambTemp, ambAir, ambSanity, effTemp, effAir, effSanity, effHydration, effTempCap);
        if (meta < 0) {
            EM_Settings.itemProperties.put("" + id, entry);
        } else {
            EM_Settings.itemProperties.put("" + id + "," + meta, entry);
        }
    }

    private static void LoadBlockProperty(Configuration config, String category) {
        config.addCustomCategoryComment(category, "");
        int id = config.get(category, BPName[0], 0).getInt(0);
        int metaData = config.get(category, BPName[1], 0).getInt(0);
        int dropID = config.get(category, BPName[2], 0).getInt(0);
        int dropMeta = config.get(category, BPName[3], 0).getInt(0);
        int dropNum = config.get(category, BPName[4], 0).getInt(0);
        boolean enableTemp = config.get(category, BPName[5], false).getBoolean(false);
        float temperature = (float)config.get(category, BPName[6], 0.0).getDouble(0.0);
        float airQuality = (float)config.get(category, BPName[7], 0.0).getDouble(0.0);
        float sanity = (float)config.get(category, BPName[8], 0.0).getDouble(0.0);
        String stability = config.get(category, BPName[9], "loose").getString();
        boolean slides = config.get(category, BPName[10], false).getBoolean(false);
        boolean wetSlides = config.get(category, BPName[11], false).getBoolean(false);
        int minFall = 99;
        int maxFall = 99;
        int supportDist = 5;
        boolean holdOther = false;
        boolean canHang = true;
        boolean hasPhys = false;
        if (EM_Settings.stabilityTypes.containsKey(stability)) {
            StabilityType stabType = EM_Settings.stabilityTypes.get(stability);
            minFall = stabType.minFall;
            maxFall = stabType.maxFall;
            supportDist = stabType.supportDist;
            hasPhys = stabType.enablePhysics;
            holdOther = stabType.holdOther;
            canHang = stabType.canHang;
        } else {
            EnviroMine.logger.log(Level.WARNING, "Stability type '" + stability + "' not found.");
            minFall = 99;
            maxFall = 99;
            supportDist = 9;
            hasPhys = false;
            holdOther = false;
            canHang = true;
        }
        BlockProperties entry = new BlockProperties(id, metaData, hasPhys, minFall, maxFall, supportDist, dropID, dropMeta, dropNum, enableTemp, temperature, airQuality, sanity, holdOther, slides, canHang, wetSlides);
        if (metaData < 0) {
            EM_Settings.blockProperties.put("" + id, entry);
        } else {
            EM_Settings.blockProperties.put("" + id + "," + metaData, entry);
        }
    }

    private static void LoadArmorProperty(Configuration config, String catagory) {
        config.addCustomCategoryComment(catagory, "");
        int id = config.get(catagory, APName[0], 0).getInt(0);
        float nightTemp = (float)config.get(catagory, APName[1], 0.0).getDouble(0.0);
        float shadeTemp = (float)config.get(catagory, APName[2], 0.0).getDouble(0.0);
        float sunTemp = (float)config.get(catagory, APName[3], 0.0).getDouble(0.0);
        float nightMult = (float)config.get(catagory, APName[4], 1.0).getDouble(1.0);
        float shadeMult = (float)config.get(catagory, APName[5], 1.0).getDouble(1.0);
        float sunMult = (float)config.get(catagory, APName[6], 1.0).getDouble(1.0);
        float sanity = (float)config.get(catagory, APName[7], 0.0).getDouble(0.0);
        float air = (float)config.get(catagory, APName[8], 0.0).getDouble(0.0);
        ArmorProperties entry = new ArmorProperties(id, nightTemp, shadeTemp, sunTemp, nightMult, shadeMult, sunMult, sanity, air);
        EM_Settings.armorProperties.put(id, entry);
    }

    private static void LoadLivingProperty(Configuration config, String catagory) {
        config.addCustomCategoryComment(catagory, "");
        int id = config.get(catagory, EPName[0], 0).getInt(0);
        boolean track = config.get(catagory, EPName[1], true).getBoolean(true);
        boolean dehydration = config.get(catagory, EPName[2], true).getBoolean(true);
        boolean bodyTemp = config.get(catagory, EPName[3], true).getBoolean(true);
        boolean airQ = config.get(catagory, EPName[4], true).getBoolean(true);
        boolean immuneToFrost = config.get(catagory, EPName[5], false).getBoolean(false);
        boolean immuneToHeat = config.get(catagory, EPName[6], false).getBoolean(false);
        float aSanity = (float)config.get(catagory, EPName[7], 0.0).getDouble(0.0);
        float hSanity = (float)config.get(catagory, EPName[8], 0.0).getDouble(0.0);
        float aTemp = (float)config.get(catagory, EPName[9], 37.0, "Overridden by body temp").getDouble(37.0);
        float hTemp = (float)config.get(catagory, EPName[10], 0.0).getDouble(0.0);
        float aAir = (float)config.get(catagory, EPName[11], 0.0).getDouble(0.0);
        float hAir = (float)config.get(catagory, EPName[12], 0.0).getDouble(0.0);
        float aHyd = (float)config.get(catagory, EPName[13], 0.0).getDouble(0.0);
        float hHyd = (float)config.get(catagory, EPName[14], 0.0).getDouble(0.0);
        EntityProperties entry = new EntityProperties(id, track, dehydration, bodyTemp, airQ, immuneToFrost, immuneToHeat, aSanity, hSanity, aTemp, hTemp, aAir, hAir, aHyd, hHyd);
        EM_Settings.livingProperties.put(id, entry);
    }

    public static void loadDefaultArmorProperties() {
        Configuration custom;
        File customFile = new File(customPath + "Defaults.cfg");
        try {
            custom = new Configuration(customFile, true);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            EnviroMine.logger.log(Level.WARNING, "FAILED TO LOAD DEFAULTS!");
            return;
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
            EnviroMine.logger.log(Level.WARNING, "FAILED TO LOAD DEFAULTS!");
            return;
        }
        EnviroMine.logger.log(Level.INFO, "Loading Default Config: " + customFile.getAbsolutePath());
        custom.load();
        custom.addCustomCategoryComment(armorCat, "Custom armor properties");
        custom.addCustomCategoryComment(blockCat, "Custom block properties");
        custom.addCustomCategoryComment(entityCat, "Custom entity properties");
        custom.addCustomCategoryComment(itemsCat, "Custom item properties");
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".helmetLeather", ItemArmor.field_77687_V.field_77779_bT, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".plateLeather", ItemArmor.field_77686_W.field_77779_bT, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".legsLeather", ItemArmor.field_77693_X.field_77779_bT, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".bootsLeather", ItemArmor.field_77692_Y.field_77779_bT, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".helmetIron", ItemArmor.field_77812_ad.field_77779_bT, -0.5, 0.0, 2.5, 1.0, 1.0, 1.1, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".plateIron", ItemArmor.field_77822_ae.field_77779_bT, -0.5, 0.0, 2.5, 1.0, 1.0, 1.1, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".legsIron", ItemArmor.field_77824_af.field_77779_bT, -0.5, 0.0, 2.5, 1.0, 1.0, 1.1, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".bootsIron", ItemArmor.field_77818_ag.field_77779_bT, -0.5, 0.0, 2.5, 1.0, 1.0, 1.1, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".helmetGold", ItemArmor.field_77796_al.field_77779_bT, 0.0, 0.0, 0.0, 1.0, 1.0, 1.2, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".plateGold", ItemArmor.field_77806_am.field_77779_bT, 0.0, 0.0, 0.0, 1.0, 1.0, 1.2, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".legsGold", ItemArmor.field_77808_an.field_77779_bT, 0.0, 0.0, 0.0, 1.0, 1.0, 1.2, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".bootsGold", ItemArmor.field_77802_ao.field_77779_bT, 0.0, 0.0, 0.0, 1.0, 1.0, 1.2, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".helmetDiamond", ItemArmor.field_77820_ah.field_77779_bT, 0.0, 0.0, 0.0, 1.1, 1.0, 0.9, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".plateDiamond", ItemArmor.field_77798_ai.field_77779_bT, 0.0, 0.0, 0.0, 1.1, 1.0, 0.9, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".legsDiamond", ItemArmor.field_77800_aj.field_77779_bT, 0.0, 0.0, 0.0, 1.1, 1.0, 0.9, 0.0, 0.0);
        EM_ConfigHandler.ArmorDefaultSave(custom, armorCat + ".bootsDiamond", ItemArmor.field_77794_ak.field_77779_bT, 0.0, 0.0, 0.0, 1.1, 1.0, 0.9, 0.0, 0.0);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".potions", Item.field_77726_bs.field_77779_bT, -1, false, 0.0, 0.0, 0.0, -0.05, 0.0, 0.0, 25.0, 37.05);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".melon", Item.field_77738_bf.field_77779_bT, -1, false, 0.0, 0.0, 0.0, -0.01, 0.0, 0.0, 5.0, 37.01);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".carrot", Item.field_82797_bK.field_77779_bT, -1, false, 0.0, 0.0, 0.0, -0.01, 0.0, 0.0, 5.0, 37.01);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".goldCarrot", Item.field_82798_bP.field_77779_bT, -1, false, 0.0, 0.0, 0.0, -0.01, 0.0, 0.0, 5.0, 37.01);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".redApple", Item.field_77706_j.field_77779_bT, -1, false, 0.0, 0.0, 0.0, -0.01, 0.0, 0.0, 5.0, 37.01);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".bucketLava", Item.field_77775_ay.field_77779_bT, -1, true, 100.0, -0.5, 0.0, 0.0, 0.0, 0.0, 0.0, 37.0);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".redFlower", Block.field_72107_ae.field_71990_ca, -1, false, 0.0, 0.01, 0.1, 0.0, 0.0, 0.0, 0.0, 37.0);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".yellowFlower", Block.field_72097_ad.field_71990_ca, -1, false, 0.0, 0.01, 0.1, 0.0, 0.0, 0.0, 0.0, 37.0);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".leaves", Block.field_71952_K.field_71990_ca, -1, false, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 37.0);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".snowBlock", Block.field_72039_aU.field_71990_ca, -1, true, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 37.0);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".ice", Block.field_72036_aT.field_71990_ca, -1, true, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 37.0);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".snowLayer", Block.field_72037_aS.field_71990_ca, -1, true, -0.05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 37.0);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".netherrack", Block.field_72012_bb.field_71990_ca, -1, true, 50.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 37.0);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".soulSand", Block.field_72013_bc.field_71990_ca, -1, false, 0.0, 0.0, -0.5, 0.0, 0.0, 0.0, 0.0, 37.0);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".skull", Item.field_82799_bQ.field_77779_bT, -1, false, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0, 37.0);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".web", Block.field_71955_W.field_71990_ca, -1, false, 0.0, 0.0, -0.01, 0.0, 0.0, 0.0, 0.0, 37.0);
        EM_ConfigHandler.ItemDefaultSave(custom, itemsCat + ".11", Item.field_77781_bS.field_77779_bT, -1, false, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 37.0);
        EM_ConfigHandler.EntityDefaultSave(custom, entityCat + ".blaze", 61, false, false, false, false, true, true, -0.01, 0.0, 75.0, 0.1, -0.05, 0.0, -0.01, -0.01);
        EM_ConfigHandler.EntityDefaultSave(custom, entityCat + ".wither", 64, false, false, false, false, true, true, -0.1, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        custom.save();
    }

    private static void EntityDefaultSave(Configuration config, String catName, int id, boolean track, boolean dehydration, boolean bodyTemp, boolean airQ, boolean immuneToFrost, boolean immuneToHeat, double aSanity, double hSanity, double aTemp, double hTemp, double aAir, double hAir, double aHyd, double hHyd) {
        config.get(catName, EPName[0], id).getInt(id);
        config.get(catName, EPName[1], track).getBoolean(track);
        config.get(catName, EPName[2], dehydration).getBoolean(dehydration);
        config.get(catName, EPName[3], bodyTemp).getBoolean(bodyTemp);
        config.get(catName, EPName[4], airQ).getBoolean(airQ);
        config.get(catName, EPName[5], immuneToFrost).getBoolean(immuneToFrost);
        config.get(catName, EPName[6], immuneToHeat).getBoolean(immuneToHeat);
        config.get(catName, EPName[7], aSanity).getDouble(aSanity);
        config.get(catName, EPName[8], hSanity).getDouble(hSanity);
        config.get(catName, EPName[9], aTemp, "Overridden by body temp").getDouble(aTemp);
        config.get(catName, EPName[10], hTemp).getDouble(hTemp);
        config.get(catName, EPName[11], aAir).getDouble(aAir);
        config.get(catName, EPName[12], hAir).getDouble(hAir);
        config.get(catName, EPName[13], aHyd).getDouble(aHyd);
        config.get(catName, EPName[14], hHyd).getDouble(hHyd);
    }

    private static void ArmorDefaultSave(Configuration config, String catName, int id, double nightTemp, double shadeTemp, double sunTemp, double nightMult, double shadeMult, double sunMult, double sanity, double air) {
        config.get(catName, APName[0], id).getInt(id);
        config.get(catName, APName[1], nightTemp).getDouble(nightTemp);
        config.get(catName, APName[2], shadeTemp).getDouble(shadeTemp);
        config.get(catName, APName[3], sunTemp).getDouble(sunTemp);
        config.get(catName, APName[4], nightMult).getDouble(nightMult);
        config.get(catName, APName[5], shadeMult).getDouble(shadeMult);
        config.get(catName, APName[6], sunMult).getDouble(sunMult);
        config.get(catName, APName[7], sanity).getDouble(sanity);
        config.get(catName, APName[8], air).getDouble(air);
    }

    public static void SearchForModdedArmors() {
        EnviroMine.logger.log(Level.INFO, "Searcing for mod armors...");
        int armorCount = 0;
        for (int i = 420; i < Item.field_77698_e.length; ++i) {
            if (!(Item.field_77698_e[i] instanceof ItemArmor)) continue;
            EM_ConfigHandler.DetectedArmorGen((ItemArmor)Item.field_77698_e[i]);
            ++armorCount;
        }
        EnviroMine.logger.log(Level.INFO, "Found " + armorCount + " mod armors");
    }

    private static void DetectedArmorGen(ItemArmor armor) {
        File armorFile = new File(customPath + armor.getClass().getSimpleName() + ".cfg");
        if (!armorFile.exists()) {
            try {
                armorFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        Configuration config = new Configuration(armorFile, true);
        config.load();
        String catName = armorCat + "." + AddRemoveCustom.replaceULN(armor.func_77658_a());
        config.addCustomCategoryComment(catName, "");
        config.get(catName, APName[0], armor.field_77779_bT).getInt(armor.field_77779_bT);
        config.get(catName, APName[1], 0.0).getDouble(0.0);
        config.get(catName, APName[2], 0.0).getDouble(0.0);
        config.get(catName, APName[3], 0.0).getDouble(0.0);
        config.get(catName, APName[4], 1.0).getDouble(1.0);
        config.get(catName, APName[5], 1.0).getDouble(1.0);
        config.get(catName, APName[6], 1.0).getDouble(1.0);
        config.get(catName, APName[7], 0.0).getDouble(0.0);
        config.get(catName, APName[8], 0.0).getDouble(0.0);
        config.save();
    }

    private static void ItemDefaultSave(Configuration config, String catName, int id, int meta, boolean enableAmbTemp, double ambTemp, double ambAir, double ambSanity, double effTemp, double effAir, double effSanity, double effHydration, double tempCap) {
        config.get(catName, IPName[0], id).getInt(id);
        config.get(catName, IPName[1], meta).getInt(meta);
        config.get(catName, IPName[2], enableAmbTemp).getBoolean(enableAmbTemp);
        config.get(catName, IPName[3], ambTemp).getDouble(ambTemp);
        config.get(catName, IPName[4], ambAir).getDouble(ambAir);
        config.get(catName, IPName[5], ambSanity).getDouble(ambSanity);
        config.get(catName, IPName[6], effTemp).getDouble(effTemp);
        config.get(catName, IPName[7], effTemp).getDouble(effTemp);
        config.get(catName, IPName[8], effSanity).getDouble(effSanity);
        config.get(catName, IPName[9], effHydration).getDouble(effHydration);
        config.get(catName, IPName[10], tempCap).getDouble(tempCap);
    }

    public static String SaveMyCustom(String type, String name, Object[] data) {
        Configuration config;
        File configFile = new File(customPath + "MyCustom.cfg");
        if (EM_Settings.genArmorConfigs && type.equalsIgnoreCase("ARMOR")) {
            configFile = new File(customPath + data.getClass().getSimpleName());
        }
        try {
            config = new Configuration(configFile, true);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            EnviroMine.logger.log(Level.WARNING, "FAILED TO SAVE NEW OBJECT TO MYCUSTOM.CFG");
            return "Failed to Open MyCustom.cfg";
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
            EnviroMine.logger.log(Level.WARNING, "FAILED TO SAVE NEW OBJECT TO MYCUSTOM.CFG");
            return "Failed to Open MyCustom.cfg";
        }
        config.load();
        String returnValue = "";
        config.addCustomCategoryComment(armorCat, "Add Custom Armor");
        config.addCustomCategoryComment(blockCat, "Add Custom Blocks");
        config.addCustomCategoryComment(entityCat, "Custom Entities");
        if (type.equalsIgnoreCase("TILE")) {
            String nameULCat = blockCat + "." + name + " " + (Integer)data[1];
            if (config.hasCategory(nameULCat)) {
                config.removeCategory(config.getCategory(nameULCat));
                returnValue = "Removed";
            } else {
                config.addCustomCategoryComment(nameULCat, name);
                config.get(nameULCat, BPName[0], ((Integer)data[0]).intValue()).getInt(0);
                config.get(nameULCat, BPName[1], ((Integer)data[1]).intValue()).getInt(0);
                config.get(nameULCat, BPName[2], ((Integer)data[0]).intValue()).getInt(0);
                config.get(nameULCat, BPName[3], ((Integer)data[1]).intValue()).getInt(0);
                config.get(nameULCat, BPName[4], 0).getInt(0);
                config.get(nameULCat, BPName[5], false).getBoolean(false);
                config.get(nameULCat, BPName[6], 0.0).getDouble(0.0);
                config.get(nameULCat, BPName[7], 0.0).getDouble(0.0);
                config.get(nameULCat, BPName[8], 0.0).getDouble(0.0);
                config.get(nameULCat, BPName[9], "loose").getString();
                config.get(nameULCat, BPName[10], false).getBoolean(false);
                config.get(nameULCat, BPName[11], false).getBoolean(false);
                returnValue = "Saved";
            }
        } else if (type.equalsIgnoreCase("ENTITY")) {
            String nameEntityCat = entityCat + "." + name;
            if (config.hasCategory(nameEntityCat)) {
                config.removeCategory(config.getCategory(nameEntityCat));
                returnValue = "Removed";
            } else {
                config.addCustomCategoryComment(nameEntityCat, "");
                config.get(nameEntityCat, EPName[0], ((Integer)data[0]).intValue()).getInt(0);
                config.get(nameEntityCat, EPName[1], true).getBoolean(true);
                config.get(nameEntityCat, EPName[2], true).getBoolean(true);
                config.get(nameEntityCat, EPName[3], true).getBoolean(true);
                config.get(nameEntityCat, EPName[4], true).getBoolean(true);
                config.get(nameEntityCat, EPName[5], false).getBoolean(false);
                config.get(nameEntityCat, EPName[6], false).getBoolean(false);
                config.get(nameEntityCat, EPName[7], 0.0).getDouble(0.0);
                config.get(nameEntityCat, EPName[8], 0.0).getDouble(0.0);
                config.get(nameEntityCat, EPName[9], 37.0, "Overridden by body temp").getDouble(37.0);
                config.get(nameEntityCat, EPName[10], 0.0).getDouble(0.0);
                config.get(nameEntityCat, EPName[11], 0.0).getDouble(0.0);
                config.get(nameEntityCat, EPName[12], 0.0).getDouble(0.0);
                config.get(nameEntityCat, EPName[13], 0.0).getDouble(0.0);
                config.get(nameEntityCat, EPName[14], 0.0).getDouble(0.0);
                returnValue = "Saved";
            }
        } else if (type.equalsIgnoreCase("ITEM")) {
            String nameItemCat = itemsCat + "." + name;
            if (config.hasCategory(nameItemCat)) {
                config.removeCategory(config.getCategory(nameItemCat));
                returnValue = "Removed";
            } else {
                config.addCustomCategoryComment(nameItemCat, name);
                config.get(nameItemCat, IPName[0], ((Integer)data[0]).intValue()).getInt(0);
                config.get(nameItemCat, IPName[1], ((Integer)data[1]).intValue()).getInt(0);
                config.get(nameItemCat, IPName[2], false).getBoolean(false);
                config.get(nameItemCat, IPName[3], 0.0).getDouble(0.0);
                config.get(nameItemCat, IPName[4], 0.0).getDouble(0.0);
                config.get(nameItemCat, IPName[5], 0.0).getDouble(0.0);
                config.get(nameItemCat, IPName[6], 0.0).getDouble(0.0);
                config.get(nameItemCat, IPName[7], 0.0).getDouble(0.0);
                config.get(nameItemCat, IPName[8], 0.0).getDouble(0.0);
                config.get(nameItemCat, IPName[9], 0.0).getDouble(0.0);
                config.get(nameItemCat, IPName[10], 37.0).getDouble(37.0);
                returnValue = "Saved";
            }
        } else if (type.equalsIgnoreCase("ARMOR")) {
            String nameArmorCat = armorCat + "." + name;
            if (config.hasCategory(nameArmorCat)) {
                config.removeCategory(config.getCategory(nameArmorCat));
                returnValue = "Removed";
            } else {
                config.addCustomCategoryComment(nameArmorCat, name);
                config.get(nameArmorCat, APName[0], ((Integer)data[0]).intValue()).getInt(0);
                config.get(nameArmorCat, APName[1], 0.0).getDouble(0.0);
                config.get(nameArmorCat, APName[2], 0.0).getDouble(0.0);
                config.get(nameArmorCat, APName[3], 0.0).getDouble(0.0);
                config.get(nameArmorCat, APName[4], 1.0).getDouble(1.0);
                config.get(nameArmorCat, APName[5], 1.0).getDouble(1.0);
                config.get(nameArmorCat, APName[6], 1.0).getDouble(1.0);
                config.get(nameArmorCat, APName[7], 0.0).getDouble(0.0);
                config.get(nameArmorCat, APName[8], 0.0).getDouble(0.0);
                returnValue = "Saved";
            }
        }
        config.save();
        return returnValue;
    }

    public static void loadStabilityTypes(File file) {
        Configuration config;
        try {
            config = new Configuration(file, true);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            EnviroMine.logger.log(Level.WARNING, "FAILED TO LOAD MAIN CONFIG!\nBACKUP SETTINGS ARE NOW IN EFFECT!");
            return;
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
            EnviroMine.logger.log(Level.WARNING, "FAILED TO LOAD MAIN CONFIG!\nBACKUP SETTINGS ARE NOW IN EFFECT!");
            return;
        }
        config.load();
        EM_ConfigHandler.loadDefaultStabilityTypes(config);
        ArrayList catagory = new ArrayList();
        Set nameList = config.getCategoryNames();
        Iterator nameListData = nameList.iterator();
        while (nameListData.hasNext()) {
            catagory.add(nameListData.next());
        }
        for (int x = 0; x <= catagory.size() - 1; ++x) {
            String currentCat = (String)catagory.get(x);
            boolean physEnable = config.get(currentCat, SPName[0], true).getBoolean(true);
            int supportDist = config.get(currentCat, SPName[1], 0).getInt(0);
            int minFall = config.get(currentCat, SPName[2], -1).getInt(-1);
            int maxFall = config.get(currentCat, SPName[3], -1).getInt(-1);
            boolean canHang = config.get(currentCat, SPName[4], false).getBoolean(false);
            boolean holdOther = config.get(currentCat, SPName[5], false).getBoolean(false);
            EM_Settings.stabilityTypes.put(currentCat, new StabilityType(physEnable, supportDist, minFall, maxFall, canHang, holdOther));
        }
        config.save();
    }

    public static void loadDefaultStabilityTypes(Configuration config) {
        boolean physEnable = config.get("sand-like", SPName[0], true).getBoolean(true);
        int supportDist = config.get("sand-like", SPName[1], 0).getInt(0);
        int minFall = config.get("sand-like", SPName[2], -1).getInt(-1);
        int maxFall = config.get("sand-like", SPName[3], -1).getInt(-1);
        boolean canHang = config.get("sand-like", SPName[4], false).getBoolean(false);
        boolean holdOther = config.get("sand-like", SPName[5], false).getBoolean(false);
        EM_Settings.stabilityTypes.put("sand-like", new StabilityType(physEnable, supportDist, minFall, maxFall, canHang, holdOther));
        physEnable = config.get("loose", SPName[0], true).getBoolean(true);
        supportDist = config.get("loose", SPName[1], 1).getInt(1);
        minFall = config.get("loose", SPName[2], 10).getInt(10);
        maxFall = config.get("loose", SPName[3], 15).getInt(15);
        canHang = config.get("loose", SPName[4], false).getBoolean(false);
        holdOther = config.get("loose", SPName[5], false).getBoolean(false);
        EM_Settings.stabilityTypes.put("loose", new StabilityType(physEnable, supportDist, minFall, maxFall, canHang, holdOther));
        physEnable = config.get("average", SPName[0], true).getBoolean(true);
        supportDist = config.get("average", SPName[1], 2).getInt(2);
        minFall = config.get("average", SPName[2], 15).getInt(15);
        maxFall = config.get("average", SPName[3], 22).getInt(22);
        canHang = config.get("average", SPName[4], false).getBoolean(false);
        holdOther = config.get("average", SPName[5], false).getBoolean(false);
        EM_Settings.stabilityTypes.put("average", new StabilityType(physEnable, supportDist, minFall, maxFall, canHang, holdOther));
        physEnable = config.get("strong", SPName[0], true).getBoolean(true);
        supportDist = config.get("strong", SPName[1], 3).getInt(3);
        minFall = config.get("strong", SPName[2], 22).getInt(22);
        maxFall = config.get("strong", SPName[3], 25).getInt(25);
        canHang = config.get("strong", SPName[4], true).getBoolean(true);
        holdOther = config.get("strong", SPName[5], false).getBoolean(false);
        EM_Settings.stabilityTypes.put("strong", new StabilityType(physEnable, supportDist, minFall, maxFall, canHang, holdOther));
    }
}

