/*
 * Decompiled with CFR 0.152.
 */
package enviromine.core;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enviromine.EM_VillageMineshaft;
import enviromine.EntityPhysicsBlock;
import enviromine.EnviroPotion;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.proxies.EM_CommonProxy;
import enviromine.gui.UpdateNotification;
import enviromine.handlers.EnviroPacketHandler;
import enviromine.handlers.EnviroShaftCreationHandler;
import enviromine.handlers.keybinds.AddRemoveCustom;
import enviromine.handlers.keybinds.ReloadCustomObjects;
import enviromine.items.EnviroArmor;
import enviromine.items.EnviroItemBadWaterBottle;
import enviromine.items.EnviroItemColdWaterBottle;
import enviromine.items.EnviroItemSaltWaterBottle;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.EnumHelper;

@Mod(modid="EnviroMine", name="EnviroMine", version="1.1.89")
@NetworkMod(clientSideRequired=true, serverSideRequired=true, channels={"EM_CH"}, packetHandler=EnviroPacketHandler.class)
public class EnviroMine {
    public static Logger logger;
    public static Item badWaterBottle;
    public static Item saltWaterBottle;
    public static Item coldWaterBottle;
    public static EnumArmorMaterial camelPackMaterial;
    public static ItemArmor camelPack;
    @Mod.Instance(value="EnviroMine")
    public static EnviroMine instance;
    @SidedProxy(clientSide="enviromine.core.proxies.EM_ClientProxy", serverSide="enviromine.core.proxies.EM_CommonProxy")
    public static EM_CommonProxy proxy;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        logger.setParent(FMLLog.getLogger());
        proxy.preInit(event);
        EM_ConfigHandler.initConfig();
        badWaterBottle = new EnviroItemBadWaterBottle(EM_Settings.dirtBottleID).func_77625_d(1).func_77655_b("dirtyWaterBottle").func_77637_a(CreativeTabs.field_78038_k);
        saltWaterBottle = new EnviroItemSaltWaterBottle(EM_Settings.saltBottleID).func_77625_d(1).func_77655_b("saltWaterBottle").func_77637_a(CreativeTabs.field_78038_k);
        coldWaterBottle = new EnviroItemColdWaterBottle(EM_Settings.coldBottleID).func_77625_d(1).func_77655_b("coldWaterBottle").func_77637_a(CreativeTabs.field_78038_k);
        camelPackMaterial = EnumHelper.addArmorMaterial((String)"camelPack", (int)100, (int[])new int[]{0, 0, 0, 0}, (int)0);
        camelPack = (ItemArmor)new EnviroArmor(EM_Settings.camelPackID, camelPackMaterial, 4, 1).func_111206_d("camel_pack").func_77655_b("camelPack").func_77637_a(CreativeTabs.field_78040_i);
        if (EM_Settings.shaftGen) {
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new EnviroShaftCreationHandler());
            MapGenStructureIO.func_143031_a(EM_VillageMineshaft.class, (String)"ViMS");
        }
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        proxy.init(event);
        EntityRegistry.registerModEntity(EntityPhysicsBlock.class, (String)"EnviroPhysicsEntity", (int)EM_Settings.physBlockID, (Object)instance, (int)64, (int)1, (boolean)true);
        LanguageRegistry.addName((Object)badWaterBottle, (String)"Dirty Water Bottle");
        LanguageRegistry.addName((Object)saltWaterBottle, (String)"Salt Water Bottle");
        LanguageRegistry.addName((Object)coldWaterBottle, (String)"Cold Water Bottle");
        LanguageRegistry.addName((Object)camelPack, (String)"Camel Pack");
        EnviroMine.extendPotionList();
        EnviroPotion.frostbite = (EnviroPotion)new EnviroPotion(EM_Settings.frostBitePotionID, true, 8171462).func_76390_b("potion.frostbite").func_76399_b(0, 0);
        EnviroPotion.dehydration = (EnviroPotion)new EnviroPotion(EM_Settings.dehydratePotionID, true, 3035801).func_76390_b("potion.dehydration").func_76399_b(1, 0);
        EnviroPotion.insanity = (EnviroPotion)new EnviroPotion(EM_Settings.insanityPotionID, true, 5578058).func_76390_b("potion.insanity").func_76399_b(2, 0);
        EnviroPotion.heatstroke = (EnviroPotion)new EnviroPotion(EM_Settings.heatstrokePotionID, true, EnviroMine.getColorFromRGBA(255, 0, 0, 255)).func_76390_b("potion.heatstroke").func_76399_b(3, 0);
        EnviroPotion.hypothermia = (EnviroPotion)new EnviroPotion(EM_Settings.hypothermiaPotionID, true, 8171462).func_76390_b("potion.hypothermia").func_76399_b(4, 0);
        LanguageRegistry.instance().addStringLocalization("potion.hypothermia", "Hypothermia");
        LanguageRegistry.instance().addStringLocalization("potion.heatstroke", "Heat Stroke");
        LanguageRegistry.instance().addStringLocalization("potion.frostbite", "Frostbite");
        LanguageRegistry.instance().addStringLocalization("potion.dehydration", "Dehydration");
        LanguageRegistry.instance().addStringLocalization("potion.insanity", "Insanity");
        GameRegistry.addSmelting((int)EnviroMine.badWaterBottle.field_77779_bT, (ItemStack)new ItemStack(ItemPotion.field_77726_bs.field_77779_bT, 1, 0), (float)0.0f);
        GameRegistry.addSmelting((int)EnviroMine.saltWaterBottle.field_77779_bT, (ItemStack)new ItemStack(ItemPotion.field_77726_bs.field_77779_bT, 1, 0), (float)0.0f);
        GameRegistry.addSmelting((int)EnviroMine.coldWaterBottle.field_77779_bT, (ItemStack)new ItemStack(ItemPotion.field_77726_bs.field_77779_bT, 1, 0), (float)0.0f);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(coldWaterBottle, 1, 0), (Object[])new Object[]{new ItemStack((Item)Item.field_77726_bs, 1, 0), new ItemStack(Item.field_77768_aD, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(badWaterBottle, 1, 0), (Object[])new Object[]{new ItemStack((Item)Item.field_77726_bs, 1, 0), new ItemStack(Block.field_71979_v, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(saltWaterBottle, 1, 0), (Object[])new Object[]{new ItemStack((Item)Item.field_77726_bs, 1, 0), new ItemStack(Block.field_71939_E, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)camelPack, 1, camelPack.func_77612_l()), (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), new ItemStack(Item.field_77770_aF), Character.valueOf('y'), new ItemStack(Item.field_77729_bt)});
        GameRegistry.registerPlayerTracker((IPlayerTracker)new UpdateNotification());
        proxy.registerTickHandlers();
        proxy.registerEventHandlers();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        if (EM_Settings.genArmorConfigs) {
            EM_ConfigHandler.SearchForModdedArmors();
        }
        logger.log(Level.INFO, "Loaded " + EM_Settings.armorProperties.size() + " armor properties");
        logger.log(Level.INFO, "Loaded " + EM_Settings.blockProperties.size() + " block properties");
        logger.log(Level.INFO, "Loaded " + EM_Settings.livingProperties.size() + " entity properties");
        logger.log(Level.INFO, "Loaded " + EM_Settings.itemProperties.size() + " item properties");
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerKeyBindings(FMLInitializationEvent event) {
        KeyBinding[] key = new KeyBinding[]{new KeyBinding("EnviroMine Add/Remove Custom Object", 36)};
        boolean[] repeat = new boolean[]{false};
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new AddRemoveCustom(key, repeat));
        KeyBinding[] key1 = new KeyBinding[]{new KeyBinding("EnviroMine Reload All Custom Object", 37)};
        boolean[] repeat1 = new boolean[]{false};
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new ReloadCustomObjects(key1, repeat1));
    }

    public static int getColorFromRGBA_F(float par1, float par2, float par3, float par4) {
        int R = (int)(par1 * 255.0f);
        int G = (int)(par2 * 255.0f);
        int B = (int)(par3 * 255.0f);
        int A = (int)(par4 * 255.0f);
        return EnviroMine.getColorFromRGBA(R, G, B, A);
    }

    public static int getColorFromRGBA(int R, int G, int B, int A) {
        if (R > 255) {
            R = 255;
        }
        if (G > 255) {
            G = 255;
        }
        if (B > 255) {
            B = 255;
        }
        if (A > 255) {
            A = 255;
        }
        if (R < 0) {
            R = 0;
        }
        if (G < 0) {
            G = 0;
        }
        if (B < 0) {
            B = 0;
        }
        if (A < 0) {
            A = 0;
        }
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            return A << 24 | R << 16 | G << 8 | B;
        }
        return B << 24 | G << 16 | R << 8 | A;
    }

    public static void extendPotionList() {
        int maxID = 32;
        if (EM_Settings.heatstrokePotionID >= maxID) {
            maxID = EM_Settings.heatstrokePotionID + 1;
        }
        if (EM_Settings.hypothermiaPotionID >= maxID) {
            maxID = EM_Settings.hypothermiaPotionID + 1;
        }
        if (EM_Settings.frostBitePotionID >= maxID) {
            maxID = EM_Settings.frostBitePotionID + 1;
        }
        if (EM_Settings.dehydratePotionID >= maxID) {
            maxID = EM_Settings.dehydratePotionID + 1;
        }
        if (EM_Settings.insanityPotionID >= maxID) {
            maxID = EM_Settings.insanityPotionID + 1;
        }
        if (Potion.field_76425_a.length >= maxID) {
            return;
        }
        Potion[] potionTypes = null;
        for (Field f : Potion.class.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                if (!f.getName().equals("potionTypes") && !f.getName().equals("field_76425_a")) continue;
                Field modfield = Field.class.getDeclaredField("modifiers");
                modfield.setAccessible(true);
                modfield.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                potionTypes = (Potion[])f.get(null);
                Potion[] newPotionTypes = new Potion[maxID];
                System.arraycopy(potionTypes, 0, newPotionTypes, 0, potionTypes.length);
                f.set(null, newPotionTypes);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to extend potion list for EnviroMine");
                e.printStackTrace();
            }
        }
    }
}

