/*
 * Decompiled with CFR 0.152.
 */
package enviromine.gui;

import cpw.mods.fml.common.IPlayerTracker;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;

public class UpdateNotification
implements IPlayerTracker {
    boolean hasChecked = false;

    public void onPlayerLogin(EntityPlayer player) {
        block12: {
            if (!EnviroMine.proxy.isClient() || this.hasChecked) {
                return;
            }
            this.hasChecked = true;
            try {
                String[] data = this.getNotification("http://bit.ly/1r4JJt3", true);
                if (!EM_Settings.updateCheck) {
                    return;
                }
                String version = data[0].trim();
                String http = data[1].trim();
                int verStat = this.compareVersions("1.1.89", version);
                if (verStat == -1) {
                    player.func_71035_c(EnumChatFormatting.RED + "Update " + version + " of EnviroMine is available");
                    player.func_71035_c(EnumChatFormatting.RESET + "Download & Changelog:");
                    player.func_71035_c("" + EnumChatFormatting.BLUE + EnumChatFormatting.UNDERLINE + "https://github.com/Funwayguy/EnviroMine/wiki/Downloads");
                    for (int i = 2; i < data.length; ++i) {
                        if (i > 5) {
                            player.func_71035_c("" + (data.length - 6) + " more...");
                            break block12;
                        }
                        player.func_71035_c(EnumChatFormatting.RESET + "" + data[i].trim());
                    }
                    break block12;
                }
                if (verStat == 0) {
                    player.func_71035_c(EnumChatFormatting.YELLOW + "EnviroMine " + "1.1.89" + " is up to date");
                } else if (verStat == 1) {
                    player.func_71035_c(EnumChatFormatting.RED + "EnviroMine " + "1.1.89" + " is a debug version");
                } else if (verStat == -2) {
                    player.func_71035_c(EnumChatFormatting.RED + "An error occured while parsing EnviroMine's version file!");
                }
            }
            catch (IOException e) {
                if (!EM_Settings.updateCheck) break block12;
                EnviroMine.logger.log(Level.WARNING, "Failed to get versions file!");
            }
        }
    }

    public void onPlayerLogout(EntityPlayer player) {
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
    }

    public void onPlayerRespawn(EntityPlayer player) {
    }

    private String[] getNotification(String link, boolean doRedirect) throws IOException {
        int chars_read;
        URL url = new URL(link);
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setDoOutput(false);
        con.setReadTimeout(20000);
        con.setRequestProperty("Connection", "keep-alive");
        con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:16.0) Gecko/20100101 Firefox/16.0");
        con.setRequestMethod("GET");
        con.setConnectTimeout(5000);
        BufferedInputStream in = new BufferedInputStream(con.getInputStream());
        int responseCode = con.getResponseCode();
        if (responseCode != 200 && responseCode != 301) {
            EnviroMine.logger.log(Level.WARNING, "Update request returned response code: " + responseCode + " " + con.getResponseMessage());
        } else if (responseCode == 301) {
            if (doRedirect) {
                return this.getNotification(con.getHeaderField("location"), false);
            }
            throw new IOException();
        }
        StringBuffer buffer = new StringBuffer();
        while ((chars_read = in.read()) != -1) {
            char g = (char)chars_read;
            buffer.append(g);
        }
        String page = buffer.toString();
        String[] pageSplit = page.split("\\n");
        return pageSplit;
    }

    public int compareVersions(String oldVer, String newVer) {
        int[] newNum;
        int[] oldNum;
        int result = 0;
        try {
            String[] oldNumStr = oldVer.split("\\.");
            String[] newNumStr = newVer.split("\\.");
            oldNum = new int[]{Integer.valueOf(oldNumStr[0]), Integer.valueOf(oldNumStr[1]), Integer.valueOf(oldNumStr[2])};
            newNum = new int[]{Integer.valueOf(newNumStr[0]), Integer.valueOf(newNumStr[1]), Integer.valueOf(newNumStr[2])};
        }
        catch (IndexOutOfBoundsException e) {
            EnviroMine.logger.log(Level.WARNING, "An IndexOutOfBoundsException occured while checking version!", e);
            return -2;
        }
        catch (NumberFormatException e) {
            EnviroMine.logger.log(Level.WARNING, "A NumberFormatException occured while checking version!\n", e);
            return -2;
        }
        for (int i = 0; i < 3; ++i) {
            if (oldNum[i] < newNum[i]) {
                return -1;
            }
            if (oldNum[i] <= newNum[i]) continue;
            return 1;
        }
        return result;
    }
}

