/*
 * Decompiled with CFR 0.152.
 */
package enviromine.handlers;

import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.EntityRegistry;
import enviromine.EnviroPotion;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.gui.EM_GuiEnviroMeters;
import enviromine.handlers.EM_PhysManager;
import enviromine.trackers.ArmorProperties;
import enviromine.trackers.BlockProperties;
import enviromine.trackers.EntityProperties;
import enviromine.trackers.EnviroDataTracker;
import enviromine.trackers.ItemProperties;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.FoodStats;
import net.minecraft.util.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.EnumPlantType;

public class EM_StatusManager {
    public static HashMap<String, EnviroDataTracker> trackerList = new HashMap();
    private static Stopwatch timer = new Stopwatch();

    public static void addToManager(EnviroDataTracker tracker) {
        if (tracker.trackedEntity instanceof EntityPlayer) {
            trackerList.put("" + tracker.trackedEntity.func_70023_ak(), tracker);
        } else {
            trackerList.put("" + tracker.trackedEntity.field_70157_k, tracker);
        }
    }

    public static void updateTracker(EnviroDataTracker tracker) {
        if (tracker == null) {
            return;
        }
        if (EnviroMine.proxy.isClient() && Minecraft.func_71410_x().func_71387_A() && Minecraft.func_71410_x().func_71401_C().func_71343_a().func_71752_f() && !EnviroMine.proxy.isOpenToLAN()) {
            return;
        }
        ++tracker.updateTimer;
        if (tracker.updateTimer >= 30) {
            tracker.updateData();
            if (!EnviroMine.proxy.isClient() || EnviroMine.proxy.isOpenToLAN()) {
                EM_StatusManager.syncMultiplayerTracker(tracker);
            }
        }
    }

    public static void syncMultiplayerTracker(EnviroDataTracker tracker) {
        tracker.fixFloatinfPointErrors();
        String dataString = "";
        if (!(tracker.trackedEntity instanceof EntityPlayer)) {
            return;
        }
        dataString = "ID:0," + ((EntityPlayer)tracker.trackedEntity).field_71092_bJ + "," + tracker.airQuality + "," + tracker.bodyTemp + "," + tracker.hydration + "," + tracker.sanity + "," + tracker.airTemp;
        if (dataString.length() >= 2048) {
            EnviroMine.logger.log(Level.WARNING, "Tracker Sync data too long! Problems may occur client side while parsing!");
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(bos);
            outputStream.writeBytes(dataString);
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "EM_CH";
            packet.field_73629_c = bos.toByteArray();
            packet.field_73628_b = bos.size();
            PacketDispatcher.sendPacketToAllAround((double)tracker.trackedEntity.field_70165_t, (double)tracker.trackedEntity.field_70163_u, (double)tracker.trackedEntity.field_70161_v, (double)128.0, (int)tracker.trackedEntity.field_71093_bK, (Packet)packet);
            outputStream.close();
            bos.close();
        }
        catch (IOException e) {
            EnviroMine.logger.log(Level.SEVERE, "EnviroMine failed to build tracker sync packet!", e);
        }
    }

    public static EnviroDataTracker lookupTracker(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            if (trackerList.containsKey("" + entity.func_70023_ak())) {
                return trackerList.get("" + entity.func_70023_ak());
            }
            return null;
        }
        if (trackerList.containsKey("" + entity.field_70157_k)) {
            return trackerList.get("" + entity.field_70157_k);
        }
        return null;
    }

    public static EnviroDataTracker lookupTrackerFromUsername(String username) {
        return trackerList.get(username);
    }

    public static float[] getSurroundingData(EntityLivingBase entityLiving, int range) {
        short enLV;
        int index;
        float bTemp;
        float sanityRate;
        if (EnviroMine.proxy.isClient() && entityLiving.func_70023_ak().equals(Minecraft.func_71410_x().field_71439_g.func_70023_ak()) && !timer.isRunning()) {
            timer.start();
        }
        float[] data = new float[8];
        float sanityStartRate = sanityRate = -0.005f;
        float quality = 0.0f;
        double leaves = 0.0;
        float sBoost = 0.0f;
        float dropSpeed = 0.001f;
        float riseSpeed = 0.001f;
        float temp = -999.0f;
        float cooling = 0.0f;
        float dehydrateBonus = 0.0f;
        int animalHostility = 0;
        boolean nearLava = false;
        float dist = 0.0f;
        float solidBlocks = 0.0f;
        int i = MathHelper.func_76128_c((double)entityLiving.field_70165_t);
        int j = MathHelper.func_76128_c((double)entityLiving.field_70163_u);
        int k = MathHelper.func_76128_c((double)entityLiving.field_70161_v);
        if (entityLiving.field_70170_p == null) {
            return data;
        }
        Chunk chunk = entityLiving.field_70170_p.func_72938_d(i, k);
        if (chunk == null) {
            return data;
        }
        BiomeGenBase biome = chunk.func_76591_a(i & 0xF, k & 0xF, entityLiving.field_70170_p.func_72959_q());
        ArrayList<BiomeDictionary.Type> bTypeList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)));
        if (biome == null) {
            return data;
        }
        float surBiomeTemps = 0.0f;
        int biomeTempChecks = 0;
        boolean isDay = entityLiving.field_70170_p.func_72935_r();
        if (entityLiving.field_70170_p.field_73011_w.field_76576_e) {
            isDay = false;
        }
        int lightLev = 0;
        int blockLightLev = 0;
        if (j > 0) {
            if (j >= 256) {
                lightLev = 15;
                blockLightLev = 15;
            } else {
                lightLev = chunk.func_76614_a(EnumSkyBlock.Sky, i & 0xF, j, k & 0xF);
                blockLightLev = chunk.func_76614_a(EnumSkyBlock.Block, i & 0xF, j, k & 0xF);
            }
        }
        if (!isDay && blockLightLev <= 1 && entityLiving.func_70660_b(Potion.field_76439_r) != null) {
            sanityStartRate = -0.01f;
            sanityRate = -0.01f;
        }
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    Chunk testChunk;
                    BiomeGenBase testBiome;
                    if (y == 0 && (testBiome = (testChunk = entityLiving.field_70170_p.func_72938_d(i + x, k + z)).func_76591_a(i + x & 0xF, k + z & 0xF, entityLiving.field_70170_p.func_72959_q())) != null) {
                        surBiomeTemps += testBiome.field_76750_F;
                        ++biomeTempChecks;
                    }
                    if (!EM_PhysManager.blockNotSolid(entityLiving.field_70170_p, x + i, y + j, z + k, false)) {
                        solidBlocks += 1.0f;
                    }
                    dist = (float)entityLiving.func_70011_f((double)(i + x), (double)(j + y), (double)(k + z));
                    int id = 0;
                    int meta = 0;
                    boolean isCustom = false;
                    BlockProperties blockProps = null;
                    id = entityLiving.field_70170_p.func_72798_a(i + x, j + y, k + z);
                    if (id != 0) {
                        meta = entityLiving.field_70170_p.func_72805_g(i + x, j + y, k + z);
                    }
                    if (EM_Settings.blockProperties.containsKey("" + id + "," + meta) || EM_Settings.blockProperties.containsKey("" + id)) {
                        blockProps = EM_Settings.blockProperties.containsKey("" + id + "," + meta) ? EM_Settings.blockProperties.get("" + id + "," + meta) : EM_Settings.blockProperties.get("" + id);
                        if (blockProps.meta == meta || blockProps.meta == -1) {
                            isCustom = true;
                        }
                    }
                    if (isCustom && blockProps != null) {
                        if (blockProps.air > 0.0f) {
                            leaves += (double)(blockProps.air / 0.1f);
                        } else if (quality >= blockProps.air && blockProps.air < 0.0f && quality <= 0.0f) {
                            quality = blockProps.air;
                        }
                        if (blockProps.enableTemp) {
                            if (temp <= EM_StatusManager.getTempFalloff(blockProps.temp, dist, range) && blockProps.temp > 0.0f) {
                                temp = EM_StatusManager.getTempFalloff(blockProps.temp, dist, range);
                            } else if (blockProps.temp < 0.0f) {
                                cooling += EM_StatusManager.getTempFalloff(-blockProps.temp, dist, range);
                            }
                        }
                        if (sanityRate >= blockProps.sanity && blockProps.sanity < 0.0f && sanityRate <= 0.0f) {
                            sanityRate = blockProps.sanity;
                        } else if (sanityRate <= blockProps.sanity && blockProps.sanity > 0.0f) {
                            if (Block.field_71973_m[blockProps.id] instanceof BlockFlower) {
                                if (isDay && sBoost < blockProps.sanity) {
                                    sBoost = blockProps.sanity;
                                }
                            } else if (sBoost < blockProps.sanity) {
                                sBoost = blockProps.sanity;
                            }
                        }
                    } else if (id == Block.field_71944_C.field_71990_ca || id == Block.field_71938_D.field_71990_ca) {
                        if (quality > -1.0f) {
                            quality = -1.0f;
                        }
                        if (temp < EM_StatusManager.getTempFalloff(200.0f, dist, range)) {
                            temp = EM_StatusManager.getTempFalloff(200.0f, dist, range);
                        }
                        nearLava = true;
                    } else if (id == Block.field_72067_ar.field_71990_ca) {
                        if (quality > -0.5f) {
                            quality = -0.5f;
                        }
                        if (temp < EM_StatusManager.getTempFalloff(100.0f, dist, range)) {
                            temp = EM_StatusManager.getTempFalloff(100.0f, dist, range);
                        }
                    } else if (id == Block.field_72069_aq.field_71990_ca || id == Block.field_72052_aC.field_71990_ca) {
                        if (quality > -0.25f) {
                            quality = -0.25f;
                        }
                        if (temp < EM_StatusManager.getTempFalloff(75.0f, dist, range)) {
                            temp = EM_StatusManager.getTempFalloff(75.0f, dist, range);
                        }
                    } else if (Block.field_71973_m[id] instanceof BlockLeavesBase || Block.field_71973_m[id] instanceof BlockFlower || id == Block.field_71991_bz.field_71990_ca || id == Block.field_71980_u.field_71990_ca) {
                        boolean isPlant = true;
                        if (Block.field_71973_m[id] instanceof BlockFlower & sBoost <= 0.1f) {
                            if (((BlockFlower)Block.field_71973_m[id]).getPlantType(entityLiving.field_70170_p, i, j, k) == EnumPlantType.Plains) {
                                if (isDay) {
                                    sBoost = 0.1f;
                                }
                                isPlant = false;
                                leaves += 0.1;
                            } else {
                                isPlant = false;
                            }
                        }
                        if (isPlant) {
                            leaves += 1.0;
                        }
                    } else if (id == Block.field_72012_bb.field_71990_ca) {
                        if (temp < EM_StatusManager.getTempFalloff(50.0f, dist, range)) {
                            temp = EM_StatusManager.getTempFalloff(50.0f, dist, range);
                        }
                    } else if (id == Block.field_71942_A.field_71990_ca || id == Block.field_71943_B.field_71990_ca || id == Block.field_72108_bG.field_71990_ca && meta > 0) {
                        animalHostility = -1;
                    } else if (id == Block.field_72037_aS.field_71990_ca) {
                        cooling += EM_StatusManager.getTempFalloff(0.01f, dist, range);
                    } else if (id == Block.field_72039_aU.field_71990_ca || id == Block.field_72036_aT.field_71990_ca) {
                        cooling += EM_StatusManager.getTempFalloff(0.015f, dist, range);
                    } else if (id == Block.field_82516_cf.field_71990_ca && (meta == 1 || meta == 2)) {
                        if (meta == 1 || meta == 2) {
                            if (isDay && sBoost < 0.1f) {
                                sBoost = 0.1f;
                            }
                            leaves += 1.0;
                        } else if (meta != 0 && (meta < 7 || meta > 10)) {
                            leaves += 1.0;
                        }
                    } else if (id == Block.field_82512_cj.field_71990_ca) {
                        if (sanityRate <= sanityStartRate && sanityRate > -0.1f) {
                            sanityRate = -0.1f;
                        }
                    } else if (id == Block.field_72013_bc.field_71990_ca) {
                        if (sanityRate <= sanityStartRate && sanityRate > -0.05f) {
                            sanityRate = -0.05f;
                        }
                    } else if (id == Block.field_71955_W.field_71990_ca) {
                        if (sanityRate <= sanityStartRate && sanityRate > -0.01f) {
                            sanityRate = -0.01f;
                        }
                    } else if (id == Block.field_72084_bK.field_71990_ca && sBoost < 1.0f) {
                        sBoost = 1.0f;
                    }
                    if (id != Block.field_71944_C.field_71990_ca && id != Block.field_71938_D.field_71990_ca) continue;
                    nearLava = true;
                }
            }
        }
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            for (int slot = 0; slot < 9; ++slot) {
                ItemBlock itemBlock;
                ItemStack stack = player.field_71071_by.field_70462_a[slot];
                if (stack == null) continue;
                float stackMult = 1.0f;
                if (stack.field_77994_a > 1) {
                    stackMult = ((float)stack.field_77994_a - 1.0f) / 63.0f + 1.0f;
                }
                if (EM_Settings.itemProperties.containsKey("" + stack.field_77993_c + "," + stack.func_77960_j()) || EM_Settings.itemProperties.containsKey("" + stack.field_77993_c)) {
                    ItemProperties itemProps = EM_Settings.itemProperties.containsKey("" + stack.field_77993_c + "," + stack.func_77960_j()) ? EM_Settings.itemProperties.get("" + stack.field_77993_c + "," + stack.func_77960_j()) : EM_Settings.itemProperties.get("" + stack.field_77993_c);
                    if (itemProps.ambAir > 0.0f) {
                        leaves += (double)(itemProps.ambAir / 0.1f * stackMult);
                    } else if (quality >= itemProps.ambAir * stackMult && itemProps.ambAir < 0.0f && quality <= 0.0f) {
                        quality = itemProps.ambAir * stackMult;
                    }
                    if (temp <= itemProps.ambTemp * stackMult && itemProps.enableTemp && itemProps.ambTemp > 0.0f) {
                        temp = itemProps.ambTemp * stackMult;
                    } else if (itemProps.enableTemp && itemProps.ambTemp < 0.0f) {
                        cooling += -itemProps.ambTemp * stackMult;
                    }
                    if (sanityRate >= itemProps.ambSanity * stackMult && itemProps.ambSanity < 0.0f && sanityRate <= 0.0f) {
                        sanityRate = itemProps.ambSanity * stackMult;
                        continue;
                    }
                    if (!(sBoost <= itemProps.ambSanity * stackMult) || !(itemProps.ambSanity > 0.0f)) continue;
                    if (stack.func_77973_b() instanceof ItemBlock) {
                        if (Block.field_71973_m[((ItemBlock)stack.func_77973_b()).func_77883_f()] instanceof BlockFlower) {
                            if (!isDay) continue;
                            sBoost = itemProps.ambSanity * stackMult;
                            continue;
                        }
                        sBoost = itemProps.ambSanity * stackMult;
                        continue;
                    }
                    sBoost = itemProps.ambSanity * stackMult;
                    continue;
                }
                if (!(stack.func_77973_b() instanceof ItemBlock) || !(Block.field_71973_m[(itemBlock = (ItemBlock)stack.func_77973_b()).func_77883_f()] instanceof BlockFlower) || !(isDay & sBoost <= 0.1f) || ((BlockFlower)Block.field_71973_m[itemBlock.func_77883_f()]).getPlantType(entityLiving.field_70170_p, i, j, k) != EnumPlantType.Plains) continue;
                sBoost = 0.1f;
            }
        }
        if (lightLev > 1 && !entityLiving.field_70170_p.field_73011_w.field_76575_d) {
            quality = 2.0f;
        } else if (sanityRate <= sanityStartRate && sanityRate > -0.1f && (blockLightLev <= 1 && entityLiving.func_70660_b(Potion.field_76439_r) == null || entityLiving.field_70170_p.field_73011_w.field_76575_d)) {
            sanityRate = -0.1f;
        }
        if (entityLiving.field_70163_u > 48.0 && !entityLiving.field_70170_p.field_73011_w.field_76575_d) {
            quality = 2.0f;
        }
        bTemp = (bTemp = surBiomeTemps / (float)biomeTempChecks * 2.25f) > 1.5f ? 30.0f + (bTemp - 1.0f) * 10.0f : (bTemp < -1.5f ? -30.0f + (bTemp + 1.0f) * 10.0f : (bTemp *= 20.0f));
        if (!entityLiving.field_70170_p.field_73011_w.field_76575_d) {
            if (entityLiving.field_70163_u <= 48.0) {
                bTemp = bTemp < 20.0f ? (float)((double)bTemp + 50.0 * (1.0 - entityLiving.field_70163_u / 48.0)) : (float)((double)bTemp + 20.0 * (1.0 - entityLiving.field_70163_u / 48.0));
            } else if (entityLiving.field_70163_u > 96.0 && entityLiving.field_70163_u < 256.0) {
                bTemp = bTemp < 20.0f ? (bTemp -= (float)(20.0 * ((entityLiving.field_70163_u - 96.0) / 159.0))) : (bTemp -= (float)(40.0 * ((entityLiving.field_70163_u - 96.0) / 159.0)));
            } else if (entityLiving.field_70163_u >= 256.0) {
                bTemp = bTemp < 20.0f ? (bTemp -= 20.0f) : (bTemp -= 40.0f);
            }
        }
        bTemp -= cooling;
        if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_70608_bn()) {
            bTemp += 5.0f;
        }
        if (entityLiving.field_70170_p.func_72896_J() && entityLiving.field_70170_p.func_72937_j(i, j, k) && biome.field_76751_G != 0.0f) {
            bTemp -= 10.0f;
            dropSpeed = 0.005f;
            animalHostility = -1;
        }
        if (!entityLiving.field_70170_p.func_72937_j(i, j, k) && isDay && !entityLiving.field_70170_p.func_72896_J()) {
            bTemp -= 5.0f;
        }
        if (!isDay && bTemp > 0.0f) {
            bTemp = biome.field_76751_G == 0.0f ? (bTemp /= 9.0f) : (bTemp /= 2.0f);
        } else if (!isDay && bTemp <= 0.0f) {
            bTemp -= 10.0f;
        }
        if ((entityLiving.field_70170_p.func_72798_a(i, j, k) == Block.field_71943_B.field_71990_ca || entityLiving.field_70170_p.func_72798_a(i, j, k) == Block.field_71942_A.field_71990_ca) && entityLiving.field_70163_u > 48.0) {
            if (biome.func_76746_c()) {
                bTemp -= 10.0f;
                dropSpeed = 0.1f;
            } else {
                bTemp -= 5.0f;
                dropSpeed = 0.01f;
            }
        }
        List mobList = entityLiving.field_70170_p.func_72839_b((Entity)entityLiving, AxisAlignedBB.func_72330_a((double)(entityLiving.field_70165_t - 2.0), (double)(entityLiving.field_70163_u - 2.0), (double)(entityLiving.field_70161_v - 2.0), (double)(entityLiving.field_70165_t + 3.0), (double)(entityLiving.field_70163_u + 3.0), (double)(entityLiving.field_70161_v + 3.0)));
        Iterator iterator = mobList.iterator();
        float avgEntityTemp = 0.0f;
        int validEntities = 0;
        EnviroDataTracker tracker = EM_StatusManager.lookupTracker(entityLiving);
        while (iterator.hasNext()) {
            Entity mob = (Entity)iterator.next();
            if (!(mob instanceof EntityLivingBase)) continue;
            EnviroDataTracker mobTrack = EM_StatusManager.lookupTracker((EntityLivingBase)mob);
            EntityProperties livingProps = null;
            if (EntityList.func_75619_a((Entity)mob) > 0) {
                if (EM_Settings.livingProperties.containsKey(EntityList.func_75619_a((Entity)mob))) {
                    livingProps = EM_Settings.livingProperties.get(EntityList.func_75619_a((Entity)mob));
                }
            } else if (EntityRegistry.instance().lookupModSpawn(mob.getClass(), false) != null && EM_Settings.livingProperties.containsKey(EntityRegistry.instance().lookupModSpawn(mob.getClass(), false).getModEntityId() + 128)) {
                livingProps = EM_Settings.livingProperties.get(EntityRegistry.instance().lookupModSpawn(mob.getClass(), false).getModEntityId() + 128);
            }
            if (mob instanceof EntityVillager && entityLiving instanceof EntityPlayer && entityLiving.func_70685_l(mob) && EM_Settings.villageAssist) {
                EntityVillager villager = (EntityVillager)mob;
                Village village = entityLiving.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)villager.field_70165_t), MathHelper.func_76128_c((double)villager.field_70163_u), MathHelper.func_76128_c((double)villager.field_70161_v), 32);
                long assistTime = villager.getEntityData().func_74763_f("Enviro_Assist_Time");
                long worldTime = entityLiving.field_70170_p.field_73011_w.getWorldTime();
                if (village != null && village.func_82684_a(((EntityPlayer)entityLiving).field_71092_bJ) >= 5 && !villager.func_70631_g_() && Math.abs(worldTime - assistTime) > 24000L) {
                    FoodStats food;
                    if (villager.func_70946_n() == 2) {
                        if (sBoost < 1.0f) {
                            sBoost = 1.0f;
                        }
                    } else if (villager.func_70946_n() == 0 && isDay) {
                        if (tracker.hydration < 50.0f) {
                            tracker.hydration = 100.0f;
                            if (tracker.bodyTemp >= 38.0f) {
                                tracker.bodyTemp -= 1.0f;
                            }
                            entityLiving.field_70170_p.func_72956_a((Entity)entityLiving, "random.drink", 1.0f, 1.0f);
                            villager.func_85030_a("mob.villager.yes", 1.0f, 1.0f);
                            villager.getEntityData().func_74772_a("Enviro_Assist_Time", worldTime);
                        }
                    } else if (villager.func_70946_n() == 4 && isDay && (food = ((EntityPlayer)entityLiving).func_71024_bL()).func_75116_a() <= 10) {
                        food.func_75114_a(20);
                        entityLiving.field_70170_p.func_72956_a((Entity)entityLiving, "random.burp", 0.5f, entityLiving.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        villager.func_85030_a("mob.villager.yes", 1.0f, 1.0f);
                        villager.getEntityData().func_74772_a("Enviro_Assist_Time", worldTime);
                    }
                }
            }
            if (livingProps != null && entityLiving.func_70685_l(mob)) {
                if (sanityRate >= livingProps.ambSanity && livingProps.ambSanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate = livingProps.ambSanity;
                } else if (sanityRate <= livingProps.ambSanity && livingProps.ambSanity > 0.0f && sBoost < livingProps.ambSanity) {
                    sBoost = livingProps.ambSanity;
                }
                if (livingProps.ambAir > 0.0f) {
                    leaves += (double)(livingProps.ambAir / 0.1f);
                } else if (quality >= livingProps.ambAir && livingProps.ambAir < 0.0f && quality <= 0.0f) {
                    quality = livingProps.ambAir;
                }
                dehydrateBonus -= livingProps.ambHydration;
            } else if (mob instanceof EntityBat && entityLiving instanceof EntityPlayer && entityLiving.func_70685_l(mob)) {
                if (sanityRate <= sanityStartRate && sanityRate > -0.01f) {
                    sanityRate = -0.01f;
                }
            } else if (mob.func_70023_ak().toLowerCase().contains("ender") && entityLiving instanceof EntityPlayer && entityLiving.func_70685_l(mob)) {
                if (sanityRate <= sanityStartRate && sanityRate > -0.1f) {
                    sanityRate = -0.1f;
                }
            } else if (((EntityLivingBase)mob).func_70668_bt() == EnumCreatureAttribute.UNDEAD && entityLiving.func_70685_l(mob) && sanityRate <= sanityStartRate && sanityRate > -0.01f) {
                sanityRate = -0.01f;
            }
            if (mobTrack != null) {
                avgEntityTemp = livingProps != null ? (!livingProps.bodyTemp || !livingProps.shouldTrack ? (avgEntityTemp += livingProps.ambTemp) : (avgEntityTemp += mobTrack.bodyTemp)) : (avgEntityTemp += mobTrack.bodyTemp);
                ++validEntities;
                continue;
            }
            if (livingProps != null) {
                avgEntityTemp = !livingProps.bodyTemp || !livingProps.shouldTrack ? (avgEntityTemp += livingProps.ambTemp) : (avgEntityTemp += 37.0f);
                ++validEntities;
                continue;
            }
            if (mob instanceof EntityMob) continue;
            avgEntityTemp += 37.0f;
            ++validEntities;
        }
        if (validEntities > 0 && bTemp < (avgEntityTemp /= (float)validEntities)) {
            bTemp = (bTemp + avgEntityTemp) / 2.0f;
        }
        float fireProt = 0.0f;
        ItemStack helmet = entityLiving.func_71124_b(4);
        ItemStack plate = entityLiving.func_71124_b(3);
        ItemStack legs = entityLiving.func_71124_b(2);
        ItemStack boots = entityLiving.func_71124_b(1);
        float tempMultTotal = 0.0f;
        float addTemp = 0.0f;
        if (helmet != null) {
            NBTTagList enchTags = helmet.func_77986_q();
            if (enchTags != null) {
                for (index = 0; index < enchTags.func_74745_c(); ++index) {
                    short enID = ((NBTTagCompound)enchTags.func_74743_b(index)).func_74765_d("id");
                    enLV = ((NBTTagCompound)enchTags.func_74743_b(index)).func_74765_d("lvl");
                    if (enID == Enchantment.field_77340_h.field_77352_x) {
                        leaves += (double)(3.0f * (float)enLV);
                        continue;
                    }
                    if (enID != Enchantment.field_77329_d.field_77352_x) continue;
                    fireProt += (float)enLV;
                }
            }
            if (EM_Settings.armorProperties.containsKey(helmet.field_77993_c)) {
                ArmorProperties props = EM_Settings.armorProperties.get(helmet.field_77993_c);
                if (isDay) {
                    if (entityLiving.field_70170_p.func_72937_j(i, j, k) && bTemp > 0.0f) {
                        tempMultTotal += props.sunMult - 1.0f;
                        addTemp += props.sunTemp;
                    } else {
                        tempMultTotal += props.shadeMult - 1.0f;
                        addTemp += props.shadeTemp;
                    }
                } else {
                    tempMultTotal += props.nightMult - 1.0f;
                    addTemp += props.nightTemp;
                }
                if (props.air > 0.0f) {
                    leaves += (double)(props.air / 0.1f);
                } else if (quality >= props.air && props.air < 0.0f && quality <= 0.0f) {
                    quality = props.air;
                }
                if (sanityRate >= props.sanity && props.sanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate = props.sanity;
                } else if (sBoost <= props.sanity && props.sanity > 0.0f) {
                    sBoost = props.sanity;
                }
            }
        }
        if (plate != null) {
            NBTTagList enchTags = plate.func_77986_q();
            if (enchTags != null) {
                for (index = 0; index < enchTags.func_74745_c(); ++index) {
                    short enID = ((NBTTagCompound)enchTags.func_74743_b(index)).func_74765_d("id");
                    enLV = ((NBTTagCompound)enchTags.func_74743_b(index)).func_74765_d("lvl");
                    if (enID != Enchantment.field_77329_d.field_77352_x) continue;
                    fireProt += (float)enLV;
                }
            }
            if (EM_Settings.armorProperties.containsKey(plate.field_77993_c)) {
                ArmorProperties props = EM_Settings.armorProperties.get(plate.field_77993_c);
                if (isDay) {
                    if (entityLiving.field_70170_p.func_72937_j(i, j, k) && bTemp > 0.0f) {
                        tempMultTotal += props.sunMult - 1.0f;
                        addTemp += props.sunTemp;
                    } else {
                        tempMultTotal += props.shadeMult - 1.0f;
                        addTemp += props.shadeTemp;
                    }
                } else {
                    tempMultTotal += props.nightMult - 1.0f;
                    addTemp += props.nightTemp;
                }
                if (quality <= props.air && props.air > 0.0f || quality >= props.air && props.air < 0.0f && quality <= 0.0f) {
                    quality = props.air;
                }
                if (sanityRate >= props.sanity && props.sanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate = props.sanity;
                } else if (sBoost <= props.sanity && props.sanity > 0.0f) {
                    sBoost = props.sanity;
                }
            }
        }
        if (legs != null) {
            NBTTagList enchTags = legs.func_77986_q();
            if (enchTags != null) {
                for (int index2 = 0; index2 < enchTags.func_74745_c(); ++index2) {
                    short enID = ((NBTTagCompound)enchTags.func_74743_b(index2)).func_74765_d("id");
                    enLV = ((NBTTagCompound)enchTags.func_74743_b(index2)).func_74765_d("lvl");
                    if (enID != Enchantment.field_77329_d.field_77352_x) continue;
                    fireProt += (float)enLV;
                }
            }
            if (EM_Settings.armorProperties.containsKey(legs.field_77993_c)) {
                ArmorProperties props = EM_Settings.armorProperties.get(legs.field_77993_c);
                if (isDay) {
                    if (entityLiving.field_70170_p.func_72937_j(i, j, k) && bTemp > 0.0f) {
                        tempMultTotal += props.sunMult - 1.0f;
                        addTemp += props.sunTemp;
                    } else {
                        tempMultTotal += props.shadeMult - 1.0f;
                        addTemp += props.shadeTemp;
                    }
                } else {
                    tempMultTotal += props.nightMult - 1.0f;
                    addTemp += props.nightTemp;
                }
                if (quality <= props.air && props.air > 0.0f || quality >= props.air && props.air < 0.0f && quality <= 0.0f) {
                    quality = props.air;
                }
                if (sanityRate >= props.sanity && props.sanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate = props.sanity;
                } else if (sBoost <= props.sanity && props.sanity > 0.0f) {
                    sBoost = props.sanity;
                }
            }
        }
        if (boots != null) {
            NBTTagList enchTags = boots.func_77986_q();
            if (enchTags != null) {
                for (int index3 = 0; index3 < enchTags.func_74745_c(); ++index3) {
                    short enID = ((NBTTagCompound)enchTags.func_74743_b(index3)).func_74765_d("id");
                    enLV = ((NBTTagCompound)enchTags.func_74743_b(index3)).func_74765_d("lvl");
                    if (enID != Enchantment.field_77329_d.field_77352_x) continue;
                    fireProt += (float)enLV;
                }
            }
            if (EM_Settings.armorProperties.containsKey(boots.field_77993_c)) {
                ArmorProperties props = EM_Settings.armorProperties.get(boots.field_77993_c);
                if (isDay) {
                    if (entityLiving.field_70170_p.func_72937_j(i, j, k) && bTemp > 0.0f) {
                        tempMultTotal += props.sunMult - 1.0f;
                        addTemp += props.sunTemp;
                    } else {
                        tempMultTotal += props.shadeMult - 1.0f;
                        addTemp += props.shadeTemp;
                    }
                } else {
                    tempMultTotal += props.nightMult - 1.0f;
                    addTemp += props.nightTemp;
                }
                if (quality <= props.air && props.air > 0.0f || quality >= props.air && props.air < 0.0f && quality <= 0.0f) {
                    quality = props.air;
                }
                if (sanityRate >= props.sanity && props.sanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate = props.sanity;
                } else if (sBoost <= props.sanity && props.sanity > 0.0f) {
                    sBoost = props.sanity;
                }
            }
        }
        bTemp *= 1.0f + tempMultTotal;
        bTemp += addTemp;
        fireProt = 1.0f - fireProt / 18.0f;
        float tempFin = 0.0f;
        if (temp > bTemp) {
            tempFin = (bTemp + temp) / 2.0f;
            if (temp > bTemp + 5.0f) {
                riseSpeed = 0.005f;
            }
        } else {
            tempFin = bTemp;
        }
        if (entityLiving.func_70660_b(Potion.field_76438_s) != null) {
            dehydrateBonus += 0.1f;
        }
        if (bTypeList.contains(BiomeDictionary.Type.NETHER) || nearLava || biome.field_76751_G == 0.0f) {
            riseSpeed = 0.005f;
            dehydrateBonus += 0.05f;
            if (animalHostility == 0) {
                animalHostility = 1;
            }
            if (bTypeList.contains(BiomeDictionary.Type.NETHER) && quality <= -0.1f) {
                quality = -0.1f;
            }
        }
        if (biome.func_76744_g() == 0 && isDay) {
            dehydrateBonus += 0.05f;
            if (animalHostility == 0) {
                animalHostility = 1;
            }
        }
        if (!entityLiving.func_70644_a(Potion.field_76426_n)) {
            if (entityLiving.field_70170_p.func_72798_a(i, j, k) == Block.field_71938_D.field_71990_ca || entityLiving.field_70170_p.func_72798_a(i, j, k) == Block.field_71944_C.field_71990_ca) {
                tempFin = 200.0f;
                riseSpeed = 1.0f;
            } else if (entityLiving.func_70027_ad()) {
                if (tempFin <= 75.0f) {
                    tempFin = 75.0f;
                }
                if (riseSpeed < 0.1f) {
                    riseSpeed = 0.1f;
                }
            }
        }
        quality = (float)((double)quality + leaves * (double)0.1f);
        sanityRate += sBoost;
        if (quality < 0.0f) {
            quality = (float)((double)quality * ((double)solidBlocks / Math.pow(range * 2, 3.0)));
        }
        if (entityLiving.func_70051_ag()) {
            dehydrateBonus += 0.05f;
            if (riseSpeed < 0.01f) {
                riseSpeed = 0.01f;
            }
            tempFin += 2.0f;
        }
        data[0] = quality * (float)EM_Settings.airMult;
        data[1] = entityLiving.func_70644_a(Potion.field_76426_n) && tempFin > 37.0f ? 37.0f : (tempFin > 37.0f ? 37.0f + (tempFin - 37.0f) * fireProt : tempFin);
        data[2] = nearLava ? 1.0f : 0.0f;
        data[3] = dehydrateBonus * (float)EM_Settings.hydrationMult;
        data[4] = dropSpeed * (float)EM_Settings.tempMult;
        data[5] = riseSpeed * (float)EM_Settings.tempMult * (tracker.bodyTemp < 37.0f ? 1.0f : fireProt);
        data[6] = animalHostility;
        data[7] = sanityRate * (float)EM_Settings.sanityMult;
        if (EnviroMine.proxy.isClient() && entityLiving.func_70023_ak().equals(Minecraft.func_71410_x().field_71439_g.func_70023_ak()) && timer.isRunning()) {
            timer.stop();
            EM_GuiEnviroMeters.DB_timer = timer.toString();
            timer.reset();
        }
        return data;
    }

    public static float getBiomeTemprature(int x, int y, BiomeGenBase biome) {
        float temp = 0.0f;
        return temp;
    }

    public static void removeTracker(EnviroDataTracker tracker) {
        if (trackerList.containsValue(tracker)) {
            tracker.isDisabled = true;
            if (tracker.trackedEntity instanceof EntityPlayer) {
                trackerList.remove(((EntityPlayer)tracker.trackedEntity).field_71092_bJ);
            } else {
                trackerList.remove("" + tracker.trackedEntity.field_70157_k);
            }
        }
    }

    public static void saveAndRemoveTracker(EnviroDataTracker tracker) {
        if (trackerList.containsValue(tracker)) {
            tracker.isDisabled = true;
            NBTTagCompound tags = tracker.trackedEntity.getEntityData();
            tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
            tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
            tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
            tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
            if (tracker.trackedEntity instanceof EntityPlayer) {
                trackerList.remove(((EntityPlayer)tracker.trackedEntity).field_71092_bJ);
            } else {
                trackerList.remove("" + tracker.trackedEntity.field_70157_k);
            }
        }
    }

    public static void saveTracker(EnviroDataTracker tracker) {
        NBTTagCompound tags = tracker.trackedEntity.getEntityData();
        tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
        tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
        tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
        tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
    }

    public static void removeAllTrackers() {
        for (EnviroDataTracker tracker : trackerList.values()) {
            tracker.isDisabled = true;
        }
        trackerList.clear();
    }

    public static void saveAndDeleteAllTrackers() {
        for (EnviroDataTracker tracker : trackerList.values()) {
            NBTTagCompound tags = tracker.trackedEntity.getEntityData();
            tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
            tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
            tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
            tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
        }
        trackerList.clear();
    }

    public static void saveAndDeleteWorldTrackers(World world) {
        HashMap<String, EnviroDataTracker> tempList = new HashMap<String, EnviroDataTracker>(trackerList);
        for (EnviroDataTracker tracker : tempList.values()) {
            if (tracker.trackedEntity.field_70170_p != world) continue;
            NBTTagCompound tags = tracker.trackedEntity.getEntityData();
            tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
            tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
            tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
            tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
            tracker.isDisabled = true;
            if (tracker.trackedEntity instanceof EntityPlayer) {
                trackerList.remove(((EntityPlayer)tracker.trackedEntity).field_71092_bJ);
                continue;
            }
            trackerList.remove("" + tracker.trackedEntity.field_70157_k);
        }
    }

    public static void saveAllWorldTrackers(World world) {
        HashMap<String, EnviroDataTracker> tempList = new HashMap<String, EnviroDataTracker>(trackerList);
        for (EnviroDataTracker tracker : tempList.values()) {
            if (tracker.trackedEntity.field_70170_p != world) continue;
            NBTTagCompound tags = tracker.trackedEntity.getEntityData();
            tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
            tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
            tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
            tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
        }
    }

    public static EntityPlayer findPlayer(String username) {
        World[] worlds = new World[1];
        if (EnviroMine.proxy.isClient()) {
            if (Minecraft.func_71410_x().func_71387_A()) {
                worlds = MinecraftServer.func_71276_C().field_71305_c;
            } else {
                worlds[0] = Minecraft.func_71410_x().field_71439_g.field_70170_p;
            }
        } else {
            worlds = MinecraftServer.func_71276_C().field_71305_c;
        }
        for (int i = worlds.length - 1; i >= 0; --i) {
            EntityPlayer player;
            if (worlds[i] == null || (player = worlds[i].func_72924_a(username)) == null || !player.func_70089_S()) continue;
            return player;
        }
        return null;
    }

    public static void createFX(EntityLivingBase entityLiving) {
        float rndX = entityLiving.func_70681_au().nextFloat() * entityLiving.field_70130_N * 2.0f - entityLiving.field_70130_N;
        float rndY = entityLiving.func_70681_au().nextFloat() * entityLiving.field_70131_O;
        float rndZ = entityLiving.func_70681_au().nextFloat() * entityLiving.field_70130_N * 2.0f - entityLiving.field_70130_N;
        EnviroDataTracker tracker = EM_StatusManager.lookupTracker(entityLiving);
        if (entityLiving instanceof EntityPlayer && !(entityLiving instanceof EntityPlayerMP)) {
            rndY = -rndY;
        }
        if (tracker != null) {
            if (tracker.bodyTemp >= 38.0f && EM_Settings.sweatParticals) {
                entityLiving.field_70170_p.func_72869_a("dripWater", entityLiving.field_70165_t + (double)rndX, entityLiving.field_70163_u + (double)rndY, entityLiving.field_70161_v + (double)rndZ, 0.0, 0.0, 0.0);
            }
            if (tracker.trackedEntity.func_70644_a((Potion)EnviroPotion.insanity) && EM_Settings.insaneParticals) {
                entityLiving.field_70170_p.func_72869_a("portal", entityLiving.field_70165_t + (double)rndX, entityLiving.field_70163_u + (double)rndY, entityLiving.field_70161_v + (double)rndZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public static float getTempFalloff(float temp, float dist, int range) {
        float maximum = (float)Math.sqrt(3.0 * Math.pow(range, 2.0));
        if (dist > maximum) {
            return 0.0f;
        }
        return (float)((double)temp / Math.pow(maximum, 2.0) * -Math.pow(dist, 2.0) + (double)temp);
    }
}

