/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.spiceoflife.ModSpiceOfLife;
import squeek.spiceoflife.asm.Hooks;
import squeek.spiceoflife.foodtracker.FoodValues;

public class ClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        MethodNode methodNode;
        MethodNode methodNode2;
        ClassNode classNode;
        boolean isObfuscated;
        if (name.equals("net.minecraft.item.ItemStack") || name.equals("ye")) {
            isObfuscated = name.equals("ye");
            ModSpiceOfLife.Log.info("Patching ItemStack...");
            classNode = this.readClassFromBytes(bytes);
            methodNode2 = this.findMethodNodeOfClass(classNode, isObfuscated ? "b" : "onFoodEaten", isObfuscated ? "(Labw;Luf;)Lye;" : "(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;)Lnet/minecraft/item/ItemStack;");
            if (methodNode2 != null) {
                this.addOnEatenHook(methodNode2, Hooks.class, "onFoodEaten", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;)V");
                return this.writeClassToBytes(classNode);
            }
        }
        if (name.equals("net.minecraft.util.FoodStats") || name.equals("ux")) {
            isObfuscated = name.equals("ux");
            ModSpiceOfLife.Log.info("Patching FoodStats...");
            classNode = this.readClassFromBytes(bytes);
            methodNode2 = this.findMethodNodeOfClass(classNode, isObfuscated ? "a" : "addStats", "(IF)V");
            if (methodNode2 != null) {
                this.addFoodStatsHook(methodNode2, Hooks.class, "getModifiedFoodValues", "(Lnet/minecraft/util/FoodStats;IF)Lsqueek/spiceoflife/foodtracker/FoodValues;");
                return this.writeClassToBytes(classNode);
            }
        }
        if (name.equals("iguanaman.hungeroverhaul.IguanaFoodStats")) {
            ModSpiceOfLife.Log.info("Patching IguanaFoodStats...");
            ClassNode classNode2 = this.readClassFromBytes(bytes);
            methodNode = this.findMethodNodeOfClass(classNode2, "func_75122_a", "(IF)V");
            if (methodNode == null) {
                methodNode = this.findMethodNodeOfClass(classNode2, "addStats", "(IF)V");
            }
            if (methodNode != null) {
                this.addFoodStatsHook(methodNode, Hooks.class, "getModifiedFoodValues", "(Lnet/minecraft/util/FoodStats;IF)Lsqueek/spiceoflife/foodtracker/FoodValues;");
                return this.writeClassToBytes(classNode2);
            }
            ModSpiceOfLife.Log.warning("addStats method in IguanaFoodStats not found");
        }
        if (name.equals("net.minecraft.client.gui.inventory.GuiContainer") || name.equals("awy")) {
            boolean isObfuscated2 = name.equals("awy");
            ModSpiceOfLife.Log.info("Patching GuiContainer...");
            classNode = this.readClassFromBytes(bytes);
            methodNode2 = this.findMethodNodeOfClass(classNode, "drawHoveringText", isObfuscated2 ? "(Ljava/util/List;IILavi;)V" : "(Ljava/util/List;IILnet/minecraft/client/gui/FontRenderer;)V");
            if (methodNode2 != null) {
                this.addDrawHoveringTextHook(methodNode2, Hooks.class, "onDrawHoveringText", "(IIII)V", isObfuscated2);
                return this.writeClassToBytes(classNode);
            }
            ModSpiceOfLife.Log.warning("drawHoveringText method in GuiContainer not found");
        }
        if (name.equals("codechicken.core.gui.GuiDraw")) {
            ModSpiceOfLife.Log.info("Patching CodeChickenCore's GuiDraw...");
            ClassNode classNode3 = this.readClassFromBytes(bytes);
            methodNode = this.findMethodNodeOfClass(classNode3, "drawTooltipBox", "(IIII)V");
            if (methodNode != null) {
                this.addCodeChickenDrawHoveringTextHook(methodNode, Hooks.class, "onDrawHoveringText", "(IIII)V");
                return this.writeClassToBytes(classNode3);
            }
            ModSpiceOfLife.Log.warning("drawTooltipBox method in GuiDraw not found");
        }
        if (name.equals("tconstruct.client.gui.NewContainerGui")) {
            ModSpiceOfLife.Log.info("Patching TConstruct's NewContainerGui...");
            ClassNode classNode4 = this.readClassFromBytes(bytes);
            methodNode = this.findMethodNodeOfClass(classNode4, "func_102021_a", "(Ljava/util/List;II)V");
            if (methodNode != null) {
                this.addDrawHoveringTextHook(methodNode, Hooks.class, "onDrawHoveringText", "(IIII)V", false);
                return this.writeClassToBytes(classNode4);
            }
            ModSpiceOfLife.Log.warning("func_102021_a method in NewContainerGui not found");
        }
        return bytes;
    }

    private ClassNode readClassFromBytes(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private byte[] writeClassToBytes(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private MethodNode findMethodNodeOfClass(ClassNode classNode, String methodName, String methodDesc) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(methodName) || !method.desc.equals(methodDesc)) continue;
            ModSpiceOfLife.Log.info(" Found target method: " + methodName);
            return method;
        }
        return null;
    }

    private AbstractInsnNode findFirstInstruction(MethodNode method) {
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getType() == 8 || instruction.getType() == 15) continue;
            return instruction;
        }
        return null;
    }

    private AbstractInsnNode findFirstInstructionOfType(MethodNode method, int bytecode) {
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != bytecode) continue;
            return instruction;
        }
        return null;
    }

    private LabelNode findEndLabel(MethodNode method) {
        LabelNode lastLabel = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (!(instruction instanceof LabelNode)) continue;
            lastLabel = (LabelNode)instruction;
        }
        return lastLabel;
    }

    private LocalVariableNode findLocalVariableOfMethod(MethodNode method, String varName, String varDesc) {
        for (LocalVariableNode localVar : method.localVariables) {
            if (!localVar.name.equals(varName) || !localVar.desc.equals(varDesc)) continue;
            return localVar;
        }
        return null;
    }

    public void addOnEatenHook(MethodNode method, Class<?> hookClass, String hookMethod, String hookDesc) {
        AbstractInsnNode targetNode = this.findFirstInstructionOfType(method, 25);
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 2));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, hookClass.getName().replace('.', '/'), hookMethod, hookDesc));
        method.instructions.insertBefore(targetNode, toInject);
        ModSpiceOfLife.Log.info(" Patched " + method.name);
    }

    public void addFoodStatsHook(MethodNode method, Class<?> hookClass, String hookMethod, String hookDesc) {
        AbstractInsnNode targetNode = this.findFirstInstructionOfType(method, 25);
        InsnList toInject = new InsnList();
        LabelNode varStartLabel = new LabelNode();
        LabelNode end = this.findEndLabel(method);
        LocalVariableNode localVar = new LocalVariableNode("modifiedFoodValues", "Lsqueek/spiceoflife/foodtracker/FoodValues;", null, varStartLabel, end, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(localVar);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(23, 2));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, hookClass.getName().replace('.', '/'), hookMethod, hookDesc));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, localVar.index));
        toInject.add((AbstractInsnNode)varStartLabel);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, localVar.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, FoodValues.class.getName().replace('.', '/'), "hunger", "I"));
        toInject.add((AbstractInsnNode)new VarInsnNode(54, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, localVar.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, FoodValues.class.getName().replace('.', '/'), "saturationModifier", "F"));
        toInject.add((AbstractInsnNode)new VarInsnNode(56, 2));
        method.instructions.insertBefore(targetNode, toInject);
        ModSpiceOfLife.Log.info(" Patched " + method.name);
    }

    public void addDrawHoveringTextHook(MethodNode method, Class<?> hookClass, String hookMethod, String hookDesc, boolean isObfuscated) {
        AbstractInsnNode targetNode = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 182) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)instruction;
            if (!methodInsn.desc.equals("(IIIIII)V")) continue;
            targetNode = instruction;
        }
        if (targetNode == null) {
            ModSpiceOfLife.Log.warning("Could not patch " + method.name + "; target node not found");
            return;
        }
        ModSpiceOfLife.Log.info(" Found target node");
        LocalVariableNode x = this.findLocalVariableOfMethod(method, "i1", "I");
        LocalVariableNode y = this.findLocalVariableOfMethod(method, "j1", "I");
        LocalVariableNode w = this.findLocalVariableOfMethod(method, "k", "I");
        LocalVariableNode h = this.findLocalVariableOfMethod(method, "k1", "I");
        if (x == null || y == null || w == null || h == null) {
            ModSpiceOfLife.Log.warning("Could not patch " + method.name + "; local variables not found");
            return;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(21, x.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, y.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, w.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, h.index));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, hookClass.getName().replace('.', '/'), hookMethod, hookDesc));
        method.instructions.insert(targetNode, toInject);
        ModSpiceOfLife.Log.info(" Patched " + method.name);
    }

    public void addCodeChickenDrawHoveringTextHook(MethodNode method, Class<?> hookClass, String hookMethod, String hookDesc) {
        AbstractInsnNode targetNode = this.findFirstInstruction(method);
        if (targetNode == null) {
            ModSpiceOfLife.Log.warning("Could not patch " + method.name + "; not able to find a suitable injection point");
            return;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, hookClass.getName().replace('.', '/'), hookMethod, hookDesc));
        method.instructions.insertBefore(targetNode, toInject);
        ModSpiceOfLife.Log.info(" Patched " + method.name);
    }
}

