/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import squeek.spiceoflife.foodtracker.FixedFoodQueue;
import squeek.spiceoflife.foodtracker.FoodEaten;

public class FixedHungerQueue
extends FixedFoodQueue {
    private static final long serialVersionUID = -1347372098150405272L;
    protected int hunger;
    protected int hungerOverflow;

    public FixedHungerQueue(int limit) {
        super(limit);
    }

    @Override
    public boolean add(FoodEaten foodEaten) {
        boolean added = super.add(foodEaten);
        if (added) {
            this.hunger += foodEaten.hungerRestored;
            this.trimToMaxSize();
        }
        return added;
    }

    @Override
    public void clear() {
        super.clear();
        this.hungerOverflow = 0;
        this.hunger = 0;
    }

    public int hunger() {
        return this.hunger;
    }

    @Override
    protected void trimToMaxSize() {
        while (this.hunger > this.limit) {
            --this.hunger;
            ++this.hungerOverflow;
            while (this.hungerOverflow >= ((FoodEaten)this.peekFirst()).hungerRestored) {
                this.hungerOverflow -= ((FoodEaten)this.removeFirst()).hungerRestored;
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
    }

    @Override
    public void pack(DataOutputStream data) throws IOException {
        super.pack(data);
    }

    @Override
    public void unpack(DataInputStream data) throws IOException {
        super.unpack(data);
    }
}

