/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet8UpdateHealth;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.network.PacketFoodEatenAllTime;
import squeek.spiceoflife.network.PacketFoodHistory;

public class FoodTracker
implements IPlayerTracker {
    private float lastSaturationLevel = 0.0f;

    @ForgeSubscribe
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && FoodHistory.get((EntityPlayer)event.entity) == null) {
            EntityPlayer player = (EntityPlayer)event.entity;
            new FoodHistory(player);
        }
    }

    public void onPlayerLogin(EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        ModConfig.sync(player);
        FoodGroupRegistry.sync(player);
        FoodHistory foodHistory = FoodHistory.get(player);
        this.syncFoodHistory(foodHistory);
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
        FoodHistory foodHistory = FoodHistory.get(player);
        this.syncFoodHistory(foodHistory);
    }

    @ForgeSubscribe
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() || !(event.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        FoodHistory foodHistory = FoodHistory.get(player);
        foodHistory.saveNBTData(null);
    }

    public void onPlayerRespawn(EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        FoodHistory foodHistory = FoodHistory.get(player);
        foodHistory.loadNBTData(null);
        this.syncFoodHistory(foodHistory);
    }

    @ForgeSubscribe
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() || !(event.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        if (this.lastSaturationLevel != player.func_71024_bL().func_75115_e()) {
            PacketDispatcher.sendPacketToPlayer((Packet)new Packet8UpdateHealth(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()), (Player)((Player)player));
        }
    }

    public void syncFoodHistory(FoodHistory foodHistory) {
        PacketDispatcher.sendPacketToPlayer((Packet)new PacketFoodEatenAllTime(foodHistory.totalFoodsEatenAllTime).getPacket(), (Player)((Player)foodHistory.player));
        PacketDispatcher.sendPacketToPlayer((Packet)new PacketFoodHistory(foodHistory, true).getPacket(), (Player)((Player)foodHistory.player));
    }

    public static boolean addFoodEatenByPlayer(FoodEaten foodEaten, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            PacketDispatcher.sendPacketToPlayer((Packet)new PacketFoodHistory(foodEaten).getPacket(), (Player)((Player)player));
        }
        return FoodHistory.get(player).addFood(foodEaten);
    }

    public static int getFoodHistoryCountOf(ItemStack food, EntityPlayer player) {
        return FoodHistory.get(player).getFoodCount(food);
    }

    public static int getFoodHistoryCountOfLastEatenBy(EntityPlayer player) {
        return FoodHistory.get(player).getFoodCount(FoodTracker.getFoodLastEatenBy(player));
    }

    public static int getFoodHistoryLengthInRelevantUnits(EntityPlayer player) {
        return FoodHistory.get(player).getHistoryLengthInRelevantUnits();
    }

    public static ItemStack getFoodLastEatenBy(EntityPlayer player) {
        return FoodHistory.get((EntityPlayer)player).getLastEatenFood().itemStack;
    }

    public void onPlayerLogout(EntityPlayer player) {
    }
}

