/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker.foodgroups;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class FoodGroupMember {
    boolean exactMetadata = false;
    boolean baseItemForRecipes = false;
    int maxRecipeLevel = 0;
    String oredictName = null;
    ItemStack itemStack = null;
    List<ItemStack> matchingItems = null;

    public boolean isFoodIncluded(ItemStack food) {
        for (ItemStack itemStack : this.matchingItems) {
            if (!OreDictionary.itemMatches((ItemStack)itemStack, (ItemStack)food, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> findOutputsFromInputItems(List<ItemStack> inputItems) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : recipeList) {
            List<Object> inputList = null;
            if (recipe instanceof ShapedRecipes) {
                inputList = Arrays.asList(((ShapedRecipes)recipe).field_77574_d);
            } else if (recipe instanceof ShapelessRecipes) {
                inputList = Arrays.asList(((ShapelessRecipes)recipe).field_77579_b);
            } else if (recipe instanceof ShapedOreRecipe) {
                inputList = Arrays.asList(((ShapedOreRecipe)recipe).getInput());
            } else if (recipe instanceof ShapelessOreRecipe) {
                inputList = Arrays.asList(((ShapelessOreRecipe)recipe).getInput());
            }
            if (inputList == null || recipe.func_77571_b() == null || !this.anyItemsFoundInList(inputItems, inputList) || this.anyItemsFoundInList(Arrays.asList(recipe.func_77571_b()), inputItems)) continue;
            outputs.add(recipe.func_77571_b());
        }
        return outputs;
    }

    public void initMatchingItemsList() {
        this.matchingItems = this.getBaseItemList();
    }

    public List<ItemStack> getBaseItemList() {
        return this.itemStack != null ? Arrays.asList(this.itemStack) : OreDictionary.getOres((String)this.oredictName);
    }

    public boolean anyItemsFoundInList(List<ItemStack> inputItems, List<?> inputList) {
        for (Object obj : inputList) {
            if (obj instanceof ItemStack) {
                for (ItemStack inputItem : inputItems) {
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)obj), (ItemStack)inputItem, (boolean)false)) continue;
                    return true;
                }
                continue;
            }
            if (!(obj instanceof ArrayList) || !this.anyItemsFoundInList(inputItems, (List)obj)) continue;
            return true;
        }
        return false;
    }

    public FoodGroupMember() {
    }

    public FoodGroupMember(String oredictName) {
        this(oredictName, false);
    }

    public FoodGroupMember(String oredictName, boolean baseItemForRecipes) {
        this.oredictName = oredictName;
        this.baseItemForRecipes = baseItemForRecipes;
    }

    public FoodGroupMember(int id) {
        this(id, false);
    }

    public FoodGroupMember(int id, int meta) {
        this(id, meta, false);
    }

    public FoodGroupMember(ItemStack itemStack, boolean exactMetadata) {
        this(itemStack, exactMetadata, false);
    }

    public FoodGroupMember(int id, boolean baseItemForRecipes) {
        this(new ItemStack(id, 1, 0), false, baseItemForRecipes);
    }

    public FoodGroupMember(int id, int meta, boolean baseItemForRecipes) {
        this(new ItemStack(id, 1, meta), true, baseItemForRecipes);
    }

    public FoodGroupMember(ItemStack itemStack, boolean exactMetadata, boolean baseItemForRecipes) {
        this.itemStack = itemStack;
        this.baseItemForRecipes = baseItemForRecipes;
        if (!exactMetadata) {
            this.itemStack.func_77964_b(Short.MAX_VALUE);
        }
    }

    public void pack(DataOutputStream data) throws IOException {
        Packet.func_73270_a((ItemStack)this.itemStack, (DataOutput)data);
        data.writeUTF(this.oredictName != null ? this.oredictName : "");
        data.writeBoolean(this.exactMetadata);
        data.writeBoolean(this.baseItemForRecipes);
    }

    public void unpack(DataInputStream data, EntityPlayer player) throws IOException {
        this.itemStack = Packet.func_73276_c((DataInput)data);
        this.oredictName = data.readUTF();
        this.oredictName = this.oredictName != "" ? this.oredictName : null;
        this.exactMetadata = data.readBoolean();
        this.baseItemForRecipes = data.readBoolean();
        this.initMatchingItemsList();
    }
}

