/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.gui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.FoodModifier;
import squeek.spiceoflife.foodtracker.FoodTracker;
import squeek.spiceoflife.foodtracker.FoodValues;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.helpers.ColorHelper;
import squeek.spiceoflife.helpers.StringHelper;

public class TooltipHandler {
    private static final DecimalFormat df = new DecimalFormat("##.##");

    @ForgeSubscribe
    public void onItemTooltip(ItemTooltipEvent event) {
        if (ModConfig.FOOD_MODIFIER_ENABLED && event.itemStack != null && event.itemStack.func_77973_b() instanceof ItemFood) {
            FoodGroup foodGroup;
            int totalFoodEaten = FoodHistory.get((EntityPlayer)event.entityPlayer).totalFoodsEatenAllTime;
            float foodModifier = 1.0f;
            ArrayList<String> toolTipStringsToAdd = new ArrayList<String>();
            FoodGroup foodGroup2 = foodGroup = ModConfig.USE_FOOD_GROUPS ? FoodGroupRegistry.getFoodGroupForFood(event.itemStack) : null;
            if (ModConfig.USE_FOOD_GROUPS && foodGroup != null) {
                toolTipStringsToAdd.add(StatCollector.func_74838_a((String)"spiceoflife.tooltip.food.group") + EnumChatFormatting.ITALIC + foodGroup.getLocalizedName());
            }
            if (ModConfig.FOOD_EATEN_THRESHOLD > 0 && totalFoodEaten < ModConfig.FOOD_EATEN_THRESHOLD) {
                int timesUntilMeetsThreshold = ModConfig.FOOD_EATEN_THRESHOLD - totalFoodEaten;
                toolTipStringsToAdd.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"spiceoflife.tooltip.food.until.enabled.1"));
                toolTipStringsToAdd.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74837_a((String)"spiceoflife.tooltip.food.until.enabled.2", (Object[])new Object[]{timesUntilMeetsThreshold, timesUntilMeetsThreshold == 1 ? StatCollector.func_74838_a((String)"spiceoflife.tooltip.times.singular") : StatCollector.func_74838_a((String)"spiceoflife.tooltip.times.plural")}));
            } else {
                int count = FoodTracker.getFoodHistoryCountOf(event.itemStack, event.entityPlayer);
                FoodValues defaultFoodValues = FoodValues.get(event.itemStack);
                foodModifier = FoodModifier.getFoodModifier(event.entityPlayer, event.itemStack, event.entityPlayer.func_71024_bL(), defaultFoodValues.hunger, defaultFoodValues.saturationModifier);
                FoodValues foodValues = defaultFoodValues.getModified(foodModifier);
                if (count > 0 || foodModifier != 1.0f) {
                    toolTipStringsToAdd.add(0, EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"spiceoflife.tooltip.nutritional.value") + ColorHelper.getRelativeColor(foodModifier, 0.0, 1.0) + df.format(foodModifier * 100.0f) + "%" + (foodValues.hunger == 0 && foodModifier != 0.0f ? EnumChatFormatting.DARK_RED + " (" + foodValues.hunger + " " + StatCollector.func_74838_a((String)"spiceoflife.tooltip.hunger") + ")" : ""));
                }
                if (count > 0) {
                    toolTipStringsToAdd.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74837_a((String)("spiceoflife.tooltip.eaten.recently" + (ModConfig.USE_HUNGER_QUEUE ? ".hunger" : "")), (Object[])new Object[]{StringHelper.getQuantityDescriptor(count), ModConfig.USE_HUNGER_QUEUE ? df.format((float)ModConfig.FOOD_HISTORY_LENGTH / 2.0f) : Integer.valueOf(ModConfig.FOOD_HISTORY_LENGTH)}));
                } else {
                    toolTipStringsToAdd.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"spiceoflife.tooltip.not.eaten.recently"));
                }
            }
            event.toolTip.addAll(toolTipStringsToAdd);
        }
    }
}

