/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.helpers;

import net.minecraft.util.EnumChatFormatting;

public class ColorHelper {
    private static final EnumChatFormatting[] colorRange = new EnumChatFormatting[]{EnumChatFormatting.DARK_RED, EnumChatFormatting.RED, EnumChatFormatting.GOLD, EnumChatFormatting.YELLOW, EnumChatFormatting.DARK_GREEN, EnumChatFormatting.GREEN, EnumChatFormatting.AQUA};
    private static final EnumChatFormatting[] booleanColorRange = new EnumChatFormatting[]{EnumChatFormatting.DARK_RED, EnumChatFormatting.RED, EnumChatFormatting.DARK_GREEN, EnumChatFormatting.GREEN};

    public static String getRelativeColor(double val, double min, double max) {
        if (min == max) {
            return EnumChatFormatting.RESET.toString();
        }
        if (max > min && val > max || min > max && val < max) {
            return EnumChatFormatting.WHITE.toString() + EnumChatFormatting.BOLD;
        }
        if (max > min && val < min || min > max && val > min) {
            return colorRange[0].toString() + EnumChatFormatting.BOLD;
        }
        int index = (int)((val - min) / (max - min) * (double)(colorRange.length - 1));
        return colorRange[Math.max(0, Math.min(colorRange.length - 1, index))].toString();
    }

    public static int getRelativeColorInt(double val, double min, double max) {
        return -1442775296;
    }

    public static String getBooleanColor(boolean val) {
        return ColorHelper.getBooleanColor(val, false);
    }

    public static String getBooleanColor(boolean val, boolean modified) {
        return booleanColorRange[(val ? 2 : 0) + (modified ? 1 : 0)].toString();
    }
}

