/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.network;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import squeek.spiceoflife.network.PacketBase;
import squeek.spiceoflife.network.PacketConfigSync;
import squeek.spiceoflife.network.PacketFoodEatenAllTime;
import squeek.spiceoflife.network.PacketFoodGroup;
import squeek.spiceoflife.network.PacketFoodHistory;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        if (packet.field_73630_a.equals("SpiceOfLife")) {
            try {
                DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
                byte id = inputStream.readByte();
                if (id >= 0 && id < PacketType.values().length) {
                    PacketType.values()[id].packet.newInstance().unpack(inputStream, manager, (EntityPlayer)player);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static enum PacketType {
        ConfigSync(PacketConfigSync.class),
        FoodHistory(PacketFoodHistory.class),
        FoodEatenAllTime(PacketFoodEatenAllTime.class),
        FoodGroup(PacketFoodGroup.class);

        public Class<? extends PacketBase> packet = null;

        private PacketType(Class<? extends PacketBase> clazz) {
            this.packet = clazz;
        }

        public static int getIdOf(PacketBase packet) {
            for (PacketType packetType : PacketType.values()) {
                if (!packetType.packet.isInstance(packet)) continue;
                return packetType.ordinal();
            }
            return -1;
        }
    }
}

