/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bdew.neiaddons.NEIAddons;
import net.bdew.neiaddons.api.NEIAddon;

public abstract class BaseAddon
implements NEIAddon {
    protected Boolean active = false;
    protected Logger log;

    @Override
    public final Boolean isActive() {
        return this.active;
    }

    public final void logInfo(String message, Object ... params) {
        this.log.log(Level.INFO, String.format(message, params));
    }

    public final void logWarning(String message, Object ... params) {
        this.log.log(Level.WARNING, String.format(message, params));
    }

    public String[] getDependencies() {
        return new String[0];
    }

    public boolean checkSide(Side side) {
        return true;
    }

    public abstract void preInit(FMLPreInitializationEvent var1);

    public final void doPreInit(FMLPreInitializationEvent ev) {
        this.log = ev.getModLog();
        if (!this.checkSide(ev.getSide())) {
            this.logInfo("Wrong side: %s, %s Addon not loading", ev.getSide().toString(), this.getName());
            return;
        }
        for (String dep : this.getDependencies()) {
            if (this.verifyModVersion(dep).booleanValue()) continue;
            this.logWarning("Requirements unmet, %s Addon not loading", this.getName());
            return;
        }
        NEIAddons.register(this);
    }

    protected Boolean verifyModVersion(String spec) {
        ArtifactVersion req = VersionParser.parseVersionReference((String)spec);
        String modid = req.getLabel();
        Map modlist = Loader.instance().getIndexedModList();
        if (!modlist.containsKey(modid)) {
            this.logInfo("Required mod %s is not installed, dependent features will be unavailable", req.getLabel());
            return false;
        }
        ArtifactVersion found = ((ModContainer)modlist.get(modid)).getProcessedVersion();
        if (found == null) {
            this.logInfo("Unable to determine version of required mod %s, dependent features will be unavailable", req.getLabel());
            return false;
        }
        if (!req.containsVersion(found)) {
            this.logInfo("Version mismatch: %s is required while %s was detected, dependent features will be unavailable", req.toString(), found.getVersionString());
            return false;
        }
        this.logInfo("Version check success: %s required / %s detected", req.toString(), found.getVersionString());
        return true;
    }
}

