/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.exnihilo.waila;

import java.text.DecimalFormat;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.bdew.neiaddons.exnihilo.WailaHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BarrelHandler
implements IWailaDataProvider {
    private final DecimalFormat dec = new DecimalFormat("#,##0");
    private static final int MAX_COMPOSTING_TIME = 1000;
    private static final int MAX_FLUID = 1000;

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        int modeId = tag.func_74762_e("mode");
        float volume = tag.func_74760_g("volume");
        int timer = tag.func_74762_e("timer");
        Fluid fluid = FluidRegistry.getFluid((int)tag.func_74765_d("fluid"));
        String mode = WailaHandler.valuesBarrelMode[modeId].name();
        if (mode.equals("EMPTY")) {
            currenttip.add("Empty");
        } else if (mode.equals("FLUID")) {
            currenttip.add(String.format("%s %s mB", fluid.getLocalizedName(), this.dec.format(volume * 1000.0f)));
            MovingObjectPosition pos = accessor.getPosition();
            if (fluid.getID() == FluidRegistry.LAVA.getID() && accessor.getWorld().func_72803_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d).func_76217_h()) {
                currenttip.add(String.format("%sWill burn in %.1f seconds!!!%s", EnumChatFormatting.RED, Float.valueOf((400.0f - (float)timer) / 20.0f), EnumChatFormatting.RESET));
            }
        } else if (mode.equals("COMPOST")) {
            if (volume < 1.0f) {
                currenttip.add(String.format("Add compostable items - %.0f%%", Float.valueOf(100.0f * volume)));
            } else {
                currenttip.add(String.format("Composting - %.0f%%", Float.valueOf(100.0f * (float)timer / 1000.0f)));
            }
        } else if (mode.equals("DIRT")) {
            currenttip.add("Ready: Dirt");
        } else if (mode.equals("CLAY")) {
            currenttip.add("Ready: Clay");
        } else if (mode.equals("SPORED")) {
            currenttip.add(String.format("Making: Witch Water - %.0f%%", Float.valueOf(100.0f * (float)timer / 1000.0f)));
        } else if (mode.equals("SLIME")) {
            currenttip.add("Ready: Slime");
        } else if (mode.equals("NETHERRACK")) {
            currenttip.add("Ready: Netherrack");
        } else if (mode.equals("ENDSTONE")) {
            currenttip.add("Ready: End Stone");
        } else if (mode.equals("MILKED")) {
            currenttip.add(String.format("Making: Slime - %.0f%%", Float.valueOf(100.0f * (float)timer / 1000.0f)));
        } else if (mode.equals("SOULSAND")) {
            currenttip.add("Ready: Soul Sand");
        } else if (mode.equals("BEETRAP")) {
            currenttip.add("Ready: Artificial Hive");
        } else if (mode.equals("OBSIDIAN")) {
            currenttip.add("Ready: Obsidian");
        } else if (mode.equals("COBBLESTONE")) {
            currenttip.add("Ready: Cobblestone");
        } else if (mode.equals("BLAZE_COOKING")) {
            currenttip.add(String.format("Making: Blaze - %.0f%%", Float.valueOf(100.0f * (float)timer / 1000.0f)));
        } else if (mode.equals("BLAZE")) {
            currenttip.add("Ready: Blaze Rod");
        } else if (mode.equals("ENDER_COOKING")) {
            currenttip.add(String.format("Making: Enderman - %.0f%%", Float.valueOf(100.0f * (float)timer / 1000.0f)));
        } else if (mode.equals("ENDER")) {
            currenttip.add("Ready: Ender Pearl");
        } else {
            currenttip.add("Unknown Mode: " + mode);
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }
}

