/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.extrabees;

import forestry.api.apiculture.EnumBeeChromosome;
import net.bdew.neiaddons.extrabees.AlleleBeeChromosomePair;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SerumUtils {
    public static Item itemSerum;

    public static ItemStack getSerum(AlleleBeeChromosomePair pair) {
        return SerumUtils.getSerum(pair.allele, pair.chromosome);
    }

    public static void setup() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException {
        itemSerum = (Item)Class.forName("binnie.extrabees.ExtraBees").getField("serum").get(null);
    }

    public static boolean isSerum(ItemStack stack) {
        return stack.func_77973_b().field_77779_bT == SerumUtils.itemSerum.field_77779_bT;
    }

    public static boolean shouldMakeSerum(String allele, int chromosome) {
        return !allele.equals("forestry.boolFalse");
    }

    public static AlleleBeeChromosomePair getData(ItemStack serum) {
        NBTTagCompound nbt = serum.func_77978_p();
        if (nbt != null && nbt.func_74764_b("chromosome") && nbt.func_74764_b("uid")) {
            int chromosome = nbt.func_74762_e("chromosome");
            String allele = nbt.func_74779_i("uid");
            if (chromosome >= EnumBeeChromosome.HUMIDITY.ordinal()) {
                ++chromosome;
            }
            return new AlleleBeeChromosomePair(allele, chromosome);
        }
        return null;
    }

    public static ItemStack getSerum(String allele, int chromosome) {
        ItemStack serum = new ItemStack(itemSerum);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("uid", allele);
        if (chromosome >= EnumBeeChromosome.HUMIDITY.ordinal()) {
            nbt.func_74768_a("chromosome", chromosome - 1);
        } else {
            nbt.func_74768_a("chromosome", chromosome);
        }
        nbt.func_74768_a("quality", 10);
        serum.func_77982_d(nbt);
        return serum;
    }
}

