/*
 * Decompiled with CFR 0.152.
 */
package cofh.gui;

import cofh.gui.NEIGuiProxy;
import cofh.gui.TabTracker;
import cofh.gui.element.ElementBase;
import cofh.gui.element.TabBase;
import cofh.gui.slot.SlotFalseCopy;
import cofh.render.IconRegistry;
import cofh.render.RenderHelper;
import cofh.util.StringHelper;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiBase
extends GuiContainer {
    protected boolean drawInventory = true;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected int lastIndex = -1;
    protected String name;
    protected ResourceLocation texture;
    public ArrayList<TabBase> tabs = new ArrayList();
    protected ArrayList<ElementBase> elements = new ArrayList();
    protected List<String> tooltip = new LinkedList<String>();

    public GuiBase(Container container) {
        super(container);
    }

    public GuiBase(Container container, ResourceLocation texture) {
        super(container);
        this.texture = texture;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs.clear();
        this.elements.clear();
    }

    protected void func_74189_g(int x, int y) {
        this.field_73886_k.func_78276_b(StringHelper.localize(this.name), this.getCenteredOffset(StringHelper.localize(this.name)), 6, 0x404040);
        if (this.drawInventory) {
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_74195_c - 96 + 3, 0x404040);
        }
        if (!Loader.isModLoaded((String)"NotEnoughItems") && this.field_73882_e.field_71439_g.field_71071_by.func_70445_o() == null) {
            this.addTooltips(this.tooltip);
            this.drawTooltip(this.tooltip);
        }
    }

    protected void func_74185_a(float f, int x, int y) {
        this.updateElements();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_110577_a(this.texture);
        this.func_73729_b(this.field_74198_m, this.field_74197_n, 0, 0, this.field_74194_b, this.field_74195_c);
        this.drawElements();
        this.drawTabs();
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        ElementBase element;
        super.func_73864_a(x, y, mouseButton);
        TabBase tab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tab != null && !tab.handleMouseClicked(this.mouseX, this.mouseY, mouseButton)) {
            for (TabBase other : this.tabs) {
                if (other == tab || !other.open || other.side != tab.side) continue;
                other.toggleOpen();
            }
            tab.toggleOpen();
        }
        if ((element = this.getElementAtPosition(this.mouseX, this.mouseY)) != null) {
            element.handleMouseClicked(this.mouseX, this.mouseY, mouseButton);
        }
    }

    protected void func_85041_a(int mX, int mY, int lastClick, long timeSinceClick) {
        Slot slot = this.func_74187_b(mX, mY);
        ItemStack itemstack = this.field_73882_e.field_71439_g.field_71071_by.func_70445_o();
        if (this.field_94076_q && slot != null && itemstack != null && slot instanceof SlotFalseCopy) {
            if (this.lastIndex != slot.field_75222_d) {
                this.lastIndex = slot.field_75222_d;
                this.func_74191_a(slot, slot.field_75222_d, 0, 0);
            }
        } else {
            this.lastIndex = -1;
            super.func_85041_a(mX, mY, lastClick, timeSinceClick);
        }
    }

    public void func_73867_d() {
        int x = Mouse.getEventX() * this.field_73880_f / this.field_73882_e.field_71443_c;
        int y = this.field_73881_g - Mouse.getEventY() * this.field_73881_g / this.field_73882_e.field_71440_d - 1;
        this.mouseX = x - this.field_74198_m;
        this.mouseY = y - this.field_74197_n;
        super.func_73867_d();
    }

    protected void drawElements() {
        for (ElementBase element : this.elements) {
            element.draw();
        }
    }

    protected void drawTabs() {
        int yPosRight = 4;
        int yPosLeft = 4;
        for (TabBase tab : this.tabs) {
            tab.update();
            if (!tab.isVisible()) continue;
            if (tab.side == 0) {
                tab.draw(this.field_74198_m, this.field_74197_n + yPosLeft);
                yPosLeft += tab.currentHeight;
                continue;
            }
            tab.draw(this.field_74198_m + this.field_74194_b, this.field_74197_n + yPosRight);
            yPosRight += tab.currentHeight;
        }
    }

    public List<String> handleTooltip(int mousex, int mousey, List<String> tooltip) {
        if (NEIGuiProxy.shouldShowTooltip(this)) {
            this.addTooltips(tooltip);
        }
        return tooltip;
    }

    public void addTooltips(List<String> tooltip) {
        ElementBase element;
        TabBase tab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tab != null) {
            tab.addTooltip(tooltip);
        }
        if ((element = this.getElementAtPosition(this.mouseX, this.mouseY)) != null) {
            element.addTooltip(tooltip);
        }
    }

    public ElementBase addElement(ElementBase element) {
        this.elements.add(element);
        return element;
    }

    public TabBase addTab(TabBase tab) {
        this.tabs.add(tab);
        if (TabTracker.getOpenedLeftTab() != null && tab.getClass().equals(TabTracker.getOpenedLeftTab())) {
            tab.setFullyOpen();
        } else if (TabTracker.getOpenedRightTab() != null && tab.getClass().equals(TabTracker.getOpenedRightTab())) {
            tab.setFullyOpen();
        }
        return tab;
    }

    protected ElementBase getElementAtPosition(int mX, int mY) {
        for (ElementBase element : this.elements) {
            if (!element.intersectsWith(mX, mY)) continue;
            return element;
        }
        return null;
    }

    protected TabBase getTabAtPosition(int mX, int mY) {
        int xShift = 0;
        int yShift = 4;
        for (TabBase tab : this.tabs) {
            if (!tab.isVisible() || tab.side == 1) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        xShift = this.field_74194_b;
        yShift = 4;
        for (TabBase tab : this.tabs) {
            if (!tab.isVisible() || tab.side == 0) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        return null;
    }

    protected void updateElements() {
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
    }

    public void drawButton(Icon icon, int x, int y, int spriteSheet, int mode) {
        this.drawIcon(icon, x, y, spriteSheet);
    }

    public void drawButton(String iconName, int x, int y, int spriteSheet, int mode) {
        this.drawButton(IconRegistry.getIcon(iconName), x, y, spriteSheet, mode);
    }

    public void drawFluid(int x, int y, FluidStack fluid, int width, int height) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setColor3ub(fluid.getFluid().getColor(fluid));
        this.drawTiledTexture(x, y, fluid.getFluid().getIcon(fluid), width, height);
    }

    public void drawTiledTexture(int x, int y, Icon icon, int width, int height) {
        int i = 0;
        int j = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        for (i = 0; i < width; i += 16) {
            for (j = 0; j < height; j += 16) {
                drawWidth = Math.min(width - i, 16);
                drawHeight = Math.min(height - j, 16);
                this.drawScaledTexturedModelRectFromIcon(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawIcon(Icon icon, int x, int y, int spriteSheet) {
        if (spriteSheet == 0) {
            RenderHelper.setBlockTextureSheet();
        } else {
            RenderHelper.setItemTextureSheet();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_94065_a(x, y, icon, 16, 16);
    }

    public void drawIcon(String iconName, int x, int y, int spriteSheet) {
        this.drawIcon(IconRegistry.getIcon(iconName), x, y, spriteSheet);
    }

    public void drawSizedTexturedModalRect(int x, int y, int u, int v, int width, int height, float texW, float texH) {
        float texU = 1.0f / texW;
        float texV = 1.0f / texH;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + 0) * texU), (double)((float)(v + height) * texV));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + width) * texU), (double)((float)(v + height) * texV));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + width) * texU), (double)((float)(v + 0) * texV));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + 0) * texU), (double)((float)(v + 0) * texV));
        tessellator.func_78381_a();
    }

    public void drawScaledTexturedModelRectFromIcon(int x, int y, Icon icon, int width, int height) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, minU, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, minU + (maxU - minU) * (double)width / 16.0, minV);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, minU, minV);
        tessellator.func_78381_a();
    }

    public void drawTooltip(List<String> list) {
        this.drawTooltipHoveringText(list, this.mouseX, this.mouseY, this.field_73886_k);
        this.tooltip.clear();
    }

    protected void drawTooltipHoveringText(List list, int x, int y, FontRenderer font) {
        if (list == null || list.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int k = 0;
        for (String s : list) {
            int l = font.func_78256_a(s);
            if (l <= k) continue;
            k = l;
        }
        int i1 = x + 12;
        int j1 = y - 12;
        int k1 = 8;
        if (list.size() > 1) {
            k1 += 2 + (list.size() - 1) * 10;
        }
        if (i1 + k > this.field_73880_f) {
            i1 -= 28 + k;
        }
        if (j1 + k1 + 6 > this.field_73881_g) {
            j1 = this.field_73881_g - k1 - 6;
        }
        this.field_73735_i = 300.0f;
        GuiBase.field_74196_a.field_77023_b = 300.0f;
        int l1 = -267386864;
        this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
        this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
        int i2 = 0x505000FF;
        int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
        this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
        this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            String s1 = (String)list.get(k2);
            font.func_78261_a(s1, i1, j1, -1);
            if (k2 == 0) {
                j1 += 2;
            }
            j1 += 10;
        }
        this.field_73735_i = 0.0f;
        GuiBase.field_74196_a.field_77023_b = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    public void mouseClicked(int mouseButton) {
        super.func_73864_a(this.field_74198_m + this.mouseX, this.field_74197_n + this.mouseY, mouseButton);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_74194_b);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_73886_k.func_78256_a(string)) / 2;
    }

    public int getGuiLeft() {
        return this.field_74198_m;
    }

    public int getGuiTop() {
        return this.field_74197_n;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public void overlayRecipe() {
    }
}

