/*
 * Decompiled with CFR 0.152.
 */
package cofh.masquerade;

import cofh.CoFHCore;
import cofh.api.core.ISimpleRegistry;
import cofh.core.CoFHProps;
import cofh.masquerade.MasqueradePacketHandler;
import cofh.network.Payload;
import cofh.util.CoreUtils;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class RegistrySkins
implements ISimpleRegistry {
    private static HashMap<String, String> skinMap = new HashMap();
    public static boolean allowPlayersUse = true;
    public static boolean allowOpsUse = true;
    public static boolean allowOpsOthers = false;
    public static Configuration skinConf;

    public static void initialize() {
        RegistrySkins.registerDefaults();
        skinConf = new Configuration(new File(CoFHProps.configDir, "/cofh/CoFHMasquerade-Skins.cfg"));
        skinConf.load();
        if (!skinConf.hasCategory("skins")) {
            return;
        }
        for (String name : skinConf.getCategory("skins").keySet()) {
            Property curSkin = skinConf.getCategory("skins").get(name);
            RegistrySkins.addSkin(name, curSkin.getString(), false);
        }
        CoFHCore.log.info("Loaded " + skinConf.getCategory("skins").keySet().size() + " skins.");
    }

    public static boolean addSkin(String playerName, String skinURL, boolean saveToFile) {
        if (playerName == null || skinURL == null) {
            return false;
        }
        playerName = playerName.toLowerCase();
        skinMap.put(playerName, skinURL);
        if (saveToFile) {
            skinConf.get("skins", playerName, skinURL);
            skinConf.save();
        }
        return true;
    }

    public static boolean removeSkin(String playerName, boolean removeFromFile) {
        if (playerName == null) {
            return false;
        }
        playerName = playerName.toLowerCase();
        skinMap.remove(playerName);
        if (removeFromFile) {
            if (skinConf.hasCategory("skins")) {
                skinConf.getCategory("skins").remove((Object)playerName);
                skinConf.save();
            } else {
                RegistrySkins.registerDefaults();
                return false;
            }
        }
        RegistrySkins.registerDefaults();
        return true;
    }

    public static String getPlayerSkin(String playerName) {
        if (playerName == null || !skinMap.containsKey(playerName.toLowerCase())) {
            return String.format("http://skins.minecraft.net/MinecraftSkins/%s.png", StringUtils.func_76338_a((String)playerName));
        }
        return skinMap.get(playerName.toLowerCase());
    }

    public static boolean playerCanAccess(String playerName) {
        return allowPlayersUse ? true : allowOpsUse && CoreUtils.isOp(playerName);
    }

    public static boolean playerCanSetOthers(String playerName) {
        return allowOpsOthers && CoreUtils.isOp(playerName) && (allowPlayersUse || allowOpsUse);
    }

    public static void readJoinPacket(DataInputStream data) {
        try {
            skinMap = new HashMap();
            int count = data.readByte();
            for (int i = 0; i < count; ++i) {
                String name = data.readUTF();
                String link = data.readUTF();
                RegistrySkins.addSkin(name, link, false);
            }
        }
        catch (IOException e) {
            CoFHCore.log.log(Level.SEVERE, "Packet Payload Failure. ID: SJ");
        }
    }

    public static void readAddPacket(DataInputStream data) {
        try {
            String name = data.readUTF();
            String link = data.readUTF();
            RegistrySkins.addSkin(name, link, false);
        }
        catch (IOException e) {
            CoFHCore.log.log(Level.SEVERE, "Packet Payload Failure. ID: SA");
        }
    }

    public static void sendJoinPacket(EntityPlayer player) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        int sendCount = 0;
        try {
            int i;
            List<EntityPlayer> players = CoFHCore.proxy.getPlayerList();
            if (players.size() <= 0) {
                return;
            }
            for (i = 0; i < players.size(); ++i) {
                if (RegistrySkins.getPlayerSkin(players.get((int)i).field_71092_bJ) == null) continue;
                ++sendCount;
            }
            data.writeByte(MasqueradePacketHandler.Type.SKIN_JOIN.ordinal());
            data.writeByte(sendCount);
            for (i = 0; i < players.size(); ++i) {
                if (RegistrySkins.getPlayerSkin(players.get((int)i).field_71092_bJ) == null) continue;
                data.writeUTF(players.get((int)i).field_71092_bJ);
                data.writeUTF(RegistrySkins.getPlayerSkin(players.get((int)i).field_71092_bJ));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (sendCount == 0) {
            return;
        }
        PacketDispatcher.sendPacketToPlayer((Packet)Payload.getPacket(MasqueradePacketHandler.packetID, bytes), (Player)((Player)player));
    }

    public static void sendAddPacket(String playerUsername) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            if (RegistrySkins.getPlayerSkin(playerUsername) == null) {
                return;
            }
            data.writeByte(MasqueradePacketHandler.Type.SKIN_ADD.ordinal());
            data.writeUTF(playerUsername);
            data.writeUTF(RegistrySkins.getPlayerSkin(playerUsername));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)Payload.getPacket(MasqueradePacketHandler.packetID, bytes));
    }

    public static void readRemovePacket(DataInputStream data) {
        try {
            String name = data.readUTF();
            RegistrySkins.removeSkin(name, false);
        }
        catch (IOException e) {
            CoFHCore.log.log(Level.SEVERE, "Packet Payload Failure. ID: SR");
        }
    }

    public static void sendRemovePacket(String playerUsername) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeByte(MasqueradePacketHandler.Type.SKIN_REMOVE.ordinal());
            data.writeUTF(playerUsername);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)Payload.getPacket(MasqueradePacketHandler.packetID, bytes));
    }

    public static void registerDefaults() {
    }

    @Override
    public boolean register(String playerName, String skinURL) {
        return RegistrySkins.addSkin(playerName, skinURL, false);
    }
}

