/*
 * Decompiled with CFR 0.152.
 */
package cofh.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.UV;
import codechicken.lib.vec.Vector3;
import cofh.render.RenderHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static float[][] angleBaseYNeg;
    public static float[][] angleBaseYPos;
    public static float[][] angleBaseXPos;
    public static final float factor = 0.0625f;
    public static final int[] facingAngle;
    public static ScaledIconTransformation[] renderTransformations;
    public static Vector3 renderVector;

    public static ScaledIconTransformation getIconTransformation(Icon icon) {
        if (icon != null) {
            RenderUtils.renderTransformations[0].icon = icon;
        }
        return renderTransformations[0];
    }

    public static Vector3 getRenderVector(double x, double y, double z) {
        RenderUtils.renderVector.x = x;
        RenderUtils.renderVector.y = y;
        RenderUtils.renderVector.z = z;
        return renderVector;
    }

    public static int getFluidRenderColor(FluidStack fluid) {
        return fluid.getFluid().getColor(fluid);
    }

    public static void setFluidRenderColor(FluidStack fluid) {
        CCRenderState.setColourOpaque((int)fluid.getFluid().getColor(fluid));
    }

    public static void preRender() {
        CCRenderState.reset();
        CCRenderState.pullLightmap();
        CCRenderState.useNormals((boolean)true);
    }

    public static void beforeWorldRender(IBlockAccess world, int x, int y, int z) {
        CCRenderState.reset();
        CCRenderState.setBrightness((IBlockAccess)world, (int)x, (int)y, (int)z);
        CCRenderState.useModelColours((boolean)true);
    }

    public static void afterWorldRender(IBlockAccess world, int x, int y, int z) {
        CCRenderState.useModelColours((boolean)false);
    }

    public static void renderMask(Icon maskIcon, Icon subIcon, IItemRenderer.ItemRenderType type) {
        if (maskIcon == null || subIcon == null) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            RenderUtils.preRenderIconInv(maskIcon, 0.001);
        } else {
            RenderUtils.preRenderIconWorld(maskIcon, 0.001);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            RenderUtils.preRenderIconInv(maskIcon, -0.0635);
        } else {
            RenderUtils.preRenderIconWorld(maskIcon, -0.0635);
        }
        tessellator.func_78381_a();
        RenderHelper.setBlockTextureSheet();
        GL11.glDepthFunc((int)514);
        GL11.glDepthMask((boolean)false);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            RenderUtils.preRenderIconInv(subIcon, 0.001);
        } else {
            RenderUtils.preRenderIconWorld(subIcon, 0.001);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            RenderUtils.preRenderIconInv(subIcon, -0.0635);
        } else {
            RenderUtils.preRenderIconWorld(subIcon, -0.0635);
        }
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)2884);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void preRenderIconWorld(Icon icon, double z) {
        Tessellator.field_78398_a.func_78374_a(0.0, 1.0, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(1.0, 1.0, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(1.0, 0.0, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
    }

    public static void preRenderIconInv(Icon icon, double z) {
        Tessellator.field_78398_a.func_78374_a(0.0, 16.0, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(16.0, 16.0, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(16.0, 0.0, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
    }

    static {
        float pi;
        angleBaseYNeg = new float[6][3];
        angleBaseYPos = new float[6][3];
        angleBaseXPos = new float[6][3];
        facingAngle = new int[]{0, 0, 180, 0, 90, -90};
        renderTransformations = new ScaledIconTransformation[4];
        RenderUtils.renderTransformations[0] = new ScaledIconTransformation(Block.field_71981_t.func_71858_a(0, 0));
        RenderUtils.renderTransformations[1] = new ScaledIconTransformation(Block.field_71981_t.func_71858_a(0, 0), -1.0, 0.0);
        RenderUtils.renderTransformations[2] = new ScaledIconTransformation(Block.field_71981_t.func_71858_a(0, 0), 0.0, -1.0);
        RenderUtils.renderTransformations[3] = new ScaledIconTransformation(Block.field_71981_t.func_71858_a(0, 0), -1.0, -1.0);
        renderVector = new Vector3();
        RenderUtils.angleBaseYNeg[0][2] = pi = (float)Math.PI;
        RenderUtils.angleBaseYNeg[2][0] = -pi / 2.0f;
        RenderUtils.angleBaseYNeg[3][0] = pi / 2.0f;
        RenderUtils.angleBaseYNeg[4][2] = pi / 2.0f;
        RenderUtils.angleBaseYNeg[5][2] = -pi / 2.0f;
        RenderUtils.angleBaseYPos[1][2] = pi;
        RenderUtils.angleBaseYPos[2][0] = pi / 2.0f;
        RenderUtils.angleBaseYPos[3][0] = -pi / 2.0f;
        RenderUtils.angleBaseYPos[4][2] = -pi / 2.0f;
        RenderUtils.angleBaseYPos[5][2] = pi / 2.0f;
        RenderUtils.angleBaseXPos[0][0] = -pi / 2.0f;
        RenderUtils.angleBaseXPos[1][0] = pi / 2.0f;
        RenderUtils.angleBaseXPos[2][1] = pi;
        RenderUtils.angleBaseXPos[4][1] = -pi / 2.0f;
        RenderUtils.angleBaseXPos[5][1] = pi / 2.0f;
    }

    public static class ScaledIconTransformation
    extends IconTransformation {
        double su = 0.0;
        double sv = 0.0;

        public ScaledIconTransformation(Icon icon) {
            super(icon);
        }

        public ScaledIconTransformation(Icon icon, double scaleu, double scalev) {
            super(icon);
            this.su = scaleu;
            this.sv = scalev;
        }

        public void transform(UV texcoord) {
            texcoord.u = (double)this.icon.func_94214_a(texcoord.u % 2.0 * 16.0) + this.su * (double)(this.icon.func_94212_f() - this.icon.func_94209_e());
            texcoord.v = (double)this.icon.func_94207_b(texcoord.v % 2.0 * 16.0) + this.sv * (double)(this.icon.func_94210_h() - this.icon.func_94206_g());
        }
    }
}

