/*
 * Decompiled with CFR 0.152.
 */
package squeek.harvestcraftwaila.fixers;

import assets.pamharvestcraft.BlockPamCrop;
import assets.pamharvestcraft.BlockPamFruit;
import assets.pamharvestcraft.PamHarvestCraft;
import assets.pamharvestcraft.TileEntityPamCrop;
import assets.pamweeeflowers.BlockPamFlowerCrop;
import assets.pamweeeflowers.PamWeeeFlowers;
import assets.pamweeeflowers.TileEntityPamFlowerCrop;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import squeek.harvestcraftwaila.ModHarvestCraftWaila;

public class WailaFixer
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> toolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return toolTip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> toolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        ItemStack itemStackCrop;
        TileEntityPamCrop tileCrop;
        if (ModHarvestCraftWaila.hasHarvestCraft) {
            if (accessor.getTileEntity() instanceof TileEntityPamCrop) {
                tileCrop = (TileEntityPamCrop)accessor.getTileEntity();
                itemStackCrop = new ItemStack(PamHarvestCraft.PamCropItems[tileCrop.cropID], 1, 0);
                toolTip.add(itemStackCrop.func_82833_r());
            }
            if (accessor.getBlock() instanceof BlockPamFruit && config.getConfig("general.showcrop")) {
                float growthValue = (float)accessor.getMetadata() / 2.0f * 100.0f;
                if (growthValue < 100.0f) {
                    toolTip.add(String.format("%s : %.0f %%", StatCollector.func_74838_a((String)"hud.msg.growth"), Float.valueOf(growthValue)));
                } else {
                    toolTip.add(String.format("%s : %s", StatCollector.func_74838_a((String)"hud.msg.growth"), StatCollector.func_74838_a((String)"hud.msg.mature")));
                }
            }
        }
        if (ModHarvestCraftWaila.hasWeeeFlowers && accessor.getTileEntity() instanceof TileEntityPamFlowerCrop) {
            tileCrop = (TileEntityPamFlowerCrop)accessor.getTileEntity();
            itemStackCrop = tileCrop.cropID != 4 && tileCrop.cropID != 14 ? new ItemStack(PamWeeeFlowers.pamFlower, 1, tileCrop.cropID) : new ItemStack((Block)(tileCrop.cropID == 4 ? Block.field_72097_ad : Block.field_72107_ae));
            toolTip.add(itemStackCrop.func_82833_r());
            if (config.getConfig("general.showcrop")) {
                float growthValue = (float)tileCrop.getGrowthStage() / 2.0f * 100.0f;
                if (growthValue < 100.0f) {
                    toolTip.add(String.format("%s : %.0f %%", StatCollector.func_74838_a((String)"hud.msg.growth"), Float.valueOf(growthValue)));
                } else {
                    toolTip.add(String.format("%s : %s", StatCollector.func_74838_a((String)"hud.msg.growth"), StatCollector.func_74838_a((String)"hud.msg.mature")));
                }
            }
        }
        return toolTip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> toolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return toolTip;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        WailaFixer instance = new WailaFixer();
        if (ModHarvestCraftWaila.hasHarvestCraft) {
            registrar.registerBodyProvider((IWailaDataProvider)instance, BlockPamCrop.class);
            registrar.registerBodyProvider((IWailaDataProvider)instance, BlockPamFruit.class);
        }
        if (ModHarvestCraftWaila.hasWeeeFlowers) {
            registrar.registerBodyProvider((IWailaDataProvider)instance, BlockPamFlowerCrop.class);
        }
    }
}

