/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.model;

import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import openblocks.api.IMutantDefinition;
import openblocks.api.IMutantRenderer;
import openblocks.common.entity.EntityMutant;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelMutant
extends ModelBase {
    public HashMap<IMutantDefinition, IMutantRenderer> rendererCache = Maps.newHashMap();

    private IMutantRenderer getRenderer(IMutantDefinition definition) {
        IMutantRenderer renderer = this.rendererCache.get(definition);
        if (renderer == null) {
            renderer = definition.createRenderer();
            renderer.initialize(this);
            this.rendererCache.put(definition, renderer);
        }
        return renderer;
    }

    public void func_78088_a(Entity entity, float legSwing, float prevLegSwing, float wingSwing, float yaw, float pitch, float scale) {
        EntityMutant mutant = (EntityMutant)entity;
        IMutantDefinition head = mutant.getHead();
        IMutantDefinition body = mutant.getBody();
        IMutantDefinition arms = mutant.getArms();
        IMutantDefinition legs = mutant.getLegs();
        IMutantDefinition wings = mutant.getWings();
        IMutantDefinition tail = mutant.getTail();
        GL11.glPushMatrix();
        if (mutant.func_70631_g_()) {
            GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
        }
        if (head != null) {
            this.getRenderer(head).renderHead(mutant, scale, yaw, pitch);
        }
        GL11.glPushMatrix();
        if (mutant.func_70631_g_()) {
            GL11.glScaled((double)0.6, (double)0.6, (double)0.6);
        }
        if (body != null) {
            this.getRenderer(body).renderBody(mutant, scale);
        }
        if (arms != null) {
            this.getRenderer(arms).renderArms(mutant, scale, legSwing, prevLegSwing);
        }
        if (legs != null) {
            this.getRenderer(legs).renderLegs(mutant, scale, legSwing, prevLegSwing);
        }
        if (wings != null) {
            this.getRenderer(wings).renderWings(mutant, scale, wingSwing);
        }
        if (tail != null) {
            this.getRenderer(tail).renderTail(mutant, scale, legSwing, prevLegSwing);
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void _setTextureOffset(String par1Str, int par2, int par3) {
        this.func_78085_a(par1Str, par2, par3);
    }
}

