/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.radio;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import openblocks.client.radio.IcyURLConnection;

public class AutoConnectingStreamHandler
extends URLStreamHandler {
    private static final Map<String, AutoConnectingStreamHandler> managed = Maps.newConcurrentMap();
    private final Multimap<URL, WeakReference<HttpURLConnection>> connections = HashMultimap.create();

    public static AutoConnectingStreamHandler createManaged(String id) {
        AutoConnectingStreamHandler result = managed.get(id);
        if (result == null) {
            result = new AutoConnectingStreamHandler();
            managed.put(id, result);
        }
        return result;
    }

    public static void disconnectManaged(String id) {
        AutoConnectingStreamHandler c = managed.remove(id);
        if (c != null) {
            c.disconnect();
        }
    }

    public static void disconnectAll() {
        for (AutoConnectingStreamHandler c : managed.values()) {
            c.disconnect();
        }
        managed.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Multimap<URL, WeakReference<HttpURLConnection>> multimap = this.connections;
        synchronized (multimap) {
            for (WeakReference r : this.connections.values()) {
                HttpURLConnection c = (HttpURLConnection)r.get();
                if (c == null) continue;
                c.disconnect();
            }
            this.connections.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpURLConnection openConnection(URL url) throws IOException {
        IcyURLConnection connection = new IcyURLConnection(url);
        connection.setInstanceFollowRedirects(true);
        ((URLConnection)connection).connect();
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            ((HttpURLConnection)connection).disconnect();
            throw new IOException(String.format("Response code %d != 200, aborting", responseCode));
        }
        Multimap<URL, WeakReference<HttpURLConnection>> multimap = this.connections;
        synchronized (multimap) {
            this.connections.put((Object)url, new WeakReference<IcyURLConnection>(connection));
        }
        return connection;
    }

    @Override
    protected int getDefaultPort() {
        return 80;
    }
}

