/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.mutant;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import openblocks.api.IMutant;
import openblocks.api.IMutantRenderer;
import openblocks.utils.MutantUtils;

public class MutantRendererChicken
implements IMutantRenderer {
    private static final ResourceLocation texture = new ResourceLocation("textures/entity/chicken.png");
    private ModelRenderer head;
    private ModelRenderer bill;
    private ModelRenderer chin;
    private ModelRenderer body;
    private ModelRenderer rightLeg;
    private ModelRenderer leftLeg;
    private ModelRenderer rightWing;
    private ModelRenderer leftWing;

    @Override
    public void initialize(ModelBase base) {
        this.head = new ModelRenderer(base, 0, 0);
        this.head.func_78789_a(-2.0f, -6.0f, -2.0f, 4, 6, 3);
        this.bill = new ModelRenderer(base, 14, 0);
        this.bill.func_78789_a(-2.0f, -4.0f, -4.0f, 4, 2, 2);
        this.chin = new ModelRenderer(base, 14, 4);
        this.chin.func_78789_a(-1.0f, -2.0f, -3.0f, 2, 2, 2);
        this.rightLeg = new ModelRenderer(base, 26, 0);
        this.rightLeg.func_78789_a(-1.0f, 0.0f, -3.0f, 3, 5, 3);
        this.leftLeg = new ModelRenderer(base, 26, 0);
        this.leftLeg.func_78789_a(-1.0f, 0.0f, -3.0f, 3, 5, 3);
        this.body = new ModelRenderer(base, 0, 9);
        this.body.func_78789_a(-3.0f, -4.0f, -6.0f, 6, 8, 6);
        this.rightWing = new ModelRenderer(base, 24, 13);
        this.rightWing.func_78789_a(0.0f, 0.0f, -3.0f, 1, 4, 6);
        this.leftWing = new ModelRenderer(base, 24, 13);
        this.leftWing.func_78789_a(-1.0f, 0.0f, -3.0f, 1, 4, 6);
    }

    @Override
    public void renderHead(IMutant mutant, float scale, float yaw, float pitch) {
        MutantRendererChicken.bindTexture();
        Vec3 headAttachmentPoint = mutant.getBody().getHeadAttachmentPoint();
        MutantUtils.bindToAttachmentPoint(mutant, this.head, headAttachmentPoint);
        MutantUtils.bindToAttachmentPoint(mutant, this.bill, headAttachmentPoint);
        MutantUtils.bindToAttachmentPoint(mutant, this.chin, headAttachmentPoint);
        this.head.field_78795_f = pitch / 57.295776f;
        this.head.field_78796_g = yaw / 57.295776f;
        this.bill.field_78795_f = this.head.field_78795_f;
        this.bill.field_78796_g = this.head.field_78796_g;
        this.chin.field_78795_f = this.head.field_78795_f;
        this.chin.field_78796_g = this.head.field_78796_g;
        this.head.func_78785_a(scale);
        this.bill.func_78785_a(scale);
        this.chin.func_78785_a(scale);
    }

    @Override
    public void renderLegs(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
        MutantRendererChicken.bindTexture();
        Vec3[] legAttachmentPoints = mutant.getBody().getLegAttachmentPoints(mutant.getLegs().getNumberOfLegs());
        MutantUtils.bindToAttachmentPoint(mutant, this.leftLeg, legAttachmentPoints[0]);
        MutantUtils.bindToAttachmentPoint(mutant, this.rightLeg, legAttachmentPoints[1]);
        this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f)) * 1.4f * prevLegSwing;
        this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f + (float)Math.PI)) * 1.4f * prevLegSwing;
        this.leftLeg.func_78785_a(scale);
        this.rightLeg.func_78785_a(scale);
    }

    @Override
    public void renderBody(IMutant mutant, float scale) {
        this.body.func_78793_a(0.0f, 24.0f - (float)mutant.getLegHeight() - (float)mutant.getBodyHeight(), 0.0f);
        this.body.field_78795_f = 1.5707964f;
        MutantRendererChicken.bindTexture();
        this.body.func_78785_a(scale);
    }

    @Override
    public void renderWings(IMutant mutant, float scale, float wingSwing) {
        MutantRendererChicken.bindTexture();
        Vec3[] wingAttachmentPoints = mutant.getBody().getWingAttachmentPoints();
        MutantUtils.bindToAttachmentPoint(mutant, this.leftWing, wingAttachmentPoints[0]);
        MutantUtils.bindToAttachmentPoint(mutant, this.rightWing, wingAttachmentPoints[1]);
        this.rightWing.field_78808_h = -wingSwing;
        this.leftWing.field_78808_h = wingSwing;
        this.leftWing.func_78785_a(scale);
        this.rightWing.func_78785_a(scale);
    }

    @Override
    public void renderArms(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
    }

    @Override
    public void renderTail(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
    }

    private static void bindTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }
}

