/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.event.EventPriority;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import openblocks.Config;
import openmods.GenericInventory;
import openmods.Log;

public class PlayerInventoryStore {
    private static final String TAG_INVENTORY = "Inventory";
    private static final DateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static final Pattern SAFE_CHARS = Pattern.compile("[^A-Za-z0-9_-]");
    private static final String PREFIX = "inventory-";
    public static final PlayerInventoryStore instance = new PlayerInventoryStore();

    private PlayerInventoryStore() {
    }

    private static File getNewDumpFile(Date date, String player, World world) {
        String dateStr = FORMATTER.format(date);
        int id = 0;
        while (true) {
            String filename = String.format("inventory-%s-%s-%d", player, dateStr, id);
            File file = world.func_72860_G().func_75758_b(filename);
            if (!file.exists()) {
                return file;
            }
            ++id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File storePlayerInventory(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        GenericInventory copy = new GenericInventory("tmp", false, inv.func_70302_i_());
        copy.copyFrom((IInventory)inv);
        Date now = new Date();
        Matcher matcher = SAFE_CHARS.matcher(player.field_71092_bJ);
        String playerName = matcher.replaceAll("_");
        File dumpFile = PlayerInventoryStore.getNewDumpFile(now, playerName, player.field_70170_p);
        NBTTagCompound invData = new NBTTagCompound();
        copy.writeToNBT(invData);
        NBTTagCompound root = new NBTTagCompound();
        root.func_74782_a(TAG_INVENTORY, (NBTBase)invData);
        root.func_74772_a("Created", now.getTime());
        root.func_74778_a("Player", player.field_71092_bJ);
        try {
            FileOutputStream stream = new FileOutputStream(dumpFile);
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)root, (OutputStream)stream);
            }
            finally {
                ((OutputStream)stream).close();
            }
        }
        catch (IOException e) {
            Log.warn((String)"Failed to dump data for player %s, file %s", (Object[])new Object[]{player.field_71092_bJ, dumpFile.getAbsoluteFile()});
        }
        return dumpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IInventory loadInventory(World world, String fileId) {
        NBTTagCompound tag;
        File file = world.func_72860_G().func_75758_b(PREFIX + fileId);
        try {
            FileInputStream stream = new FileInputStream(file);
            try {
                tag = CompressedStreamTools.func_74796_a((InputStream)stream);
            }
            finally {
                ((InputStream)stream).close();
            }
        }
        catch (IOException e) {
            Log.warn((String)"Failed to read data from file %s", (Object[])new Object[]{file.getAbsoluteFile()});
            return null;
        }
        if (!tag.func_74764_b(TAG_INVENTORY)) {
            return null;
        }
        NBTTagCompound invTag = tag.func_74775_l(TAG_INVENTORY);
        GenericInventory result = new GenericInventory("tmp", false, 0);
        result.readFromNBT(invTag);
        return result;
    }

    public List<String> getMatchedDumps(World world, String prefix) {
        File dummy = world.func_72860_G().func_75758_b("dummy");
        File saveFolder = dummy.getParentFile();
        final String actualPrefix = PREFIX + prefix;
        File[] files = saveFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(actualPrefix);
            }
        });
        ArrayList result = Lists.newArrayList();
        int toCut = PREFIX.length();
        for (File f : files) {
            String name = f.getName();
            result.add(name.substring(toCut, name.length() - 4));
        }
        return result;
    }

    public boolean restoreInventory(EntityPlayer player, String fileId) {
        IInventory restored = this.loadInventory(player.field_70170_p, fileId);
        if (restored == null) {
            return false;
        }
        InventoryPlayer current = player.field_71071_by;
        if (current.func_70302_i_() < restored.func_70302_i_()) {
            Log.info((String)"Target inventory too small, %d < %d", (Object[])new Object[]{current.func_70302_i_(), restored.func_70302_i_()});
            return false;
        }
        for (int i = 0; i < restored.func_70302_i_(); ++i) {
            current.func_70299_a(i, restored.func_70301_a(i));
        }
        return true;
    }

    @ForgeSubscribe(priority=EventPriority.HIGH)
    public void onPlayerDeath(LivingDeathEvent event) {
        if (Config.dumpStiffsStuff && event.entity instanceof EntityPlayerMP && !(event.entity instanceof FakePlayer)) {
            EntityPlayer player = (EntityPlayer)event.entity;
            try {
                File file = this.storePlayerInventory(player);
                Log.info((String)"Storing post-mortem inventory of player %s into %s", (Object[])new Object[]{player.field_71092_bJ, file.getAbsolutePath()});
            }
            catch (Exception e) {
                Log.severe((Throwable)e, (String)"Failed to store inventory for player %s", (Object[])new Object[]{player.field_71092_bJ});
            }
        }
    }
}

