/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityDigitalFuse;
import openmods.block.OpenBlock;

public class BlockDigitalFuse
extends OpenBlock {
    public BlockDigitalFuse() {
        super(Config.blockDigitalFuseId, Material.field_76265_p);
        this.setRotationMode(OpenBlock.BlockRotationMode.FOUR_DIRECTIONS);
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    public boolean shouldRenderBlock() {
        return true;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean func_71853_i() {
        return true;
    }

    public int func_71865_a(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityDigitalFuse te = (TileEntityDigitalFuse)((Object)BlockDigitalFuse.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityDigitalFuse.class));
        if (te == null) {
            return 0;
        }
        if (side != te.getRotation().getOpposite().ordinal()) {
            return 0;
        }
        return te.isOutputtingPower() ? 15 : 0;
    }

    public int func_71855_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_71865_a(world, x, y, z, side);
    }

    public boolean useTESRForInventory() {
        return false;
    }

    public void func_94332_a(IconRegister registry) {
        for (int i = 0; i < 8; ++i) {
            Icons.topIcons[i] = registry.func_94245_a("openblocks:digitalfuse_" + i);
        }
        Icons.side = registry.func_94245_a("openblocks:digitalfuse_side");
        this.setTexture(ForgeDirection.EAST, Icons.side);
        this.setTexture(ForgeDirection.WEST, Icons.side);
        this.setTexture(ForgeDirection.SOUTH, Icons.side);
        this.setTexture(ForgeDirection.NORTH, Icons.side);
        this.setTexture(ForgeDirection.UP, Icons.topIcons[0]);
        this.setTexture(ForgeDirection.DOWN, Icons.side);
        this.setDefaultTexture(Icons.topIcons[0]);
    }

    public Icon getUnrotatedTexture(ForgeDirection direction, IBlockAccess world, int x, int y, int z) {
        TileEntityDigitalFuse tile;
        if (direction.equals((Object)ForgeDirection.UP) && (tile = (TileEntityDigitalFuse)((Object)BlockDigitalFuse.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityDigitalFuse.class))) != null) {
            return Icons.topIcons[tile.getSignalFlags()];
        }
        return super.getUnrotatedTexture(direction, world, x, y, z);
    }

    public static class Icons {
        public static Icon[] topIcons = new Icon[8];
        public static Icon side;
    }
}

