/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openblocks.api.IMagnetAware;
import openblocks.common.CraneRegistry;
import openblocks.common.MagnetWhitelists;
import openblocks.common.entity.EntityMountedBlock;
import openblocks.common.entity.EntitySmoothMove;
import openblocks.common.item.ItemCraneBackpack;
import openmods.entity.DelayedEntityLoadManager;
import openmods.entity.EntityBlock;
import openmods.entity.IEntityLoadListener;

public class EntityMagnet
extends EntitySmoothMove
implements IEntityAdditionalSpawnData,
IEntitySelector {
    private static final Random RANDOM = new Random();
    private IOwner owner;
    private boolean isAboveTarget;
    private boolean isMagic;

    public EntityMagnet(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityMagnet(World world, IOwner owner, boolean isMagic) {
        this(world);
        this.owner = owner;
        this.isMagic = isMagic;
        Vec3 initialTarget = owner.getTarget();
        this.func_70107_b(initialTarget.field_72450_a, initialTarget.field_72448_b, initialTarget.field_72449_c);
    }

    public boolean func_85032_ar() {
        return true;
    }

    protected void func_70081_e(int i) {
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tag) {
    }

    protected void func_70014_b(NBTTagCompound tag) {
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeBoolean(this.isMagic);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.isMagic = data.readBoolean();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.owner == null || !this.owner.isValid(this)) {
                this.func_70106_y();
                return;
            }
            if (this.owner != null) {
                this.smoother.setTarget(this.owner.getTarget());
            }
        }
        this.updatePrevPosition();
        this.smoother.update();
        boolean bl = this.isAboveTarget = !this.detectEntityTargets().isEmpty();
        if (this.isMagic && this.field_70170_p.field_72995_K && RANDOM.nextDouble() < 0.2) {
            this.field_70170_p.func_72869_a("portal", this.field_70165_t + RANDOM.nextDouble() * 0.1, this.field_70163_u - RANDOM.nextDouble() * 0.2, this.field_70161_v + RANDOM.nextDouble() * 0.1, RANDOM.nextGaussian(), -Math.abs(RANDOM.nextGaussian()), RANDOM.nextGaussian());
        }
    }

    @Override
    public void func_70107_b(double x, double y, double z) {
        if (this.smoother != null) {
            this.smoother.setTarget(x, y, z);
        }
        super.func_70107_b(x, y, z);
    }

    @Override
    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.smoother.setTarget(x, y, z);
        super.func_70080_a(x, y, z, yaw, pitch);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int something) {
        this.smoother.setTarget(x, y, z);
        super.func_70101_b(yaw, pitch);
    }

    public double func_70042_X() {
        if (this.field_70153_n == null) {
            return 0.0;
        }
        return EntityMagnet.getMountedYOffset(this.field_70153_n);
    }

    private static double getMountedYOffset(Entity rider) {
        if (rider instanceof EntityItem) {
            return -0.5;
        }
        double tmp = -Math.max(rider.func_70042_X(), (double)rider.field_70131_O);
        return tmp;
    }

    public boolean toggleMagnet() {
        if (this.field_70153_n != null) {
            Entity tmp = this.field_70153_n;
            if (tmp instanceof IMagnetAware && !((IMagnetAware)tmp).canRelease()) {
                return false;
            }
            double tmpPosY = tmp.field_70163_u;
            tmp.func_70078_a(null);
            tmp.func_70107_b(tmp.field_70165_t, tmpPosY, tmp.field_70161_v);
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity target = null;
            List<Entity> result = this.detectEntityTargets();
            Iterator<Entity> it = result.iterator();
            target = it.hasNext() ? it.next() : this.getBlockEntity();
            if (target != null) {
                target.func_70078_a((Entity)this);
                return true;
            }
        }
        return false;
    }

    public boolean func_82704_a(Entity entity) {
        return entity instanceof EntityLivingBase || MagnetWhitelists.instance.entityWhitelist.check((Object)entity);
    }

    protected List<Entity> detectEntityTargets() {
        AxisAlignedBB aabb = this.field_70121_D.func_72314_b(0.25, 0.0, 0.25).func_72329_c();
        aabb.field_72338_b -= 1.0;
        return this.field_70170_p.func_94576_a((Entity)this, aabb, (IEntitySelector)this);
    }

    private Entity getBlockEntity() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        if (!this.field_70170_p.func_72899_e(x, y = MathHelper.func_76128_c((double)(this.field_70163_u - 0.5)), z = MathHelper.func_76128_c((double)this.field_70161_v)) || this.field_70170_p.func_72799_c(x, y, z)) {
            return null;
        }
        EntityBlock result = null;
        if (MagnetWhitelists.instance.testBlock(this.field_70170_p, x, y, z)) {
            result = EntityBlock.create((World)this.field_70170_p, (int)x, (int)y, (int)z, EntityMountedBlock.class);
        }
        if (result != null) {
            result.func_70107_b(this.field_70165_t, this.field_70163_u + EntityMagnet.getMountedYOffset((Entity)result), this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)result);
        }
        return result;
    }

    public boolean isAboveTarget() {
        return this.isAboveTarget;
    }

    public boolean isLocked() {
        return this.field_70153_n != null;
    }

    public boolean isValid() {
        return this.owner != null ? this.owner.isValid(this) : false;
    }

    public static class PlayerBound
    extends EntityMagnet
    implements IEntityLoadListener {
        private WeakReference<Entity> owner;

        public PlayerBound(World world) {
            super(world);
            this.owner = new WeakReference<Object>(null);
        }

        public PlayerBound(World world, EntityPlayer owner) {
            super(world, new EntityPlayerTarget(owner), false);
            this.owner = new WeakReference<EntityPlayer>(owner);
            CraneRegistry.instance.bindMagnetToPlayer((Entity)owner, this);
        }

        @Override
        public void writeSpawnData(ByteArrayDataOutput data) {
            super.writeSpawnData(data);
            Entity owner = (Entity)this.owner.get();
            data.writeInt(owner != null ? owner.field_70157_k : -1);
        }

        @Override
        public void readSpawnData(ByteArrayDataInput data) {
            super.readSpawnData(data);
            int entityId = data.readInt();
            if (entityId >= 0) {
                DelayedEntityLoadManager.instance.registerLoadListener(this.field_70170_p, (IEntityLoadListener)this, entityId);
            }
        }

        @Override
        public boolean func_82704_a(Entity entity) {
            return entity != this.owner.get() && super.func_82704_a(entity);
        }

        public void onEntityLoaded(Entity entity) {
            if (entity instanceof EntityPlayer) {
                this.owner = new WeakReference<Entity>(entity);
                CraneRegistry.instance.bindMagnetToPlayer(entity, this);
            }
        }
    }

    private static class EntityPlayerTarget
    implements IOwner {
        private WeakReference<EntityPlayer> owner;

        public EntityPlayerTarget(EntityPlayer owner) {
            this.owner = new WeakReference<EntityPlayer>(owner);
        }

        @Override
        public boolean isValid(EntityMagnet magnet) {
            EntityPlayer player = (EntityPlayer)this.owner.get();
            if (player == null || player.field_70128_L) {
                return false;
            }
            if (magnet.field_70170_p != player.field_70170_p) {
                return false;
            }
            return ItemCraneBackpack.isWearingCrane(player);
        }

        @Override
        public Vec3 getTarget() {
            EntityPlayer player = (EntityPlayer)this.owner.get();
            if (player == null) {
                return null;
            }
            double posX = player.field_70165_t + 2.0 * (double)MathHelper.func_76134_b((float)((player.field_70177_z + 90.0f) * (float)Math.PI / 180.0f));
            double posZ = player.field_70161_v + 2.0 * (double)MathHelper.func_76126_a((float)((player.field_70177_z + 90.0f) * (float)Math.PI / 180.0f));
            double posY = player.field_70163_u + (double)player.field_70131_O - CraneRegistry.instance.getCraneMagnetDistance(player);
            return Vec3.func_72443_a((double)posX, (double)posY, (double)posZ);
        }
    }

    public static interface IOwner {
        public boolean isValid(EntityMagnet var1);

        public Vec3 getTarget();
    }
}

