/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.base.Objects;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import openblocks.api.IMutant;
import openblocks.api.IMutantDefinition;
import openblocks.api.MutantRegistry;
import openmods.utils.CollectionUtils;

public class EntityMutant
extends EntityTameable
implements IEntityAdditionalSpawnData,
IMutant {
    private Class<? extends EntityLivingBase> head;
    private Class<? extends EntityLivingBase> body;
    private Class<? extends EntityLivingBase> arms;
    private Class<? extends EntityLivingBase> wings;
    private Class<? extends EntityLivingBase> legs;
    private Class<? extends EntityLivingBase> tail;

    public EntityMutant(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.func_70903_f(true);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return new EntityMutant(this.field_70170_p);
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeUTF(EntityMutant.getEntityIdForClass(this.head));
        data.writeUTF(EntityMutant.getEntityIdForClass(this.body));
        data.writeUTF(EntityMutant.getEntityIdForClass(this.arms));
        data.writeUTF(EntityMutant.getEntityIdForClass(this.wings));
        data.writeUTF(EntityMutant.getEntityIdForClass(this.legs));
        data.writeUTF(EntityMutant.getEntityIdForClass(this.tail));
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.head = EntityMutant.getEntityClassForId(data.readUTF());
        this.body = EntityMutant.getEntityClassForId(data.readUTF());
        this.arms = EntityMutant.getEntityClassForId(data.readUTF());
        this.wings = EntityMutant.getEntityClassForId(data.readUTF());
        this.legs = EntityMutant.getEntityClassForId(data.readUTF());
        this.tail = EntityMutant.getEntityClassForId(data.readUTF());
    }

    private static String getEntityIdForClass(Class<? extends EntityLivingBase> klazz) {
        return (String)Objects.firstNonNull((Object)((String)EntityList.field_75626_c.get(klazz)), (Object)"");
    }

    private static Class<? extends EntityLivingBase> getEntityClassForId(String id) {
        return (Class)EntityList.field_75625_b.get(id);
    }

    @Override
    public IMutantDefinition getBody() {
        return MutantRegistry.getDefinition(this.body);
    }

    @Override
    public IMutantDefinition getHead() {
        return MutantRegistry.getDefinition(this.head);
    }

    @Override
    public IMutantDefinition getArms() {
        return MutantRegistry.getDefinition(this.arms);
    }

    @Override
    public IMutantDefinition getWings() {
        return MutantRegistry.getDefinition(this.wings);
    }

    @Override
    public IMutantDefinition getLegs() {
        return MutantRegistry.getDefinition(this.legs);
    }

    @Override
    public IMutantDefinition getTail() {
        return MutantRegistry.getDefinition(this.tail);
    }

    @Override
    public int getLegHeight() {
        return this.getLegs().getLegHeight();
    }

    @Override
    public int getBodyHeight() {
        return this.getBody().getBodyHeight();
    }

    @Override
    public float getArmSwingProgress(float scale) {
        return this.func_70678_g(scale);
    }

    @Override
    public int getNumberOfLegs() {
        return this.getLegs().getNumberOfLegs();
    }

    public void setTraitsFromMap(HashMap<String, Integer> dnas) {
        this.head = EntityMutant.getEntityClassForId((String)CollectionUtils.getWeightedRandom(dnas));
        this.body = EntityMutant.getEntityClassForId((String)CollectionUtils.getWeightedRandom(dnas));
        this.arms = EntityMutant.getEntityClassForId((String)CollectionUtils.getWeightedRandom(dnas));
        this.legs = EntityMutant.getEntityClassForId((String)CollectionUtils.getWeightedRandom(dnas));
        this.wings = EntityMutant.getEntityClassForId((String)CollectionUtils.getWeightedRandom(dnas));
        this.tail = EntityMutant.getEntityClassForId((String)CollectionUtils.getWeightedRandom(dnas));
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74778_a("head", EntityMutant.getEntityIdForClass(this.head));
        tag.func_74778_a("body", EntityMutant.getEntityIdForClass(this.body));
        tag.func_74778_a("arms", EntityMutant.getEntityIdForClass(this.arms));
        tag.func_74778_a("legs", EntityMutant.getEntityIdForClass(this.legs));
        tag.func_74778_a("wings", EntityMutant.getEntityIdForClass(this.wings));
        tag.func_74778_a("tail", EntityMutant.getEntityIdForClass(this.tail));
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.head = EntityMutant.getEntityClassForId(tag.func_74779_i("head"));
        this.body = EntityMutant.getEntityClassForId(tag.func_74779_i("body"));
        this.arms = EntityMutant.getEntityClassForId(tag.func_74779_i("arms"));
        this.legs = EntityMutant.getEntityClassForId(tag.func_74779_i("legs"));
        this.wings = EntityMutant.getEntityClassForId(tag.func_74779_i("wings"));
        this.tail = EntityMutant.getEntityClassForId(tag.func_74779_i("tail"));
    }

    public Entity func_70902_q() {
        return this.func_130012_q();
    }
}

