/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidContainerItem;
import openblocks.common.tileentity.TileEntityTank;
import openmods.item.ItemOpenBlock;
import openmods.utils.ItemUtils;

public class ItemTankBlock
extends ItemOpenBlock
implements IFluidContainerItem {
    public static final String TANK_TAG = "tank";

    public ItemTankBlock(int id) {
        super(id);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        FluidTank fakeTank = ItemTankBlock.readTank(stack);
        FluidStack liquid = fakeTank.getFluid();
        if (liquid != null && liquid.amount > 0) {
            float percent = Math.max(100.0f / (float)fakeTank.getCapacity() * (float)liquid.amount, 1.0f);
            list.add(String.format("%d mB (%.0f%%)", liquid.amount, Float.valueOf(percent)));
        }
    }

    private static FluidTank readTank(ItemStack stack) {
        FluidTank tank = new FluidTank(TileEntityTank.getTankCapacity());
        NBTTagCompound itemTag = stack.func_77978_p();
        if (itemTag != null && itemTag.func_74764_b(TANK_TAG)) {
            tank.readFromNBT(itemTag.func_74775_l(TANK_TAG));
            return tank;
        }
        return tank;
    }

    private static void saveTank(ItemStack container, FluidTank tank) {
        NBTTagCompound itemTag = ItemUtils.getItemTag((ItemStack)container);
        NBTTagCompound tankTag = new NBTTagCompound();
        tank.writeToNBT(tankTag);
        itemTag.func_74782_a(TANK_TAG, (NBTBase)tankTag);
    }

    public FluidStack getFluid(ItemStack container) {
        FluidTank tank = ItemTankBlock.readTank(container);
        return tank != null ? tank.getFluid() : null;
    }

    public int getCapacity(ItemStack container) {
        FluidTank tank = ItemTankBlock.readTank(container);
        return tank != null ? tank.getCapacity() : 0;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        FluidTank tank = ItemTankBlock.readTank(container);
        if (tank == null) {
            return 0;
        }
        int result = tank.fill(resource, doFill);
        if (doFill) {
            ItemTankBlock.saveTank(container, tank);
        }
        return result;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        FluidTank tank = ItemTankBlock.readTank(container);
        if (tank == null) {
            return null;
        }
        FluidStack result = tank.drain(maxDrain, doDrain);
        if (doDrain) {
            ItemTankBlock.saveTank(container, tank);
        }
        return result;
    }
}

