/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;
import openblocks.client.gui.GuiBlockPlacer;
import openblocks.common.container.ContainerBlockPlacer;
import openmods.GenericInventory;
import openmods.IInventoryProvider;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.InventoryUtils;

public class TileEntityBlockPlacer
extends OpenTileEntity
implements INeighbourAwareTile,
IHasGui,
IExtendable,
IInventoryProvider {
    static final int BUFFER_SIZE = 9;
    private boolean _redstoneSignal;
    private final GenericInventory inventory = new GenericInventory("blockPlacer", false, 9);

    public void setRedstoneSignal(boolean redstoneSignal) {
        if (redstoneSignal != this._redstoneSignal) {
            this._redstoneSignal = redstoneSignal;
            if (this._redstoneSignal && !InventoryUtils.inventoryIsEmpty((IInventory)this.inventory)) {
                this.placeBlock();
            }
        }
    }

    private void placeBlock() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        ForgeDirection direction = this.getRotation();
        int x = this.field_70329_l + direction.offsetX;
        int y = this.field_70330_m + direction.offsetY;
        int z = this.field_70327_n + direction.offsetZ;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            int slotId = i;
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a == 0) continue;
            this.placeBlock(direction, x, y, z, slotId, stack);
        }
    }

    private void placeBlock(final ForgeDirection direction, final int x, final int y, final int z, final int slotId, final ItemStack stack) {
        FakePlayerPool.instance.executeOnPlayer(this.field_70331_k, new FakePlayerPool.PlayerUser(){

            public void usePlayer(OpenModsFakePlayer fakePlayer) {
                ItemStack newStack = fakePlayer.equipWithAndRightClick(stack, Vec3.func_72443_a((double)TileEntityBlockPlacer.this.field_70329_l, (double)TileEntityBlockPlacer.this.field_70330_m, (double)TileEntityBlockPlacer.this.field_70327_n), Vec3.func_72443_a((double)x, (double)(y - 1), (double)z), direction.getOpposite(), TileEntityBlockPlacer.this.field_70331_k.func_72899_e(x, y, z) && !TileEntityBlockPlacer.this.field_70331_k.func_72799_c(x, y, z) && !Block.field_71973_m[TileEntityBlockPlacer.this.field_70331_k.func_72798_a(x, y, z)].isBlockReplaceable(TileEntityBlockPlacer.this.field_70331_k, x, y, z));
                TileEntityBlockPlacer.this.inventory.func_70299_a(slotId, newStack);
            }
        });
    }

    public void onNeighbourChanged(int blockId) {
        if (!this.field_70331_k.field_72995_K) {
            this.setRedstoneSignal(this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerBlockPlacer((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiBlockPlacer(new ContainerBlockPlacer((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }
}

