/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiSprinkler;
import openblocks.common.container.ContainerSprinkler;
import openmods.GenericInventory;
import openmods.IInventoryProvider;
import openmods.api.IBreakAwareTile;
import openmods.api.IHasGui;
import openmods.api.ISurfaceAttachment;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.liquids.GenericFluidHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;
import openmods.utils.InventoryUtils;

public class TileEntitySprinkler
extends SyncedTileEntity
implements IBreakAwareTile,
ISurfaceAttachment,
IInventoryProvider,
IExtendable,
IHasGui {
    private static final FluidStack WATER = new FluidStack(FluidRegistry.WATER, 1);
    private static final ItemStack BONEMEAL = new ItemStack(Item.field_77756_aW, 1, 15);
    private static final Random RANDOM = new Random();
    private boolean hasBonemeal = false;
    private SyncableFlags flags;
    private SyncableTank tank;
    public int ticks;
    private final GenericInventory inventory = new GenericInventory("sprinkler", true, 9){

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return itemstack != null && itemstack.func_77969_a(BONEMEAL);
        }
    };
    @IncludeInterface
    private final IFluidHandler tankWrapper = new GenericFluidHandler.Drain((IFluidTank)this.tank);

    protected void createSyncedFields() {
        this.flags = new SyncableFlags();
        this.tank = new SyncableTank(1000, new FluidStack[]{WATER, OpenBlocks.XP_FLUID});
    }

    private static int selectFromRange(int range) {
        return RANDOM.nextInt(2 * range + 1) - range;
    }

    private void attemptFertilize() {
        int fertilizerChance;
        int n = fertilizerChance = this.hasBonemeal ? Config.sprinklerBonemealFertizizeChance : Config.sprinklerFertilizeChance;
        if (RANDOM.nextDouble() < 1.0 / (double)fertilizerChance) {
            FakePlayerPool.instance.executeOnPlayer(this.field_70331_k, new FakePlayerPool.PlayerUser(){

                public void usePlayer(OpenModsFakePlayer fakePlayer) {
                    int x = TileEntitySprinkler.selectFromRange(Config.sprinklerEffectiveRange) + TileEntitySprinkler.this.field_70329_l;
                    int z = TileEntitySprinkler.selectFromRange(Config.sprinklerEffectiveRange) + TileEntitySprinkler.this.field_70327_n;
                    for (int i = -1; i <= 1; ++i) {
                        int y = TileEntitySprinkler.this.field_70330_m + i;
                        if (ItemDye.applyBonemeal((ItemStack)BONEMEAL.func_77946_l(), (World)TileEntitySprinkler.this.field_70331_k, (int)x, (int)y, (int)z, (EntityPlayer)fakePlayer)) break;
                    }
                }
            });
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerSprinkler((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiSprinkler(new ContainerSprinkler((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    private void sprayParticles() {
        if (this.tank.getFluidAmount() > 0) {
            for (int i = 0; i < 6; ++i) {
                float offset = ((float)i - 2.5f) / 5.0f;
                ForgeDirection rotation = this.getRotation();
                Vec3 vec = this.field_70331_k.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
                float pitch = this.getSprayPitch();
                double sinPitch = Math.sin(pitch);
                double cosPitch = Math.cos(pitch);
                if (rotation.offsetZ == 0) {
                    vec.field_72448_b = Math.abs(cosPitch);
                    vec.field_72449_c = sinPitch * (double)rotation.offsetX;
                    vec.field_72450_a = (this.field_70331_k.field_73012_v.nextDouble() - 0.5) * 2.0 * (double)offset;
                } else {
                    vec.field_72448_b = Math.abs(cosPitch);
                    vec.field_72450_a = -sinPitch * (double)rotation.offsetZ;
                    vec.field_72449_c = (this.field_70331_k.field_73012_v.nextDouble() - 0.5) * 2.0 * (double)offset;
                }
                vec.field_72450_a /= 2.0;
                vec.field_72448_b /= 2.0;
                vec.field_72449_c /= 2.0;
                OpenBlocks.proxy.spawnLiquidSpray(this.field_70331_k, this.tank.getFluid(), (double)this.field_70329_l + 0.5 + (double)offset * 0.6 * (double)rotation.offsetX, this.field_70330_m, (double)this.field_70327_n + 0.5 + (double)offset * 0.6 * (double)rotation.offsetZ, 0.3f, 0.7f, vec);
            }
        }
    }

    public void func_70316_g() {
        super.func_70316_g();
        ++this.ticks;
        if (!this.field_70331_k.field_72995_K) {
            this.tank.fillFromSides(3, this.field_70331_k, this.getPosition());
            if (this.ticks % 1200 == 0) {
                this.hasBonemeal = InventoryUtils.consumeInventoryItem((IInventory)this.inventory, (ItemStack)BONEMEAL);
            }
            if (this.ticks % 60 == 0) {
                this.setEnabled(this.tank.drain(1, true) != null);
                this.sync();
            }
        }
        if (this.isEnabled()) {
            if (this.field_70331_k.field_72995_K) {
                this.sprayParticles();
            } else {
                this.attemptFertilize();
            }
        }
    }

    private void setEnabled(boolean b) {
        this.flags.set((Enum)Flags.enabled, b);
    }

    private boolean isEnabled() {
        return this.flags.get((Enum)Flags.enabled);
    }

    public ForgeDirection getSurfaceDirection() {
        return ForgeDirection.DOWN;
    }

    public void onBlockBroken() {
        if (!this.field_70331_k.field_72995_K && !this.field_70331_k.func_72799_c(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
            BlockUtils.dropItemStackInWorld((World)this.field_70331_k, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (ItemStack)new ItemStack((Block)OpenBlocks.Blocks.sprinkler));
        }
    }

    public float getSprayPitch() {
        return (float)((double)this.getSprayAngle() * Math.PI);
    }

    public float getSprayAngle() {
        if (this.isEnabled()) {
            return MathHelper.func_76126_a((float)((float)this.ticks * 0.02f)) * (float)Math.PI * 0.035f;
        }
        return 0.0f;
    }

    @IncludeOverride
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public static enum Flags {
        enabled;

    }
}

