/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiVacuumHopper;
import openblocks.common.container.ContainerVacuumHopper;
import openblocks.common.entity.EntityItemProjectile;
import openmods.GenericInventory;
import openmods.IInventoryProvider;
import openmods.OpenMods;
import openmods.api.IActivateAwareTile;
import openmods.api.IHasGui;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.liquids.SidedFluidHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;
import openmods.utils.InventoryUtils;
import openmods.utils.SidedInventoryAdapter;

public class TileEntityVacuumHopper
extends SyncedTileEntity
implements IInventoryProvider,
IActivateAwareTile,
IHasGui,
IExtendable,
IEntitySelector {
    private static final int TANK_CAPACITY = EnchantmentUtils.XPToLiquidRatio((int)EnchantmentUtils.getExperienceForLevel((int)5));
    private SyncableTank tank;
    public SyncableFlags xpOutputs;
    public SyncableFlags itemOutputs;
    public SyncableBoolean vacuumDisabled;
    private final GenericInventory inventory = new GenericInventory("vacuumhopper", true, 10);
    @IncludeInterface(value=ISidedInventory.class)
    private final SidedInventoryAdapter sided = new SidedInventoryAdapter((IInventory)this.inventory);
    @IncludeInterface
    private final IFluidHandler tankWrapper = new SidedFluidHandler.Source(this.xpOutputs, (IFluidTank)this.tank);

    protected void createSyncedFields() {
        this.tank = new SyncableTank(TANK_CAPACITY, new FluidStack[]{OpenBlocks.XP_FLUID});
        this.xpOutputs = new SyncableFlags();
        this.itemOutputs = new SyncableFlags();
        this.vacuumDisabled = new SyncableBoolean();
    }

    public TileEntityVacuumHopper() {
        this.sided.registerAllSlots(this.itemOutputs, false, true);
    }

    public SyncableFlags getXPOutputs() {
        return this.xpOutputs;
    }

    public SyncableFlags getItemOutputs() {
        return this.itemOutputs;
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public boolean func_82704_a(Entity entity) {
        if (entity.field_70128_L) {
            return false;
        }
        if (entity instanceof EntityItemProjectile) {
            return entity.field_70181_x < 0.01;
        }
        if (entity instanceof EntityItem) {
            ItemStack stack = ((EntityItem)entity).func_92059_d();
            return InventoryUtils.testInventoryInsertion((IInventory)this.inventory, (ItemStack)stack) > 0;
        }
        if (entity instanceof EntityXPOrb) {
            return this.tank.getSpace() > 0;
        }
        return false;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.vacuumDisabled.getValue()) {
            return;
        }
        if (this.field_70331_k.field_72995_K) {
            this.field_70331_k.func_72869_a("portal", (double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, this.field_70331_k.field_73012_v.nextDouble() - 0.5, this.field_70331_k.field_73012_v.nextDouble() - 1.0, this.field_70331_k.field_73012_v.nextDouble() - 0.5);
        }
        List interestingItems = this.field_70331_k.func_82733_a(Entity.class, this.getBB().func_72314_b(3.0, 3.0, 3.0), (IEntitySelector)this);
        for (Entity entity : interestingItems) {
            double x = (double)this.field_70329_l + 0.5 - entity.field_70165_t;
            double y = (double)this.field_70330_m + 0.5 - entity.field_70163_u;
            double z = (double)this.field_70327_n + 0.5 - entity.field_70161_v;
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (distance < 1.1) {
                this.onEntityCollidedWithBlock(entity);
                continue;
            }
            double var11 = 1.0 - distance / 15.0;
            if (!(var11 > 0.0)) continue;
            var11 *= var11;
            entity.field_70159_w += x / distance * var11 * 0.05;
            entity.field_70181_x += y / distance * var11 * 0.2;
            entity.field_70179_y += z / distance * var11 * 0.05;
        }
        if (!this.field_70331_k.field_72995_K) {
            this.outputToNeighbors();
        }
    }

    private void outputToNeighbors() {
        this.tank.distributeToSides(50, this.field_70331_k, this.getPosition(), this.xpOutputs);
        if (OpenMods.proxy.getTicks(this.field_70331_k) % 10L == 0L) {
            this.autoInventoryOutput();
        }
    }

    private void autoInventoryOutput() {
        int firstUsedSlot = -1;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i) == null) continue;
            firstUsedSlot = i;
            break;
        }
        if (firstUsedSlot < 0) {
            return;
        }
        ArrayList slots = Lists.newArrayList((Iterable)this.getItemOutputs().getActiveSlots());
        Collections.shuffle(slots);
        for (Integer dir : slots) {
            ForgeDirection directionToOutputItem = ForgeDirection.getOrientation((int)dir);
            TileEntity tileOnSurface = this.getTileInDirection(directionToOutputItem);
            if (InventoryUtils.moveItemInto((IInventory)this.inventory, (int)firstUsedSlot, (Object)tileOnSurface, (int)-1, (int)64, (ForgeDirection)directionToOutputItem, (boolean)true) <= 0) continue;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            break;
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerVacuumHopper((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiVacuumHopper(new ContainerVacuumHopper((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c) == null) {
            this.vacuumDisabled.toggle();
            return true;
        }
        return false;
    }

    public void onEntityCollidedWithBlock(Entity entity) {
        if (!this.field_70331_k.field_72995_K) {
            if (entity instanceof EntityItem && !entity.field_70128_L) {
                EntityItem item = (EntityItem)entity;
                ItemStack stack = item.func_92059_d().func_77946_l();
                InventoryUtils.insertItemIntoInventory((IInventory)this.inventory, (ItemStack)stack);
                if (stack.field_77994_a == 0) {
                    item.func_70106_y();
                } else {
                    item.func_92058_a(stack);
                }
            } else if (entity instanceof EntityXPOrb && this.tank.getSpace() > 0) {
                FluidStack newFluid = new FluidStack(OpenBlocks.Fluids.XPJuice, EnchantmentUtils.XPToLiquidRatio((int)((EntityXPOrb)entity).func_70526_d()));
                this.tank.fill(newFluid, true);
                entity.func_70106_y();
            }
        }
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }
}

