/*
 * Decompiled with CFR 0.152.
 */
package openblocks.enchantments;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.api.FlimFlamRegistry;
import openblocks.api.IFlimFlamEffect;
import openmods.Log;
import openmods.config.ConfigurationChange;

public class FlimFlamEnchantmentsHandler {
    public static final String LUCK_PROPERTY = "OpenBlocks-Luck";
    public static final int LUCK_MARGIN = -30;
    public static final int EFFECT_DELAY = 300;
    private static final Random RANDOM = new Random();
    private static Set<String> blacklist;

    private static Set<String> getBlacklist() {
        if (blacklist == null) {
            blacklist = Sets.newHashSet();
            HashSet validNames = Sets.newHashSet(FlimFlamRegistry.getAllFlimFlamsNames());
            for (String s : Config.flimFlamBlacklist) {
                if (validNames.contains(s)) {
                    blacklist.add(s);
                    continue;
                }
                Log.warn((String)"Trying to blacklist unknown flimflam name '%s'", (Object[])new Object[]{s});
            }
        }
        return blacklist;
    }

    @ForgeSubscribe
    public void onReconfig(ConfigurationChange.Post evt) {
        if (evt.check("tomfoolery", "flimFlamBlacklist")) {
            blacklist = null;
        }
    }

    private static Luck getProperty(Entity entity) {
        IExtendedEntityProperties prop = entity.getExtendedProperties(LUCK_PROPERTY);
        return prop instanceof Luck ? (Luck)prop : null;
    }

    @ForgeSubscribe
    public void onEntityConstruct(EntityEvent.EntityConstructing evt) {
        if (evt.entity instanceof EntityPlayer) {
            evt.entity.registerExtendedProperties(LUCK_PROPERTY, (IExtendedEntityProperties)new Luck());
        }
    }

    @ForgeSubscribe
    public void onDamage(LivingHurtEvent e) {
        int flimFlamsToApply;
        EntityPlayer flimFlamTarget;
        if (!(e.entityLiving instanceof EntityPlayer)) {
            return;
        }
        if (e.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer targetPlayer = (EntityPlayer)e.entityLiving;
        if (e.source == null) {
            return;
        }
        Entity damageSource = e.source.func_76346_g();
        if (!(damageSource instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer sourcePlayer = (EntityPlayer)damageSource;
        if (sourcePlayer == targetPlayer) {
            return;
        }
        int sourceFlimFlam = FlimFlamEnchantmentsHandler.getFlimFlamToolLevel(sourcePlayer);
        int targetFlimFlam = FlimFlamEnchantmentsHandler.getFlimFlamArmorLevel(targetPlayer);
        int flimFlamDiff = targetFlimFlam / 3 - sourceFlimFlam;
        if (flimFlamDiff == 0) {
            return;
        }
        if (flimFlamDiff > 0) {
            flimFlamTarget = sourcePlayer;
            flimFlamsToApply = flimFlamDiff;
        } else {
            flimFlamTarget = targetPlayer;
            flimFlamsToApply = -flimFlamDiff;
        }
        Luck victimLuck = FlimFlamEnchantmentsHandler.getProperty((Entity)flimFlamTarget);
        if (victimLuck != null) {
            for (int i = 0; i < flimFlamsToApply; ++i) {
                int roll = FlimFlamEnchantmentsHandler.rollD20();
                if (roll == 20) {
                    victimLuck.forceNext = true;
                }
                victimLuck.luck -= roll;
            }
            if (victimLuck.luck < -30) {
                victimLuck.forceNext = true;
            }
        }
    }

    private static int rollD20() {
        return RANDOM.nextInt(21);
    }

    public static void deliverKarma(EntityPlayerMP player) {
        if (player.field_70128_L) {
            return;
        }
        Luck property = FlimFlamEnchantmentsHandler.getProperty((Entity)player);
        if (property == null || !FlimFlamEnchantmentsHandler.canFlimFlam(property)) {
            return;
        }
        int luck = property.luck;
        int totalWeight = 0;
        ArrayList selectedEffects = Lists.newArrayList();
        Set<String> blacklist = FlimFlamEnchantmentsHandler.getBlacklist();
        for (IFlimFlamEffect effectMeta : FlimFlamRegistry.getFlimFlams()) {
            if (!effectMeta.canApply(luck) || Config.safeFlimFlams && !effectMeta.isSafe() || blacklist.contains(effectMeta.name())) continue;
            selectedEffects.add(effectMeta);
            totalWeight += effectMeta.weight();
        }
        if (selectedEffects.isEmpty()) {
            return;
        }
        Collections.shuffle(selectedEffects);
        block3: while (!selectedEffects.isEmpty()) {
            int selectedWeight = RANDOM.nextInt(totalWeight);
            int currentWeight = 0;
            Iterator it = selectedEffects.iterator();
            while (it.hasNext()) {
                IFlimFlamEffect effectMeta = (IFlimFlamEffect)it.next();
                if (selectedWeight > (currentWeight += effectMeta.weight())) continue;
                try {
                    if (effectMeta.action().execute(player)) {
                        property.luck -= effectMeta.cost();
                        Log.fine((String)"Player %s flim-flammed with %s, current luck: %s", (Object[])new Object[]{player, effectMeta.name(), property.luck});
                        if (!effectMeta.isSilent()) {
                            player.func_70006_a(ChatMessageComponent.func_111077_e((String)"openblocks.flim_flammed"));
                        }
                        return;
                    }
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Error during flimflam '%s' execution", (Object[])new Object[]{effectMeta.name()});
                }
                totalWeight -= effectMeta.weight();
                it.remove();
                continue block3;
            }
        }
    }

    public static int getLuck(EntityPlayer player) {
        Luck property = FlimFlamEnchantmentsHandler.getProperty((Entity)player);
        return property != null ? property.luck : 0;
    }

    public static int modifyLuck(EntityPlayer player, int amount) {
        Luck property = FlimFlamEnchantmentsHandler.getProperty((Entity)player);
        if (property == null) {
            return 0;
        }
        property.luck += amount;
        return property.luck;
    }

    private static boolean canFlimFlam(Luck property) {
        if (property.forceNext) {
            property.forceNext = false;
            property.cooldown = 300;
            return true;
        }
        if (property.luck > 30 || property.cooldown-- > 0) {
            return false;
        }
        property.cooldown = 300;
        double probability = 1.5 * Math.abs(Math.atan((double)property.luck / 250.0) / Math.PI);
        double r = RANDOM.nextDouble();
        return r < probability;
    }

    private static int getFlimFlamToolLevel(EntityPlayer player) {
        return FlimFlamEnchantmentsHandler.getFlimFlamLevel(player.func_70694_bm());
    }

    private static int getFlimFlamArmorLevel(EntityPlayer player) {
        int sum = 0;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            sum += FlimFlamEnchantmentsHandler.getFlimFlamLevel(stack);
        }
        return sum;
    }

    private static int getFlimFlamLevel(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        Integer result = (Integer)enchantments.get(OpenBlocks.Enchantments.flimFlam.field_77352_x);
        return result != null ? result : 0;
    }

    private static class Luck
    implements IExtendedEntityProperties {
        public int luck;
        public int cooldown;
        public boolean forceNext;

        private Luck() {
        }

        public void saveNBTData(NBTTagCompound entityTag) {
            entityTag.func_74768_a(FlimFlamEnchantmentsHandler.LUCK_PROPERTY, this.luck);
        }

        public void loadNBTData(NBTTagCompound entityTag) {
            this.luck = entityTag.func_74762_e(FlimFlamEnchantmentsHandler.LUCK_PROPERTY);
        }

        public void init(Entity entity, World world) {
        }
    }
}

