/*
 * Decompiled with CFR 0.152.
 */
package openblocks.events;

import java.io.DataInput;
import java.io.DataOutput;
import openblocks.common.Stencil;
import openblocks.events.EventTypes;
import openmods.network.IEventPacketType;
import openmods.network.events.TileEntityMessageEventPacket;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.ByteUtils;

public class StencilCraftEvent
extends TileEntityMessageEventPacket {
    private Stencil stencil;

    public StencilCraftEvent() {
    }

    public StencilCraftEvent(OpenTileEntity te, Stencil stencil) {
        super(te);
        this.stencil = stencil;
    }

    protected void readPayload(DataInput input) {
        int stencilId = ByteUtils.readVLI((DataInput)input);
        this.stencil = Stencil.values()[stencilId];
    }

    protected void writePayload(DataOutput output) {
        ByteUtils.writeVLI((DataOutput)output, (int)this.stencil.ordinal());
    }

    public Stencil getStencil() {
        return this.stencil;
    }

    public IEventPacketType getType() {
        return EventTypes.STENCIL_CRAFT;
    }
}

