/*
 * Decompiled with CFR 0.152.
 */
package openblocks.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StatCollector;
import openblocks.OpenBlocks;
import openmods.Log;
import openmods.utils.ItemUtils;

public class ChangelogBuilder {
    public static ItemStack createChangeLog(String version) {
        String filename = String.format("/openblocks/changelogs/%s", version);
        InputStream input = OpenBlocks.class.getResourceAsStream(filename);
        if (input != null) {
            ItemStack book = new ItemStack(Item.field_77823_bG);
            NBTTagCompound bookTag = ItemUtils.getItemTag((ItemStack)book);
            bookTag.func_74778_a("title", StatCollector.func_74837_a((String)"openblocks.changelog.title", (Object[])new Object[]{version}));
            bookTag.func_74778_a("author", "The OpenMods team");
            NBTTagList bookPages = new NBTTagList("pages");
            bookTag.func_74782_a("pages", (NBTBase)bookPages);
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            try {
                int pageNumber = 1;
                StringBuilder pageInfo = new StringBuilder();
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (line.equals("EOP")) {
                        bookPages.func_74742_a((NBTBase)new NBTTagString(Integer.toString(pageNumber++), pageInfo.toString()));
                        pageInfo = new StringBuilder();
                        continue;
                    }
                    pageInfo.append(line);
                    pageInfo.append("\n");
                }
            }
            catch (IOException e) {
                Log.warn((Throwable)e, (String)"Failed to read changelog", (Object[])new Object[0]);
            }
            return book;
        }
        return null;
    }
}

