/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.media.IMediaProvider;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import java.lang.reflect.Method;
import net.minecraft.world.World;

public final class ComputerCraftAPI {
    private static boolean ccSearched = false;
    private static Class computerCraft = null;
    private static Method computerCraft_createUniqueNumberedSaveDir = null;
    private static Method computerCraft_createSaveDirMount = null;
    private static Method computerCraft_createResourceMount = null;
    private static Method computerCraft_registerPeripheralProvider = null;
    private static Method computerCraft_registerTurtleUpgrade = null;
    private static Method computerCraft_registerBundledRedstoneProvider = null;
    private static Method computerCraft_getDefaultBundledRedstoneOutput = null;
    private static Method computerCraft_registerMediaProvider = null;

    public static int createUniqueNumberedSaveDir(World world, String parentSubPath) {
        ComputerCraftAPI.findCC();
        if (computerCraft_createUniqueNumberedSaveDir != null) {
            try {
                return (Integer)computerCraft_createUniqueNumberedSaveDir.invoke(null, world, parentSubPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public static IWritableMount createSaveDirMount(World world, String subPath, long capacity) {
        ComputerCraftAPI.findCC();
        if (computerCraft_createSaveDirMount != null) {
            try {
                return (IWritableMount)computerCraft_createSaveDirMount.invoke(null, world, subPath, capacity);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public static IMount createResourceMount(Class modClass, String domain, String subPath) {
        ComputerCraftAPI.findCC();
        if (computerCraft_createResourceMount != null) {
            try {
                return (IMount)computerCraft_createResourceMount.invoke(null, modClass, domain, subPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void registerPeripheralProvider(IPeripheralProvider handler) {
        ComputerCraftAPI.findCC();
        if (computerCraft_registerPeripheralProvider != null) {
            try {
                computerCraft_registerPeripheralProvider.invoke(null, handler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void registerTurtleUpgrade(ITurtleUpgrade upgrade) {
        if (upgrade != null) {
            ComputerCraftAPI.findCC();
            if (computerCraft_registerTurtleUpgrade != null) {
                try {
                    computerCraft_registerTurtleUpgrade.invoke(null, upgrade);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void registerBundledRedstoneProvider(IBundledRedstoneProvider handler) {
        ComputerCraftAPI.findCC();
        if (computerCraft_registerBundledRedstoneProvider != null) {
            try {
                computerCraft_registerBundledRedstoneProvider.invoke(null, handler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getBundledRedstoneOutput(World world, int x, int y, int z, int side) {
        ComputerCraftAPI.findCC();
        if (computerCraft_getDefaultBundledRedstoneOutput != null) {
            try {
                return (Integer)computerCraft_getDefaultBundledRedstoneOutput.invoke(null, world, x, y, z, side);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return -1;
    }

    public static void registerMediaProvider(IMediaProvider handler) {
        ComputerCraftAPI.findCC();
        if (computerCraft_registerMediaProvider != null) {
            try {
                computerCraft_registerMediaProvider.invoke(null, handler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findCC() {
        if (!ccSearched) {
            try {
                computerCraft = Class.forName("dan200.computercraft.ComputerCraft");
                computerCraft_createUniqueNumberedSaveDir = ComputerCraftAPI.findCCMethod("createUniqueNumberedSaveDir", new Class[]{World.class, String.class});
                computerCraft_createSaveDirMount = ComputerCraftAPI.findCCMethod("createSaveDirMount", new Class[]{World.class, String.class, Long.TYPE});
                computerCraft_createResourceMount = ComputerCraftAPI.findCCMethod("createResourceMount", new Class[]{Class.class, String.class, String.class});
                computerCraft_registerPeripheralProvider = ComputerCraftAPI.findCCMethod("registerPeripheralProvider", new Class[]{IPeripheralProvider.class});
                computerCraft_registerTurtleUpgrade = ComputerCraftAPI.findCCMethod("registerTurtleUpgrade", new Class[]{ITurtleUpgrade.class});
                computerCraft_registerBundledRedstoneProvider = ComputerCraftAPI.findCCMethod("registerBundledRedstoneProvider", new Class[]{IBundledRedstoneProvider.class});
                computerCraft_getDefaultBundledRedstoneOutput = ComputerCraftAPI.findCCMethod("getDefaultBundledRedstoneOutput", new Class[]{World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
                computerCraft_registerMediaProvider = ComputerCraftAPI.findCCMethod("registerMediaProvider", new Class[]{IMediaProvider.class});
            }
            catch (Exception e) {
                System.out.println("ComputerCraftAPI: ComputerCraft not found.");
            }
            finally {
                ccSearched = true;
            }
        }
    }

    private static Method findCCMethod(String name, Class[] args) {
        try {
            return computerCraft.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            System.out.println("ComputerCraftAPI: ComputerCraft method " + name + " not found.");
            return null;
        }
    }
}

